/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Date;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import jetbrains.exodus.env.ContextualEnvironmentImpl;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionalExecutable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u0011\u001a\u00020\u000f*\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Ljetbrains/exodus/env/StuckTransactionMonitor;", "Ljetbrains/exodus/core/execution/Job;", "env", "Ljetbrains/exodus/env/EnvironmentImpl;", "(Ljetbrains/exodus/env/EnvironmentImpl;)V", "getEnv", "()Ljetbrains/exodus/env/EnvironmentImpl;", "envRef", "Ljava/lang/ref/WeakReference;", "<set-?>", "", "stuckTxnCount", "getStuckTxnCount", "()I", "execute", "", "queueThis", "forEachExpiredTransaction", "callback", "Lkotlin/Function1;", "Ljetbrains/exodus/env/TransactionBase;", "Companion", "xodus-environment"})
public final class StuckTransactionMonitor
extends Job {
    private final WeakReference<EnvironmentImpl> envRef;
    private int stuckTxnCount;
    public static final Companion Companion = new Companion(null);

    public final int getStuckTxnCount() {
        return this.stuckTxnCount;
    }

    private final EnvironmentImpl getEnv() {
        return (EnvironmentImpl)this.envRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void execute() {
        EnvironmentImpl env = this.getEnv();
        if (env != null && env.isOpen()) {
            void stuckTxnCount;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            try {
                this.forEachExpiredTransaction(env.transactionTimeout(), (Function1<? super TransactionBase, Unit>)((Function1)new Function1<TransactionBase, Unit>((Ref.IntRef)stuckTxnCount){
                    final /* synthetic */ Ref.IntRef $stuckTxnCount;

                    public final void invoke(@NotNull TransactionBase it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Throwable trace = it.getTrace();
                        if (trace != null) {
                            Thread thread = it.getCreatingThread();
                            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"it.creatingThread");
                            Thread creatingThread = thread;
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            PrintStream ps = new PrintStream(out);
                            String msg = "Transaction timed out: created at " + new Date(it.getStartTime()) + ", thread = " + creatingThread + '(' + creatingThread.getId() + ')';
                            OutputStream outputStream = ps;
                            Charset charset = Charsets.UTF_8;
                            boolean bl = false;
                            new OutputStreamWriter(outputStream, charset).write(msg);
                            trace.printStackTrace(ps);
                            StuckTransactionMonitor.Companion.getLogger().info(msg, trace);
                            Ref.IntRef intRef = this.$stuckTxnCount;
                            ++intRef.element;
                            int cfr_ignored_0 = intRef.element;
                        }
                    }
                    {
                        this.$stuckTxnCount = intRef;
                        super(1);
                    }
                }));
                this.forEachExpiredTransaction(env.transactionExpirationTimeout(), (Function1<? super TransactionBase, Unit>)((Function1)new Function1<TransactionBase, Unit>(env){
                    final /* synthetic */ EnvironmentImpl $env;

                    public final void invoke(@NotNull TransactionBase txn) {
                        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                        if (this.$env instanceof ContextualEnvironmentImpl) {
                            ((ContextualEnvironmentImpl)this.$env).finishTransactionUnsafe(txn);
                        } else {
                            this.$env.finishTransaction(txn);
                        }
                    }
                    {
                        this.$env = environmentImpl;
                        super(1);
                    }
                }));
            }
            finally {
                this.stuckTxnCount = stuckTxnCount.element;
                this.queueThis(env);
            }
        }
    }

    private final void queueThis(EnvironmentImpl env) {
        JobProcessor jobProcessor = this.getProcessor();
        Job job = this;
        EnvironmentConfig environmentConfig = env.getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"env.environmentConfig");
        jobProcessor.queueIn(job, (long)environmentConfig.getEnvMonitorTxnsCheckFreq());
    }

    private final void forEachExpiredTransaction(int $this$forEachExpiredTransaction, Function1<? super TransactionBase, Unit> callback) {
        block1: {
            if ($this$forEachExpiredTransaction == 0) break block1;
            long timeBound = System.currentTimeMillis() - (long)$this$forEachExpiredTransaction;
            EnvironmentImpl environmentImpl = this.getEnv();
            if (environmentImpl != null) {
                environmentImpl.forEachActiveTransaction(new TransactionalExecutable(timeBound, callback){
                    final /* synthetic */ long $timeBound;
                    final /* synthetic */ Function1 $callback;

                    public final void execute(@NotNull Transaction it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        TransactionBase txn = (TransactionBase)it;
                        if (txn.getStartTime() < this.$timeBound) {
                            this.$callback.invoke((Object)it);
                        }
                    }
                    {
                        this.$timeBound = l;
                        this.$callback = function1;
                    }
                });
            }
        }
    }

    public StuckTransactionMonitor(@NotNull EnvironmentImpl env) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        this.envRef = new WeakReference<EnvironmentImpl>(env);
        this.setProcessor((JobProcessor)ThreadJobProcessorPool.getOrCreateJobProcessor((String)"Exodus shared stuck transaction monitor"));
        this.queueThis(env);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/env/StuckTransactionMonitor$Companion;", "Lmu/KLogging;", "()V", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

