/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.UnsafeKt;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.FileDataReader;
import jetbrains.exodus.io.WatchingFileDataReader;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.system.JVMConstants;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u001a\u001a\u00020\u00142\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\fJ\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tRD\u0010\n\u001a8\u00124\u00122\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ljetbrains/exodus/io/WatchingFileDataReader;", "Ljetbrains/exodus/io/DataReader;", "envGetter", "Lkotlin/Function0;", "Ljetbrains/exodus/env/EnvironmentImpl;", "fileDataReader", "Ljetbrains/exodus/io/FileDataReader;", "(Lkotlin/jvm/functions/Function0;Ljetbrains/exodus/io/FileDataReader;)V", "getFileDataReader$xodus_environment", "()Ljetbrains/exodus/io/FileDataReader;", "newDataListeners", "", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "prevHighAddress", "newHighAddress", "", "stopped", "", "watchKey", "Ljava/nio/file/WatchKey;", "kotlin.jvm.PlatformType", "watchService", "Ljava/nio/file/WatchService;", "addNewDataListener", "listener", "close", "doUpdate", "force", "currentThread", "Ljava/lang/Thread;", "doWatch", "getBlocks", "", "Ljetbrains/exodus/io/Block;", "fromAddress", "getLocation", "", "Companion", "xodus-environment"})
public final class WatchingFileDataReader
implements DataReader {
    private final WatchService watchService;
    private final WatchKey watchKey;
    private final List<Function2<Long, Long, Unit>> newDataListeners;
    private volatile boolean stopped;
    private final Function0<EnvironmentImpl> envGetter;
    @NotNull
    private final FileDataReader fileDataReader;
    private static final long IDLE_FORCE_CHECK_INTERVAL = 3000L;
    private static final long DEBOUNCE_INTERVAL = 100L;
    private static final WatchEvent.Kind<Path>[] EVENT_KINDS;
    public static final Companion Companion;

    @NotNull
    public String getLocation() {
        return this.fileDataReader.getLocation();
    }

    @NotNull
    public Iterable<Block> getBlocks() {
        return this.fileDataReader.getBlocks();
    }

    @NotNull
    public Iterable<Block> getBlocks(long fromAddress) {
        return this.fileDataReader.getBlocks(fromAddress);
    }

    public void close() {
        this.stopped = true;
        this.watchKey.cancel();
        this.watchService.close();
        this.fileDataReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addNewDataListener(@NotNull Function2<? super Long, ? super Long, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        List<Function2<Long, Long, Unit>> list = this.newDataListeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.newDataListeners.add(listener);
        }
        return bl2;
    }

    private final void doWatch() {
        Thread currentThread = Thread.currentThread();
        long lastIdle = Long.MIN_VALUE;
        while (!this.stopped) {
            try {
                long debounce;
                WatchKey watchKey = null;
                boolean hasFileUpdates = false;
                try {
                    List<WatchEvent<?>> events;
                    WatchKey watchKey2 = watchKey = this.watchService.poll(100L, TimeUnit.MILLISECONDS);
                    List<WatchEvent<Object>> list = events = watchKey2 != null ? watchKey2.pollEvents() : null;
                    if (events == null || events.isEmpty()) {
                        if (lastIdle <= Long.MIN_VALUE || System.currentTimeMillis() - lastIdle <= 3000L) continue;
                        Thread thread = currentThread;
                        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
                        lastIdle = this.doUpdate(true, thread);
                        continue;
                    }
                    for (WatchEvent<?> event : events) {
                        Object eventContext = event.context();
                        if (!(eventContext instanceof Path) || !LogUtil.LOG_FILE_NAME_FILTER.accept(null, ((Object)((Path)eventContext).getFileName()).toString())) continue;
                        hasFileUpdates = true;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Companion.getLogger().warn((Throwable)e, (Function0)doWatch.1.INSTANCE);
                    currentThread.interrupt();
                    return;
                }
                catch (ClosedWatchServiceException ignore) {
                    return;
                }
                if (lastIdle > Long.MIN_VALUE && (debounce = 100L + (lastIdle - System.currentTimeMillis())) > (long)5) {
                    try {
                        Thread.sleep(debounce);
                    }
                    catch (InterruptedException e) {
                        currentThread.interrupt();
                        return;
                    }
                }
                if (hasFileUpdates) {
                    Thread thread = currentThread;
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
                    lastIdle = this.doUpdate(false, thread);
                }
                if (watchKey.reset()) continue;
                Companion.getLogger().info((Function0)new Function0<String>(currentThread){
                    final /* synthetic */ Thread $currentThread;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Watch service is no longer valid for ");
                        Thread thread = this.$currentThread;
                        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
                        return stringBuilder.append(thread.getName()).append(", exiting...").toString();
                    }
                    {
                        this.$currentThread = thread;
                        super(0);
                    }
                });
                return;
            }
            catch (Throwable t) {
                Companion.getLogger().error(t, (Function0)new Function0<String>(currentThread){
                    final /* synthetic */ Thread $currentThread;

                    public final String invoke() {
                        Thread thread = this.$currentThread;
                        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
                        return thread.getName();
                    }
                    {
                        this.$currentThread = thread;
                        super(0);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long doUpdate(boolean force, Thread currentThread) {
        block9: {
            EnvironmentImpl environmentImpl = (EnvironmentImpl)this.envGetter.invoke();
            if (environmentImpl == null) break block9;
            EnvironmentImpl environmentImpl2 = environmentImpl;
            boolean bl = false;
            boolean bl2 = false;
            EnvironmentImpl $this$run = environmentImpl2;
            boolean bl3 = false;
            LogTip prevTip = $this$run.getLog().getTip();
            if (UnsafeKt.tryUpdate($this$run)) {
                Companion.getLogger().debug((Function0)new Function0<String>($this$run, this, force, currentThread){
                    final /* synthetic */ EnvironmentImpl $this_run;
                    final /* synthetic */ WatchingFileDataReader this$0;
                    final /* synthetic */ boolean $force$inlined;
                    final /* synthetic */ Thread $currentThread$inlined;
                    {
                        this.$this_run = environmentImpl;
                        this.this$0 = watchingFileDataReader;
                        this.$force$inlined = bl;
                        this.$currentThread$inlined = thread;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return (this.$force$inlined ? "Env force-updated at " : "Env updated at ") + this.$this_run.getLocation();
                    }
                });
                long newHighAddress = $this$run.getLog().getTip().approvedHighAddress;
                long prevHighAddress = prevTip.approvedHighAddress;
                if (newHighAddress > prevHighAddress) {
                    Object[] objectArray;
                    List<Function2<Long, Long, Unit>> list = this.newDataListeners;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    synchronized (list) {
                        boolean bl6 = false;
                        Collection $this$toTypedArray$iv = this.newDataListeners;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Function2[] function2Array = thisCollection$iv.toArray(new Function2[0]);
                        if (function2Array == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        objectArray = function2Array;
                    }
                    Object[] $this$forEach$iv = objectArray;
                    boolean $i$f$forEach = false;
                    objectArray = $this$forEach$iv;
                    int n = objectArray.length;
                    for (int j = 0; j < n; ++j) {
                        Function2 element$iv;
                        Function2 listener = element$iv = objectArray[j];
                        boolean bl7 = false;
                        try {
                            listener.invoke((Object)prevHighAddress, (Object)newHighAddress);
                            continue;
                        }
                        catch (Throwable t) {
                            Companion.getLogger().error(t, (Function0)new Function0<String>(prevHighAddress, newHighAddress, this, force, currentThread){
                                final /* synthetic */ long $prevHighAddress$inlined;
                                final /* synthetic */ long $newHighAddress$inlined;
                                final /* synthetic */ WatchingFileDataReader this$0;
                                final /* synthetic */ boolean $force$inlined;
                                final /* synthetic */ Thread $currentThread$inlined;
                                {
                                    this.$prevHighAddress$inlined = l;
                                    this.$newHighAddress$inlined = l2;
                                    this.this$0 = watchingFileDataReader;
                                    this.$force$inlined = bl;
                                    this.$currentThread$inlined = thread;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    return "New data listener failed for " + this.$currentThread$inlined.getName();
                                }
                            });
                        }
                    }
                    return Long.MIN_VALUE;
                }
            }
            Companion.getLogger().debug((Function0)new Function0<String>($this$run, this, force, currentThread){
                final /* synthetic */ EnvironmentImpl $this_run;
                final /* synthetic */ WatchingFileDataReader this$0;
                final /* synthetic */ boolean $force$inlined;
                final /* synthetic */ Thread $currentThread$inlined;
                {
                    this.$this_run = environmentImpl;
                    this.this$0 = watchingFileDataReader;
                    this.$force$inlined = bl;
                    this.$currentThread$inlined = thread;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return (this.$force$inlined ? "Can't force-update env at " : "Can't update env at ") + this.$this_run.getLocation();
                }
            });
        }
        return System.currentTimeMillis();
    }

    @NotNull
    public final FileDataReader getFileDataReader$xodus_environment() {
        return this.fileDataReader;
    }

    public WatchingFileDataReader(@NotNull Function0<? extends EnvironmentImpl> envGetter, @NotNull FileDataReader fileDataReader) {
        Intrinsics.checkParameterIsNotNull(envGetter, (String)"envGetter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fileDataReader), (String)"fileDataReader");
        this.envGetter = envGetter;
        this.fileDataReader = fileDataReader;
        this.watchService = FileSystems.getDefault().newWatchService();
        Path path = this.fileDataReader.getDir().toPath();
        WatchingFileDataReader watchingFileDataReader = this;
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        Object object = JVMConstants.INSTANCE.getIS_MAC() ? it.register(this.watchService, EVENT_KINDS, SensitivityWatchEventModifier.HIGH) : it.register(this.watchService, EVENT_KINDS, new WatchEvent.Modifier[0]);
        watchingFileDataReader.watchKey = object;
        watchingFileDataReader = this;
        boolean bl4 = false;
        watchingFileDataReader.newDataListeners = object = (List)new ArrayList();
        Thread thread = new Thread(new Runnable(){

            @Override
            public final void run() {
                this.doWatch();
            }
        });
        bl = false;
        bl2 = false;
        Thread $this$apply = thread;
        boolean bl5 = false;
        $this$apply.setName("Xodus watcher for " + this.fileDataReader.getDir());
        thread.start();
    }

    static {
        Companion = new Companion(null);
        EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R:\u0010\u0005\u001a,\u0012(\u0012&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/exodus/io/WatchingFileDataReader$Companion;", "Lmu/KLogging;", "()V", "DEBOUNCE_INTERVAL", "", "EVENT_KINDS", "", "Ljava/nio/file/WatchEvent$Kind;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "[Ljava/nio/file/WatchEvent$Kind;", "IDLE_FORCE_CHECK_INTERVAL", "xodus-environment"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

