/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.util.Arrays;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.log.BlockByteIterator;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.util.ByteIterableUtil;
import org.jetbrains.annotations.NotNull;

class ArrayByteIterableWithAddress
extends ByteIterableWithAddress {
    @NotNull
    private final byte[] bytes;
    private final int start;
    private final int end;

    ArrayByteIterableWithAddress(long address, @NotNull byte[] bytes, int start, int length) {
        super(address);
        this.bytes = bytes;
        this.start = start;
        this.end = Math.min(start + length, bytes.length);
    }

    @Override
    public byte byteAt(int offset) {
        return this.bytes[this.start + offset];
    }

    @Override
    public long nextLong(int offset, int length) {
        return LongBinding.entryToUnsignedLong((byte[])this.bytes, (int)(this.start + offset), (int)length);
    }

    @Override
    public int getCompressedUnsignedInt() {
        int result = 0;
        int shift = 0;
        int i2 = this.start;
        while (true) {
            byte b = this.bytes[i2];
            result += (b & 0x7F) << shift;
            if ((b & 0x80) != 0) {
                return result;
            }
            shift += 7;
            ++i2;
        }
    }

    @Override
    public ByteIteratorWithAddress iterator() {
        return this.iterator(0);
    }

    @Override
    public ByteIteratorWithAddress iterator(int offset) {
        return new ArrayByteIteratorWithAddress(offset);
    }

    @Override
    public int compareTo(int offset, int len, @NotNull ByteIterable right) {
        if (right instanceof SubIterable) {
            SubIterable r = (SubIterable)right;
            return ByteIterableUtil.compare((byte[])this.bytes, (int)len, (int)(this.start + offset), (byte[])r.getRawBytes(), (int)r.getLength(), (int)r.offset);
        }
        return ByteIterableUtil.compare((byte[])this.bytes, (int)len, (int)(this.start + offset), (byte[])right.getBytesUnsafe(), (int)right.getLength());
    }

    @Override
    public ByteIterableWithAddress clone(int offset) {
        return new ArrayByteIterableWithAddress(this.getDataAddress() + (long)offset, this.bytes, this.start + offset, this.end - this.start - offset);
    }

    @Override
    public int getLength() {
        return this.end - this.start;
    }

    @Override
    @NotNull
    public ByteIterable subIterable(int offset, int length) {
        int adjustedLen = Math.min(length, Math.max(this.getLength() - offset, 0));
        return adjustedLen == 0 ? ArrayByteIterable.EMPTY : new SubIterable(this.bytes, this.start + offset, adjustedLen);
    }

    public String toString() {
        return ByteIterableBase.toString((byte[])this.bytes, (int)this.start, (int)this.end);
    }

    private static class SubIterable
    extends ByteIterableBase {
        private int offset;

        SubIterable(@NotNull byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        public int compareTo(@NotNull ByteIterable right) {
            if (right instanceof SubIterable) {
                SubIterable r = (SubIterable)right;
                return ByteIterableUtil.compare((byte[])this.bytes, (int)this.length, (int)this.offset, (byte[])r.bytes, (int)r.length, (int)r.offset);
            }
            return ByteIterableUtil.compare((byte[])this.bytes, (int)this.length, (int)this.offset, (byte[])right.getBytesUnsafe(), (int)right.getLength());
        }

        public ByteIterator iterator() {
            return this.getIterator();
        }

        protected ByteIterator getIterator() {
            return new SubIterableByteIterator();
        }

        public byte[] getBytesUnsafe() {
            if (this.offset > 0) {
                this.bytes = Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
                this.offset = 0;
            }
            return this.bytes;
        }

        private byte[] getRawBytes() {
            return this.bytes;
        }

        private class SubIterableByteIterator
        extends ByteIterator
        implements BlockByteIterator {
            int i;

            private SubIterableByteIterator() {
                this.i = SubIterable.this.offset;
            }

            public boolean hasNext() {
                return SubIterable.this.length > this.i - SubIterable.this.offset;
            }

            public byte next() {
                return SubIterable.this.bytes[this.i++];
            }

            public long skip(long bytes) {
                int result = Math.min(SubIterable.this.length - this.i + SubIterable.this.offset, (int)bytes);
                this.i += result;
                return result;
            }

            @Override
            public int nextBytes(byte[] array, int off, int len) {
                int result = Math.min(SubIterable.this.length - this.i + SubIterable.this.offset, len);
                System.arraycopy(SubIterable.this.bytes, this.i, array, off, result);
                this.i += result;
                return result;
            }
        }
    }

    private class ArrayByteIteratorWithAddress
    extends ByteIteratorWithAddress {
        private int i;

        ArrayByteIteratorWithAddress(int offset) {
            this.i = ArrayByteIterableWithAddress.this.start + offset;
        }

        @Override
        public long getAddress() {
            return ArrayByteIterableWithAddress.this.getDataAddress() + (long)this.i - (long)ArrayByteIterableWithAddress.this.start;
        }

        public boolean hasNext() {
            return this.i < ArrayByteIterableWithAddress.this.end;
        }

        public byte next() {
            return ArrayByteIterableWithAddress.this.bytes[this.i++];
        }

        public long skip(long bytes) {
            int skipped = Math.min(ArrayByteIterableWithAddress.this.end - this.i, (int)bytes);
            this.i += skipped;
            return skipped;
        }

        @Override
        public int getOffset() {
            return this.i;
        }

        public long nextLong(int length) {
            long result = LongBinding.entryToUnsignedLong((byte[])ArrayByteIterableWithAddress.this.bytes, (int)this.i, (int)length);
            this.i += length;
            return result;
        }
    }
}

