/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.io.File;
import java.io.FilenameFilter;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.util.IOUtil;
import org.jetbrains.annotations.NotNull;

public final class LogUtil {
    public static final int LOG_BLOCK_ALIGNMENT = 1024;
    public static final int LOG_FILE_NAME_LENGTH = 11;
    public static final int LOG_FILE_EXTENSION_LENGTH = 3;
    public static final int LOG_FILE_NAME_WITH_EXT_LENGTH = 14;
    public static final String LOG_FILE_EXTENSION = ".xd";
    public static final FilenameFilter LOG_FILE_NAME_FILTER = (dir, name) -> name.length() == 14 && name.endsWith(LOG_FILE_EXTENSION);
    private static final char[] LOG_FILE_EXTENSION_CHARS = ".xd".toCharArray();
    private static final char[] LOG_FILE_NAME_ALPHABET = "0123456789abcdefghijklmnopqrstuv".toCharArray();
    private static final IntHashMap<Integer> ALPHA_INDEXES = new IntHashMap();

    private LogUtil() {
    }

    public static String getLogFilename(long address) {
        if (address < 0L) {
            throw new ExodusException("Starting address of a log file is negative: " + address);
        }
        if (address % 1024L != 0L) {
            throw new ExodusException("Starting address of a log file is badly aligned: " + address);
        }
        address /= 1024L;
        char[] name = new char[14];
        for (int i2 = 1; i2 <= 11; ++i2) {
            name[11 - i2] = LOG_FILE_NAME_ALPHABET[(int)(address & 0x1FL)];
            address >>= 5;
        }
        System.arraycopy(LOG_FILE_EXTENSION_CHARS, 0, name, 11, 3);
        return new String(name);
    }

    public static long getAddress(String logFilename) {
        int length = logFilename.length();
        if (length != 14 || !logFilename.endsWith(LOG_FILE_EXTENSION)) {
            throw new ExodusException("Invalid log file name: " + logFilename);
        }
        long address = 0L;
        for (int i2 = 0; i2 < 11; ++i2) {
            char c = logFilename.charAt(i2);
            Integer integer = (Integer)ALPHA_INDEXES.get((int)c);
            if (integer == null) {
                throw new ExodusException("Invalid log file name: " + logFilename);
            }
            address = (address << 5) + (long)integer.intValue();
        }
        return address * 1024L;
    }

    public static boolean isLogFile(@NotNull File file) {
        return LogUtil.isLogFileName(file.getName());
    }

    public static boolean isLogFileName(@NotNull String name) {
        try {
            LogUtil.getAddress(name);
            return true;
        }
        catch (ExodusException e) {
            return false;
        }
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory) {
        return IOUtil.listFiles((File)directory, (FilenameFilter)LOG_FILE_NAME_FILTER);
    }

    @NotNull
    public static LongArrayList listFileAddresses(@NotNull File directory) {
        File[] files = LogUtil.listFiles(directory);
        LongArrayList result = new LongArrayList(files.length);
        for (File file : files) {
            result.add(LogUtil.getAddress(file.getName()));
        }
        return result;
    }

    @NotNull
    public static LongArrayList listFileAddresses(long fromAddress, @NotNull File directory) {
        File[] files = LogUtil.listFiles(directory);
        LongArrayList result = new LongArrayList();
        for (File file : files) {
            long address = LogUtil.getAddress(file.getName());
            if (address < fromAddress) continue;
            result.add(address);
        }
        return result;
    }

    public static String getWrongAddressErrorMessage(long address, long fileLengthBound) {
        long fileAddress = address - address % fileLengthBound;
        return ", address = " + address + ", file = " + LogUtil.getLogFilename(fileAddress);
    }

    static {
        char[] alphabet = LOG_FILE_NAME_ALPHABET;
        for (int i2 = 0; i2 < alphabet.length; ++i2) {
            ALPHA_INDEXES.put((int)alphabet[i2], (Object)i2);
        }
    }
}

