/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.SoftConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.SoftLongObjectCache;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import jetbrains.exodus.log.SharedLogCacheKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001%B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB/\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\b\u0010!\u001a\u00020\"H\u0016J\u001d\u0010#\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b$R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Ljetbrains/exodus/log/SharedLogCache;", "Ljetbrains/exodus/log/LogCache;", "memoryUsage", "", "pageSize", "", "nonBlocking", "", "useSoftReferences", "cacheGenerationCount", "(JIZZI)V", "memoryUsagePercentage", "(IIZZI)V", "pagesCache", "Ljetbrains/exodus/core/dataStructures/LongObjectCacheBase;", "Ljetbrains/exodus/log/SharedLogCache$CachedValue;", "getUseSoftReferences$xodus_environment", "()Z", "cachePage", "", "log", "Ljetbrains/exodus/log/Log;", "pageAddress", "page", "", "key", "logIdentity", "address", "clear", "getCachedPage", "getPage", "getPageIterable", "Ljetbrains/exodus/ArrayByteIterable;", "hitRate", "", "removePage", "removePage$xodus_environment", "CachedValue", "xodus-environment"})
public final class SharedLogCache
extends LogCache {
    private final LongObjectCacheBase<CachedValue> pagesCache;
    private final boolean useSoftReferences;

    public final boolean getUseSoftReferences$xodus_environment() {
        return this.useSoftReferences;
    }

    @Override
    public void clear() {
    }

    @Override
    public float hitRate() {
        return this.pagesCache.hitRate();
    }

    @Override
    public void cachePage(@NotNull Log log, long pageAddress, @NotNull byte[] page) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        int n = log.getIdentity();
        boolean bl = false;
        boolean bl2 = false;
        int logIdentity = n;
        boolean bl3 = false;
        this.cachePage(SharedLogCacheKt.access$getLogPageFingerPrint(logIdentity, pageAddress), logIdentity, pageAddress, page);
    }

    @Override
    @NotNull
    public byte[] getPage(@NotNull Log log, long pageAddress) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        int logIdentity = log.getIdentity();
        long key = SharedLogCacheKt.access$getLogPageFingerPrint(logIdentity, pageAddress);
        CachedValue cachedValue = (CachedValue)this.pagesCache.tryKeyLocked(key);
        if (cachedValue != null && cachedValue.getLogIdentity() == logIdentity && cachedValue.getAddress() == pageAddress) {
            return cachedValue.getPage();
        }
        byte[] page = log.getHighPage(pageAddress);
        if (page != null) {
            return page;
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(key, logIdentity, pageAddress, page);
        return page;
    }

    @Override
    @Nullable
    public byte[] getCachedPage(@NotNull Log log, long pageAddress) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        int logIdentity = log.getIdentity();
        long key = SharedLogCacheKt.access$getLogPageFingerPrint(logIdentity, pageAddress);
        CachedValue cachedValue = (CachedValue)this.pagesCache.getObjectLocked(key);
        return cachedValue != null && cachedValue.getLogIdentity() == logIdentity && cachedValue.getAddress() == pageAddress ? cachedValue.getPage() : log.getHighPage(pageAddress);
    }

    @Override
    @NotNull
    protected ArrayByteIterable getPageIterable(@NotNull Log log, long pageAddress) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        int logIdentity = log.getIdentity();
        long key = SharedLogCacheKt.access$getLogPageFingerPrint(logIdentity, pageAddress);
        CachedValue cachedValue = (CachedValue)this.pagesCache.tryKeyLocked(key);
        if (cachedValue != null && cachedValue.getLogIdentity() == logIdentity && cachedValue.getAddress() == pageAddress) {
            return new ArrayByteIterable(cachedValue.getPage());
        }
        byte[] page = log.getHighPage(pageAddress);
        if (page != null) {
            long l = log.getHighAddress() - pageAddress;
            long l2 = this.getPageSize$xodus_environment();
            byte[] byArray = page;
            boolean bl = false;
            long l3 = Math.min(l, l2);
            int n = (int)l3;
            byte[] byArray2 = byArray;
            return new ArrayByteIterable(byArray2, n);
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(key, logIdentity, pageAddress, page);
        return new ArrayByteIterable(page);
    }

    @Override
    public void removePage$xodus_environment(@NotNull Log log, long pageAddress) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        long key = SharedLogCacheKt.access$getLogPageFingerPrint(log.getIdentity(), pageAddress);
        this.pagesCache.removeLocked(key);
    }

    private final void cachePage(long key, int logIdentity, long address, byte[] page) {
        this.pagesCache.cacheObjectLocked(key, (Object)new CachedValue(logIdentity, address, LogCache.Companion.postProcessTailPage(page)));
    }

    public SharedLogCache(long memoryUsage, int pageSize, boolean nonBlocking, boolean useSoftReferences, int cacheGenerationCount) {
        super(memoryUsage, pageSize);
        this.useSoftReferences = useSoftReferences;
        int pagesCount = (int)(memoryUsage / (long)(pageSize + 96));
        this.pagesCache = nonBlocking ? (useSoftReferences ? (LongObjectCacheBase)new SoftConcurrentLongObjectCache(pagesCount, cacheGenerationCount) : (LongObjectCacheBase)new ConcurrentLongObjectCache(pagesCount, cacheGenerationCount)) : (useSoftReferences ? (LongObjectCacheBase)new SoftLongObjectCache(pagesCount) : (LongObjectCacheBase)new LongObjectCache(pagesCount));
    }

    public SharedLogCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking, boolean useSoftReferences, int cacheGenerationCount) {
        super(memoryUsagePercentage, pageSize);
        LongObjectCacheBase longObjectCacheBase;
        this.useSoftReferences = useSoftReferences;
        if (this.getMemoryUsage() == Long.MAX_VALUE) {
            longObjectCacheBase = nonBlocking ? (useSoftReferences ? (LongObjectCacheBase)new SoftConcurrentLongObjectCache(8192, cacheGenerationCount) : (LongObjectCacheBase)new ConcurrentLongObjectCache(8192, cacheGenerationCount)) : (useSoftReferences ? (LongObjectCacheBase)new SoftLongObjectCache(8192) : (LongObjectCacheBase)new LongObjectCache());
        } else {
            int pagesCount = (int)(this.getMemoryUsage() / (long)(pageSize + (useSoftReferences ? 160 : 96)));
            longObjectCacheBase = nonBlocking ? (useSoftReferences ? (LongObjectCacheBase)new SoftConcurrentLongObjectCache(pagesCount, cacheGenerationCount) : (LongObjectCacheBase)new ConcurrentLongObjectCache(pagesCount, cacheGenerationCount)) : (useSoftReferences ? (LongObjectCacheBase)new SoftLongObjectCache(pagesCount) : (LongObjectCacheBase)new LongObjectCache(pagesCount));
        }
        this.pagesCache = longObjectCacheBase;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ljetbrains/exodus/log/SharedLogCache$CachedValue;", "", "logIdentity", "", "address", "", "page", "", "(IJ[B)V", "getAddress", "()J", "getLogIdentity", "()I", "getPage", "()[B", "xodus-environment"})
    private static final class CachedValue {
        private final int logIdentity;
        private final long address;
        @NotNull
        private final byte[] page;

        public final int getLogIdentity() {
            return this.logIdentity;
        }

        public final long getAddress() {
            return this.address;
        }

        @NotNull
        public final byte[] getPage() {
            return this.page;
        }

        public CachedValue(int logIdentity, long address, @NotNull byte[] page) {
            Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
            this.logIdentity = logIdentity;
            this.address = address;
            this.page = page;
        }
    }
}

