/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.lucene.ExodusDirectory$WhenMappings;
import jetbrains.exodus.lucene.ExodusDirectoryConfig;
import jetbrains.exodus.lucene.ExodusIndexInput;
import jetbrains.exodus.lucene.ExodusIndexOutput;
import jetbrains.exodus.lucene.FastSkippingBufferedChecksumIndexInput;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.exodus.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NoLockFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u0000 =2\u00020\u0001:\u0001=B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0013\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0%H\u0016\u00a2\u0006\u0002\u0010&J\r\u0010'\u001a\u00020#H\u0000\u00a2\u0006\u0002\b(J\u0018\u0010)\u001a\n +*\u0004\u0018\u00010*0*2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010.\u001a\u00070/\u00a2\u0006\u0002\b02\u0006\u00101\u001a\u0002022\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b3J\u0018\u00104\u001a\u0002052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0016J\u0016\u00109\u001a\u00020\u00172\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001b0;H\u0016J\b\u0010<\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006>"}, d2={"Ljetbrains/exodus/lucene/ExodusDirectory;", "Lorg/apache/lucene/store/Directory;", "env", "Ljetbrains/exodus/env/ContextualEnvironment;", "contentsStoreConfig", "Ljetbrains/exodus/env/StoreConfig;", "(Ljetbrains/exodus/env/ContextualEnvironment;Ljetbrains/exodus/env/StoreConfig;)V", "directoryConfig", "Ljetbrains/exodus/lucene/ExodusDirectoryConfig;", "(Ljetbrains/exodus/env/ContextualEnvironment;Ljetbrains/exodus/env/StoreConfig;Ljetbrains/exodus/lucene/ExodusDirectoryConfig;)V", "environment", "vfsConfig", "Ljetbrains/exodus/vfs/VfsConfig;", "(Ljetbrains/exodus/env/ContextualEnvironment;Ljetbrains/exodus/vfs/VfsConfig;Ljetbrains/exodus/env/StoreConfig;Ljetbrains/exodus/lucene/ExodusDirectoryConfig;)V", "getEnvironment", "()Ljetbrains/exodus/env/ContextualEnvironment;", "ticks", "Ljava/util/concurrent/atomic/AtomicLong;", "vfs", "Ljetbrains/exodus/vfs/VirtualFileSystem;", "getVfs", "()Ljetbrains/exodus/vfs/VirtualFileSystem;", "close", "", "createOutput", "Lorg/apache/lucene/store/IndexOutput;", "name", "", "context", "Lorg/apache/lucene/store/IOContext;", "createTempOutput", "prefix", "suffix", "deleteFile", "fileLength", "", "listAll", "", "()[Ljava/lang/String;", "nextTicks", "nextTicks$xodus_lucene_directory", "obtainLock", "Lorg/apache/lucene/store/Lock;", "kotlin.jvm.PlatformType", "openChecksumInput", "Lorg/apache/lucene/store/ChecksumIndexInput;", "openExistingFile", "Ljetbrains/exodus/vfs/File;", "Lorg/jetbrains/annotations/Nullable;", "txn", "Ljetbrains/exodus/env/Transaction;", "openExistingFile$xodus_lucene_directory", "openInput", "Lorg/apache/lucene/store/IndexInput;", "rename", "source", "dest", "sync", "names", "", "syncMetaData", "Companion", "xodus-lucene-directory"})
public final class ExodusDirectory
extends Directory {
    @NotNull
    private final VirtualFileSystem vfs;
    private final AtomicLong ticks;
    @NotNull
    private final ContextualEnvironment environment;
    private final ExodusDirectoryConfig directoryConfig;
    private static final int FIRST_CLUSTER_SIZE = 65536;
    private static final int MAX_CLUSTER_SIZE = 0x100000;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final VirtualFileSystem getVfs() {
        return this.vfs;
    }

    @NotNull
    public String[] listAll() {
        Transaction transaction = this.environment.getAndCheckCurrentTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"environment.andCheckCurrentTransaction");
        Transaction txn = transaction;
        ArrayList<String> allFiles = new ArrayList<String>((int)this.vfs.getNumberOfFiles(txn));
        Iterator iterator = this.vfs.getFiles(txn).iterator();
        while (iterator.hasNext()) {
            File file;
            File file2 = file = (File)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            allFiles.add(file2.getPath());
        }
        Collection $this$toTypedArray$iv = allFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    public void deleteFile(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.vfs.deleteFile(this.environment.getAndCheckCurrentTransaction(), name);
    }

    public long fileLength(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Transaction transaction = this.environment.getAndCheckCurrentTransaction();
        boolean bl = false;
        boolean bl2 = false;
        Transaction txn = transaction;
        boolean bl3 = false;
        Transaction transaction2 = txn;
        Intrinsics.checkExpressionValueIsNotNull((Object)transaction2, (String)"txn");
        return this.vfs.getFileLength(txn, this.openExistingFile$xodus_lucene_directory(transaction2, name));
    }

    @NotNull
    public IndexOutput createOutput(@NotNull String name, @NotNull IOContext context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new ExodusIndexOutput(this, name);
    }

    @NotNull
    public IndexOutput createTempOutput(@NotNull String prefix, @NotNull String suffix, @NotNull IOContext context) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = IndexFileNames.segmentFileName((String)prefix, (String)(suffix + "_" + this.nextTicks$xodus_lucene_directory()), (String)"tmp");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexFileNames.segmentFi\u2026g() + nextTicks(), \"tmp\")");
        return this.createOutput(string, context);
    }

    public void sync(@NotNull Collection<String> names) {
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        this.syncMetaData();
    }

    public void rename(@NotNull String source, @NotNull String dest) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        Transaction transaction = this.environment.getAndCheckCurrentTransaction();
        boolean bl = false;
        boolean bl2 = false;
        Transaction txn = transaction;
        boolean bl3 = false;
        Transaction transaction2 = txn;
        Intrinsics.checkExpressionValueIsNotNull((Object)transaction2, (String)"txn");
        this.vfs.renameFile(txn, this.openExistingFile$xodus_lucene_directory(transaction2, source), dest);
    }

    public void syncMetaData() {
        ContextualEnvironment contextualEnvironment = this.environment;
        if (contextualEnvironment == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.env.EnvironmentImpl");
        }
        ((EnvironmentImpl)contextualEnvironment).flushAndSync();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public IndexInput openInput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            int n;
            Transaction transaction = this.environment.getAndCheckCurrentTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"environment.andCheckCurrentTransaction");
            File file = this.openExistingFile$xodus_lucene_directory(transaction, name);
            IOContext.Context context2 = context.context;
            if (context2 != null) {
                switch (ExodusDirectory$WhenMappings.$EnumSwitchMapping$0[context2.ordinal()]) {
                    case 1: {
                        n = this.directoryConfig.getInputMergeBufferSize();
                        return (IndexInput)new ExodusIndexInput(this, file, n);
                    }
                }
            }
            n = this.directoryConfig.getInputBufferSize();
            return (IndexInput)new ExodusIndexInput(this, file, n);
        }
        catch (jetbrains.exodus.vfs.FileNotFoundException e) {
            throw (Throwable)new FileNotFoundException(name);
        }
    }

    @NotNull
    public ChecksumIndexInput openChecksumInput(@NotNull String name, @NotNull IOContext context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (ChecksumIndexInput)new FastSkippingBufferedChecksumIndexInput(this.openInput(name, context));
    }

    public Lock obtainLock(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return NoLockFactory.INSTANCE.obtainLock((Directory)this, name);
    }

    public void close() {
        this.vfs.shutdown();
    }

    public final long nextTicks$xodus_lucene_directory() {
        return this.ticks.getAndIncrement();
    }

    @NotNull
    public final File openExistingFile$xodus_lucene_directory(@NotNull Transaction txn, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        File file = this.vfs.openFile(txn, name, false);
        if (file == null) {
            throw (Throwable)new jetbrains.exodus.vfs.FileNotFoundException(name);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"vfs.openFile(txn, name, \u2026leNotFoundException(name)");
        return file;
    }

    @NotNull
    public final ContextualEnvironment getEnvironment() {
        return this.environment;
    }

    public ExodusDirectory(@NotNull ContextualEnvironment environment, @NotNull VfsConfig vfsConfig, @NotNull StoreConfig contentsStoreConfig, @NotNull ExodusDirectoryConfig directoryConfig) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)vfsConfig, (String)"vfsConfig");
        Intrinsics.checkParameterIsNotNull((Object)contentsStoreConfig, (String)"contentsStoreConfig");
        Intrinsics.checkParameterIsNotNull((Object)directoryConfig, (String)"directoryConfig");
        this.environment = environment;
        this.directoryConfig = directoryConfig;
        this.vfs = new VirtualFileSystem((Environment)this.environment, vfsConfig, contentsStoreConfig);
        this.ticks = new AtomicLong(System.currentTimeMillis());
    }

    @JvmOverloads
    public ExodusDirectory(@NotNull ContextualEnvironment env, @NotNull StoreConfig contentsStoreConfig) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)contentsStoreConfig, (String)"contentsStoreConfig");
        this(env, ExodusDirectory.Companion.createDefaultVfsConfig(), contentsStoreConfig, new ExodusDirectoryConfig(0, 0, 3, null));
    }

    public /* synthetic */ ExodusDirectory(ContextualEnvironment contextualEnvironment, StoreConfig storeConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            storeConfig = StoreConfig.WITHOUT_DUPLICATES;
        }
        this(contextualEnvironment, storeConfig);
    }

    @JvmOverloads
    public ExodusDirectory(@NotNull ContextualEnvironment env) {
        this(env, null, 2, null);
    }

    public ExodusDirectory(@NotNull ContextualEnvironment env, @NotNull StoreConfig contentsStoreConfig, @NotNull ExodusDirectoryConfig directoryConfig) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)contentsStoreConfig, (String)"contentsStoreConfig");
        Intrinsics.checkParameterIsNotNull((Object)directoryConfig, (String)"directoryConfig");
        this(env, ExodusDirectory.Companion.createDefaultVfsConfig(), contentsStoreConfig, directoryConfig);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/exodus/lucene/ExodusDirectory$Companion;", "", "()V", "FIRST_CLUSTER_SIZE", "", "MAX_CLUSTER_SIZE", "createDefaultVfsConfig", "Ljetbrains/exodus/vfs/VfsConfig;", "xodus-lucene-directory"})
    public static final class Companion {
        private final VfsConfig createDefaultVfsConfig() {
            VfsConfig vfsConfig = new VfsConfig();
            boolean bl = false;
            boolean bl2 = false;
            VfsConfig $this$apply = vfsConfig;
            boolean bl3 = false;
            ClusteringStrategy.QuadraticClusteringStrategy clusteringStrategy = new ClusteringStrategy.QuadraticClusteringStrategy(65536);
            clusteringStrategy.setMaxClusterSize(0x100000);
            $this$apply.setClusteringStrategy((ClusteringStrategy)clusteringStrategy);
            return vfsConfig;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

