/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.replication;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.entitystore.replication.GcTransaction;
import jetbrains.exodus.entitystore.replication.MetaServerImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.MetaTree;
import jetbrains.exodus.env.replication.ReplicationDelta;
import jetbrains.exodus.log.LogTip;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0002J\u001a\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001eH\u0002J\u001c\u0010\u001f\u001a\u00020\b*\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001e2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Ljetbrains/exodus/entitystore/replication/MetaServerHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "", "server", "Ljetbrains/exodus/entitystore/replication/MetaServerImpl;", "(Ljetbrains/exodus/entitystore/replication/MetaServerImpl;)V", "gcTransactions", "", "", "Ljetbrains/exodus/entitystore/replication/GcTransaction;", "getServer", "()Ljetbrains/exodus/entitystore/replication/MetaServerImpl;", "channelRead0", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "channelReadComplete", "exceptionCaught", "cause", "", "respond", "request", "Lio/netty/handler/codec/http/HttpRequest;", "payload", "respondEmpty", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "getString", "", "", "toLongSafe", "Companion", "OK", "xodus-multinode"})
public final class MetaServerHandler
extends SimpleChannelInboundHandler<Object> {
    private final Map<Long, GcTransaction> gcTransactions;
    @NotNull
    private final MetaServerImpl server;
    private static final AsciiString applicationJson;
    private static final AsciiString serverName;
    private static final AsciiString contentTypeKey;
    private static final AsciiString contentLengthKey;
    private static final AsciiString serverKey;
    private static final ObjectMapper mapper;
    private static final OK ok;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        if (msg instanceof HttpRequest) {
            QueryStringDecoder decoder = new QueryStringDecoder(((HttpRequest)msg).uri());
            String path = decoder.path();
            if (Intrinsics.areEqual((Object)((HttpRequest)msg).method(), (Object)HttpMethod.POST) ^ true) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_REQUEST");
                this.respondEmpty(ctx, httpResponseStatus);
                return;
            }
            String string = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            if (StringsKt.endsWith$default((String)string, (String)"/v1/delta/acquire", (boolean)false, (int)2, null)) {
                long from = this.toLongSafe((List)decoder.parameters().get("fromAddress"), ctx);
                String string2 = this.getString((List)decoder.parameters().get("location"));
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                Object env = it == null ? (this.server.getEnvironments$xodus_multinode().size() == 1 ? (EnvironmentImpl)((Map.Entry)CollectionsKt.first((Iterable)this.server.getEnvironments$xodus_multinode().entrySet())).getValue() : null) : this.server.getEnvironments$xodus_multinode().get(it);
                if (env == null) {
                    MetaServerHandler.respondEmpty$default(this, ctx, null, 2, null);
                    return;
                }
                if (from >= 0L) {
                    MetaTree metaTree;
                    GcTransaction gcTransaction = new GcTransaction((Environment)env);
                    this.gcTransactions.put(gcTransaction.getId(), gcTransaction);
                    gcTransaction.start();
                    MetaTree metaTree2 = metaTree = env.getMetaTree();
                    Intrinsics.checkExpressionValueIsNotNull((Object)metaTree2, (String)"metaTree");
                    LogTip tip = metaTree2.getLogTip();
                    long l = tip.highAddress;
                    long l2 = env.getLog().getFileLengthBound();
                    LongIterator longIterator = tip.getFilesFrom(from);
                    Intrinsics.checkExpressionValueIsNotNull((Object)longIterator, (String)"tip.getFilesFrom(from)");
                    long l3 = gcTransaction.getId();
                    boolean bl4 = env.getCipherProvider() != null;
                    long l4 = metaTree.rootAddress();
                    long l5 = metaTree.treeAddress();
                    long[] lArray = CollectionsKt.toLongArray((Collection)SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)((Iterator)longIterator))));
                    long l6 = l2;
                    long l7 = l;
                    long l8 = from;
                    ReplicationDelta result = new ReplicationDelta(l3, l8, l7, l6, lArray, bl4, l5, l4);
                    this.respond((HttpRequest)msg, ctx, result);
                }
                return;
            }
            if (StringsKt.endsWith$default((String)path, (String)"/v1/delta/release", (boolean)false, (int)2, null)) {
                long id = this.toLongSafe((List)decoder.parameters().get("id"), ctx);
                if (id >= 0L) {
                    GcTransaction gcTransaction = this.gcTransactions.get(id);
                    if (gcTransaction != null) {
                        GcTransaction gcTransaction2 = gcTransaction;
                        boolean bl = false;
                        boolean bl5 = false;
                        GcTransaction it = gcTransaction2;
                        boolean bl6 = false;
                        try {
                            it.stop();
                        }
                        finally {
                            this.gcTransactions.remove(id);
                        }
                        this.respond((HttpRequest)msg, ctx, ok);
                    } else {
                        HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                        this.respondEmpty(ctx, httpResponseStatus);
                    }
                }
                return;
            }
            MetaServerHandler.respondEmpty$default(this, ctx, null, 2, null);
        }
    }

    private final long toLongSafe(@Nullable List<String> $this$toLongSafe, ChannelHandlerContext ctx) {
        if ($this$toLongSafe != null) {
            Object object = $this$toLongSafe;
            boolean bl = false;
            if (!object.isEmpty()) {
                try {
                    object = $this$toLongSafe.get(0);
                    bl = false;
                    return Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_REQUEST");
        this.respondEmpty(ctx, httpResponseStatus);
        return -1L;
    }

    private final String getString(@Nullable List<String> $this$getString) {
        if ($this$getString != null) {
            Collection collection = $this$getString;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return $this$getString.get(0);
            }
        }
        return null;
    }

    private final void respond(HttpRequest request, ChannelHandlerContext ctx, Object payload) {
        byte[] bytes = mapper.writeValueAsBytes(payload);
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])bytes), false);
        HttpHeaders httpHeaders = response.headers();
        boolean bl = false;
        boolean bl2 = false;
        HttpHeaders $this$apply = httpHeaders;
        boolean bl3 = false;
        $this$apply.set((CharSequence)contentTypeKey, (Object)applicationJson);
        $this$apply.set((CharSequence)serverKey, (Object)serverName);
        $this$apply.set((CharSequence)contentLengthKey, (Object)String.valueOf(bytes.length));
        if (!keepAlive) {
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.write((Object)response, ctx.voidPromise());
        }
    }

    private final void respondEmpty(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.EMPTY_BUFFER, false);
        boolean bl = false;
        boolean bl2 = false;
        DefaultFullHttpResponse it = defaultFullHttpResponse;
        boolean bl3 = false;
        ctx.write((Object)it).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    static /* synthetic */ void respondEmpty$default(MetaServerHandler metaServerHandler, ChannelHandlerContext channelHandlerContext, HttpResponseStatus httpResponseStatus, int n, Object object) {
        if ((n & 2) != 0) {
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus2, (String)"HttpResponseStatus.NOT_FOUND");
            httpResponseStatus = httpResponseStatus2;
        }
        metaServerHandler.respondEmpty(channelHandlerContext, httpResponseStatus);
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        ctx.close();
    }

    public void channelReadComplete(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        ctx.flush();
    }

    @NotNull
    public final MetaServerImpl getServer() {
        return this.server;
    }

    public MetaServerHandler(@NotNull MetaServerImpl server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        this.server = server;
        this.gcTransactions = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        applicationJson = new AsciiString((CharSequence)"application/json; charset=UTF-8");
        serverName = new AsciiString((CharSequence)"Xodus");
        contentTypeKey = new AsciiString((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        contentLengthKey = new AsciiString((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        serverKey = new AsciiString((CharSequence)HttpHeaderNames.SERVER);
        mapper = new ObjectMapper();
        ok = new OK(false, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ljetbrains/exodus/entitystore/replication/MetaServerHandler$OK;", "", "ok", "", "(Z)V", "getOk", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "xodus-multinode"})
    public static final class OK {
        private final boolean ok;

        public final boolean getOk() {
            return this.ok;
        }

        public OK(boolean ok) {
            this.ok = ok;
        }

        public /* synthetic */ OK(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public OK() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.ok;
        }

        @NotNull
        public final OK copy(boolean ok) {
            return new OK(ok);
        }

        public static /* synthetic */ OK copy$default(OK oK, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = oK.ok;
            }
            return oK.copy(bl);
        }

        @NotNull
        public String toString() {
            return "OK(ok=" + this.ok + ")";
        }

        public int hashCode() {
            int n = this.ok ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof OK)) break block3;
                    OK oK = (OK)object;
                    if (this.ok != oK.ok) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/entitystore/replication/MetaServerHandler$Companion;", "", "()V", "applicationJson", "Lio/netty/util/AsciiString;", "contentLengthKey", "contentTypeKey", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "ok", "Ljetbrains/exodus/entitystore/replication/MetaServerHandler$OK;", "serverKey", "serverName", "xodus-multinode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

