/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.replication;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.crypto.EncryptedBlobVault;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.DiskBasedBlobVault;
import jetbrains.exodus.entitystore.FileBasedBlobValueItem;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.replication.S3Replicator;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J:\u0010\u0019\u001a\u00020\u00142\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0016H\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010.\u001a\u00020\u0012H\u0002J\b\u0010/\u001a\u00020\u0016H\u0016J\b\u00100\u001a\u00020\u0018H\u0016R\u001a\u0010\u0003\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00061"}, d2={"Ljetbrains/exodus/entitystore/replication/S3ReplicationBlobVault;", "Ljetbrains/exodus/entitystore/BlobVault;", "Ljetbrains/exodus/entitystore/DiskBasedBlobVault;", "delegate", "store", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "replicator", "Ljetbrains/exodus/entitystore/replication/S3Replicator;", "(Ljetbrains/exodus/entitystore/DiskBasedBlobVault;Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;Ljetbrains/exodus/entitystore/replication/S3Replicator;)V", "getDelegate", "()Ljetbrains/exodus/entitystore/DiskBasedBlobVault;", "setDelegate", "(Ljetbrains/exodus/entitystore/DiskBasedBlobVault;)V", "getReplicator", "()Ljetbrains/exodus/entitystore/replication/S3Replicator;", "getStore", "()Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "clear", "", "close", "", "delete", "", "blobHandle", "", "flushBlobs", "blobStreams", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "Ljava/io/InputStream;", "blobFiles", "Ljava/io/File;", "deferredBlobsToDelete", "Ljetbrains/exodus/core/dataStructures/hash/LongSet;", "txn", "Ljetbrains/exodus/env/Transaction;", "getBackupStrategy", "Ljetbrains/exodus/backup/BackupStrategy;", "getBlob", "Ljetbrains/exodus/entitystore/BlobVaultItem;", "getBlobKey", "", "getBlobLocation", "readonly", "getContent", "getSize", "nextHandle", "readOnly", "requiresTxn", "size", "xodus-multinode"})
public final class S3ReplicationBlobVault
extends BlobVault
implements DiskBasedBlobVault {
    @NotNull
    private DiskBasedBlobVault delegate;
    @NotNull
    private final PersistentEntityStoreImpl store;
    @NotNull
    private final S3Replicator replicator;

    public boolean delete(long blobHandle) {
        return this.delegate.delete(blobHandle);
    }

    @NotNull
    public BlobVaultItem getBlob(long blobHandle) {
        return (BlobVaultItem)new FileBasedBlobValueItem(this.getBlobLocation(blobHandle), blobHandle);
    }

    @NotNull
    public BackupStrategy getBackupStrategy() {
        BackupStrategy backupStrategy = BackupStrategy.EMPTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)backupStrategy, (String)"BackupStrategy.EMPTY");
        return backupStrategy;
    }

    @Nullable
    public InputStream getContent(long blobHandle, @NotNull Transaction txn) {
        InputStream result;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
            result = this.delegate.getContent(blobHandle, txn);
            if (result != null) break block2;
            Long l = this.store.getBlobFileLength(blobHandle, txn);
            if (l != null) {
                Long l2 = l;
                boolean bl = false;
                boolean bl2 = false;
                long length = ((Number)l2).longValue();
                boolean bl3 = false;
                File file = this.replicator.replicateBlob$xodus_multinode(blobHandle, length, this.delegate, this.replicator.getSourceEncrypted(), this.delegate instanceof EncryptedBlobVault);
                if (file != null) {
                    File file2 = file;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    File it = file2;
                    boolean bl6 = false;
                    result = this.delegate.getContent(blobHandle, txn);
                }
            }
        }
        return result;
    }

    public long getSize(long blobHandle, @NotNull Transaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        Long l = this.store.getBlobFileLength(blobHandle, txn);
        return l != null ? l : 0L;
    }

    @NotNull
    public String getBlobKey(long blobHandle) {
        String string = this.delegate.getBlobKey(blobHandle);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delegate.getBlobKey(blobHandle)");
        return string;
    }

    @NotNull
    public File getBlobLocation(long blobHandle) {
        File file = this.delegate.getBlobLocation(blobHandle);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"delegate.getBlobLocation(blobHandle)");
        return file;
    }

    @NotNull
    public File getBlobLocation(long blobHandle, boolean readonly) {
        if (!readonly) {
            Void void_ = this.readOnly();
            throw null;
        }
        File file = this.delegate.getBlobLocation(blobHandle, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"delegate.getBlobLocation(blobHandle, true)");
        return file;
    }

    public long size() {
        return this.delegate.size();
    }

    public boolean requiresTxn() {
        return false;
    }

    public long nextHandle(@NotNull Transaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        Void void_ = this.readOnly();
        throw null;
    }

    public void flushBlobs(@Nullable LongHashMap<InputStream> blobStreams, @Nullable LongHashMap<File> blobFiles, @Nullable LongSet deferredBlobsToDelete, @NotNull Transaction txn) {
        block4: {
            block3: {
                boolean bl;
                Map map;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                    if (blobFiles == null) break block2;
                    map = (Map)blobFiles;
                    bl = false;
                    if (!map.isEmpty()) break block3;
                }
                if (blobStreams == null) break block4;
                map = (Map)blobStreams;
                bl = false;
                if (!(!map.isEmpty())) break block4;
            }
            Void void_ = this.readOnly();
            throw null;
        }
    }

    @NotNull
    public Void clear() {
        Void void_ = this.readOnly();
        throw null;
    }

    public void close() {
        this.delegate.close();
    }

    private final Void readOnly() {
        throw (Throwable)new UnsupportedOperationException("vault is read-only");
    }

    @NotNull
    public final DiskBasedBlobVault getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(@NotNull DiskBasedBlobVault diskBasedBlobVault) {
        Intrinsics.checkParameterIsNotNull((Object)diskBasedBlobVault, (String)"<set-?>");
        this.delegate = diskBasedBlobVault;
    }

    @NotNull
    public final PersistentEntityStoreImpl getStore() {
        return this.store;
    }

    @NotNull
    public final S3Replicator getReplicator() {
        return this.replicator;
    }

    public S3ReplicationBlobVault(@NotNull DiskBasedBlobVault delegate, @NotNull PersistentEntityStoreImpl store, @NotNull S3Replicator replicator) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        Intrinsics.checkParameterIsNotNull((Object)replicator, (String)"replicator");
        super(store.getConfig());
        this.delegate = delegate;
        this.store = store;
        this.replicator = replicator;
    }
}

