/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.utils.FunctionalUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0010\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0015\u0010\u001a\u001a\u00020\u00132\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ$\u0010\u001c\u001a\u00020\u0013*\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Ljetbrains/exodus/log/replication/ByteArrayAsyncResponseHandler;", "R", "Lsoftware/amazon/awssdk/core/async/AsyncResponseTransformer;", "", "output", "", "offset", "([BI)V", "getOutput", "()[B", "response", "Ljava/lang/Object;", "written", "Ljava/util/concurrent/atomic/AtomicInteger;", "getWritten", "()Ljava/util/concurrent/atomic/AtomicInteger;", "complete", "()Ljava/lang/Integer;", "exceptionOccurred", "", "throwable", "", "onStream", "publisher", "Lorg/reactivestreams/Publisher;", "Ljava/nio/ByteBuffer;", "responseReceived", "(Ljava/lang/Object;)V", "copyBytes", "length", "ByteArraySubscriber", "Companion", "xodus-multinode"})
public final class ByteArrayAsyncResponseHandler<R>
implements AsyncResponseTransformer<R, Integer> {
    @NotNull
    private final AtomicInteger written;
    private volatile R response;
    @NotNull
    private final byte[] output;
    private final int offset;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AtomicInteger getWritten() {
        return this.written;
    }

    public void responseReceived(R response) {
        this.response = response;
    }

    public void onStream(@NotNull Publisher<ByteBuffer> publisher) {
        Intrinsics.checkParameterIsNotNull(publisher, (String)"publisher");
        this.written.set(0);
        publisher.subscribe((Subscriber)new ByteArraySubscriber(this.offset));
    }

    public void exceptionOccurred(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
    }

    @NotNull
    public Integer complete() {
        return this.written.get();
    }

    private final void copyBytes(@NotNull ByteBuffer $this$copyBytes, byte[] output, int offset, int length) {
        if ($this$copyBytes.hasArray()) {
            System.arraycopy($this$copyBytes.array(), $this$copyBytes.arrayOffset() + $this$copyBytes.position(), output, offset, length);
        }
        $this$copyBytes.asReadOnlyBuffer().get(output, offset, length);
    }

    @NotNull
    public final byte[] getOutput() {
        return this.output;
    }

    public ByteArrayAsyncResponseHandler(@NotNull byte[] output, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        this.output = output;
        this.offset = offset;
        this.written = new AtomicInteger();
    }

    public static final /* synthetic */ void access$copyBytes(ByteArrayAsyncResponseHandler $this, ByteBuffer $this$access_u24copyBytes, byte[] output, int offset, int length) {
        $this.copyBytes($this$access_u24copyBytes, output, offset, length);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/log/replication/ByteArrayAsyncResponseHandler$ByteArraySubscriber;", "Lorg/reactivestreams/Subscriber;", "Ljava/nio/ByteBuffer;", "offset", "", "(Ljetbrains/exodus/log/replication/ByteArrayAsyncResponseHandler;I)V", "getOffset", "()I", "subscription", "Lorg/reactivestreams/Subscription;", "onComplete", "", "onError", "throwable", "", "onNext", "byteBuffer", "onSubscribe", "s", "xodus-multinode"})
    private final class ByteArraySubscriber
    implements Subscriber<ByteBuffer> {
        private Subscription subscription;
        private final int offset;

        public void onSubscribe(@NotNull Subscription s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            this.subscription = s;
            s.request(1L);
        }

        public void onNext(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkParameterIsNotNull((Object)byteBuffer, (String)"byteBuffer");
            int length = byteBuffer.remaining();
            int prevLength = ByteArrayAsyncResponseHandler.this.getWritten().getAndAdd(length);
            int outputLength = ByteArrayAsyncResponseHandler.this.getOutput().length;
            if (prevLength <= outputLength) {
                int n = outputLength - prevLength;
                boolean bl = false;
                int maxLength = Math.min(n, length);
                FunctionalUtils.invokeSafely((FunctionalUtils.UnsafeRunnable)new FunctionalUtils.UnsafeRunnable(this, byteBuffer, prevLength, maxLength){
                    final /* synthetic */ ByteArraySubscriber this$0;
                    final /* synthetic */ ByteBuffer $byteBuffer;
                    final /* synthetic */ int $prevLength;
                    final /* synthetic */ int $maxLength;

                    public final void run() {
                        ByteArrayAsyncResponseHandler.access$copyBytes(this.this$0.ByteArrayAsyncResponseHandler.this, this.$byteBuffer, this.this$0.ByteArrayAsyncResponseHandler.this.getOutput(), this.this$0.getOffset() + this.$prevLength, this.$maxLength);
                    }
                    {
                        this.this$0 = byteArraySubscriber;
                        this.$byteBuffer = byteBuffer;
                        this.$prevLength = n;
                        this.$maxLength = n2;
                    }
                });
            } else {
                Companion.getLogger().warn((Function0)new Function0<String>(prevLength, outputLength){
                    final /* synthetic */ int $prevLength;
                    final /* synthetic */ int $outputLength;

                    @NotNull
                    public final String invoke() {
                        return "Data buffer overrun, drop " + (this.$prevLength - this.$outputLength) + " bytes";
                    }
                    {
                        this.$prevLength = n;
                        this.$outputLength = n2;
                        super(0);
                    }
                });
            }
            Subscription subscription = this.subscription;
            if (subscription == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"subscription");
            }
            subscription.request(1L);
        }

        public void onError(@NotNull Throwable throwable) {
            Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        }

        public void onComplete() {
        }

        public final int getOffset() {
            return this.offset;
        }

        public ByteArraySubscriber(int offset) {
            this.offset = offset;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/log/replication/ByteArrayAsyncResponseHandler$Companion;", "Lmu/KLogging;", "()V", "xodus-multinode"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

