/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.log.BufferedDataWriter;
import jetbrains.exodus.log.replication.MiscKt;
import jetbrains.exodus.log.replication.WriteResult;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.utils.FunctionalUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\"B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0016\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ljetbrains/exodus/log/replication/FileAsyncHandler;", "Lsoftware/amazon/awssdk/core/async/AsyncResponseTransformer;", "Lsoftware/amazon/awssdk/services/s3/model/GetObjectResponse;", "Ljetbrains/exodus/log/replication/WriteResult;", "path", "Ljava/nio/file/Path;", "startingLength", "", "lastPageStart", "lastPage", "Ljetbrains/exodus/log/BufferedDataWriter$MutablePage;", "(Ljava/nio/file/Path;JJLjetbrains/exodus/log/BufferedDataWriter$MutablePage;)V", "error", "", "fileChannel", "Ljava/nio/channels/AsynchronousFileChannel;", "lastPageLength", "Ljava/util/concurrent/atomic/AtomicInteger;", "lastPageStartingLength", "", "response", "writeInProgressLock", "Ljava/util/concurrent/Semaphore;", "close", "", "complete", "exceptionOccurred", "throwable", "onStream", "publisher", "Lorg/reactivestreams/Publisher;", "Ljava/nio/ByteBuffer;", "open", "responseReceived", "FileSubscriber", "xodus-multinode"})
public final class FileAsyncHandler
implements AsyncResponseTransformer<GetObjectResponse, WriteResult> {
    private final int lastPageStartingLength;
    private AsynchronousFileChannel fileChannel;
    private volatile GetObjectResponse response;
    private final AtomicInteger lastPageLength;
    private final Semaphore writeInProgressLock;
    private volatile Throwable error;
    private final Path path;
    private final long startingLength;
    private final long lastPageStart;
    private final BufferedDataWriter.MutablePage lastPage;

    public void responseReceived(@NotNull GetObjectResponse response) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.response = response;
    }

    public void onStream(@NotNull Publisher<ByteBuffer> publisher) {
        Intrinsics.checkParameterIsNotNull(publisher, (String)"publisher");
        this.lastPageLength.set(this.lastPageStartingLength);
        Object object = FunctionalUtils.invokeSafely((FunctionalUtils.UnsafeSupplier)new FunctionalUtils.UnsafeSupplier<T>(this){
            final /* synthetic */ FileAsyncHandler this$0;

            @NotNull
            public final AsynchronousFileChannel get() {
                return FileAsyncHandler.access$open(this.this$0, FileAsyncHandler.access$getPath$p(this.this$0));
            }
            {
                this.this$0 = fileAsyncHandler;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"invokeSafely<Asynchronou\u2026leChannel> { open(path) }");
        this.fileChannel = (AsynchronousFileChannel)object;
        publisher.subscribe((Subscriber)new FileSubscriber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionOccurred(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        try {
            this.writeInProgressLock.acquire();
            this.error = throwable;
            this.close();
            this.writeInProgressLock.release();
        }
        catch (Throwable throwable2) {
            this.writeInProgressLock.release();
            FunctionalUtils.invokeSafely((FunctionalUtils.UnsafeRunnable)new FunctionalUtils.UnsafeRunnable(this){
                final /* synthetic */ FileAsyncHandler this$0;

                public final void run() {
                    Files.delete(FileAsyncHandler.access$getPath$p(this.this$0));
                }
                {
                    this.this$0 = fileAsyncHandler;
                }
            });
            throw throwable2;
        }
        FunctionalUtils.invokeSafely((FunctionalUtils.UnsafeRunnable)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    public WriteResult complete() {
        this.writeInProgressLock.acquire();
        Throwable throwable = this.error;
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable it = throwable2;
            boolean bl3 = false;
            throw it;
        }
        GetObjectResponse getObjectResponse = this.response;
        if (getObjectResponse == null) {
            throw (Throwable)new IllegalStateException("Response not set");
        }
        GetObjectResponse getObjectResponse2 = getObjectResponse;
        boolean bl = false;
        boolean bl4 = false;
        GetObjectResponse it = getObjectResponse2;
        boolean bl5 = false;
        Long l = it.contentLength();
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"it.contentLength()");
        return new WriteResult(l, this.lastPageLength.get());
    }

    private final AsynchronousFileChannel open(Path path) {
        AsynchronousFileChannel asynchronousFileChannel = AsynchronousFileChannel.open(path, StandardOpenOption.WRITE, this.startingLength > 0L ? StandardOpenOption.WRITE : StandardOpenOption.CREATE_NEW);
        Intrinsics.checkExpressionValueIsNotNull((Object)asynchronousFileChannel, (String)"AsynchronousFileChannel.\u2026ion.CREATE_NEW\n        })");
        return asynchronousFileChannel;
    }

    private final void close() {
        if (this.fileChannel != null) {
            AsynchronousFileChannel asynchronousFileChannel = this.fileChannel;
            if (asynchronousFileChannel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fileChannel");
            }
            asynchronousFileChannel.force(false);
            FunctionalUtils.invokeSafely((FunctionalUtils.UnsafeRunnable)new FunctionalUtils.UnsafeRunnable(this){
                final /* synthetic */ FileAsyncHandler this$0;

                public final void run() {
                    FileAsyncHandler.access$getFileChannel$p(this.this$0).close();
                }
                {
                    this.this$0 = fileAsyncHandler;
                }
            });
        }
    }

    public FileAsyncHandler(@NotNull Path path, long startingLength, long lastPageStart, @Nullable BufferedDataWriter.MutablePage lastPage) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        this.startingLength = startingLength;
        this.lastPageStart = lastPageStart;
        BufferedDataWriter.MutablePage mutablePage = this.lastPage = lastPage;
        this.lastPageStartingLength = mutablePage != null ? mutablePage.getCount() : 0;
        this.lastPageLength = new AtomicInteger();
        this.writeInProgressLock = new Semaphore(1);
    }

    public /* synthetic */ FileAsyncHandler(Path path, long l, long l2, BufferedDataWriter.MutablePage mutablePage, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        if ((n & 8) != 0) {
            mutablePage = null;
        }
        this(path, l, l2, mutablePage);
    }

    public static final /* synthetic */ AsynchronousFileChannel access$getFileChannel$p(FileAsyncHandler $this) {
        AsynchronousFileChannel asynchronousFileChannel = $this.fileChannel;
        if (asynchronousFileChannel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileChannel");
        }
        return asynchronousFileChannel;
    }

    public static final /* synthetic */ void access$setFileChannel$p(FileAsyncHandler $this, AsynchronousFileChannel asynchronousFileChannel) {
        $this.fileChannel = asynchronousFileChannel;
    }

    public static final /* synthetic */ Throwable access$getError$p(FileAsyncHandler $this) {
        return $this.error;
    }

    public static final /* synthetic */ void access$setError$p(FileAsyncHandler $this, Throwable throwable) {
        $this.error = throwable;
    }

    public static final /* synthetic */ AsynchronousFileChannel access$open(FileAsyncHandler $this, Path path) {
        return $this.open(path);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/exodus/log/replication/FileAsyncHandler$FileSubscriber;", "Lorg/reactivestreams/Subscriber;", "Ljava/nio/ByteBuffer;", "(Ljetbrains/exodus/log/replication/FileAsyncHandler;)V", "closeOnLastWrite", "", "position", "Ljava/util/concurrent/atomic/AtomicLong;", "subscription", "Lorg/reactivestreams/Subscription;", "onComplete", "", "onError", "t", "", "onNext", "byteBuffer", "onSubscribe", "s", "toString", "", "updateLastPage", "writtenLength", "", "attachment", "xodus-multinode"})
    private final class FileSubscriber
    implements Subscriber<ByteBuffer> {
        private volatile boolean closeOnLastWrite;
        private final AtomicLong position;
        private Subscription subscription;

        public void onSubscribe(@NotNull Subscription s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            this.subscription = s;
            s.request(1L);
        }

        public void onNext(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkParameterIsNotNull((Object)byteBuffer, (String)"byteBuffer");
            FileAsyncHandler.this.writeInProgressLock.acquire();
            FileAsyncHandler.access$getFileChannel$p(FileAsyncHandler.this).write(byteBuffer, this.position.get(), byteBuffer, (CompletionHandler)new CompletionHandler<Integer, ByteBuffer>(this){
                final /* synthetic */ FileSubscriber this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(int result, @NotNull ByteBuffer attachment) {
                    Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
                    try {
                        if (result > 0) {
                            long writtenLength = result;
                            FileSubscriber.access$updateLastPage(this.this$0, writtenLength, attachment);
                            if (FileSubscriber.access$getCloseOnLastWrite$p(this.this$0)) {
                                FileAsyncHandler.access$close(this.this$0.FileAsyncHandler.this);
                            } else {
                                FileSubscriber.access$getSubscription$p(this.this$0).request(1L);
                            }
                        }
                    }
                    catch (Throwable t) {
                        FileAsyncHandler.access$setError$p(this.this$0.FileAsyncHandler.this, t);
                        FileSubscriber.access$getSubscription$p(this.this$0).cancel();
                    }
                    finally {
                        FileAsyncHandler.access$getWriteInProgressLock$p(this.this$0.FileAsyncHandler.this).release();
                    }
                }

                public void failed(@NotNull Throwable exc, @NotNull ByteBuffer attachment) {
                    Intrinsics.checkParameterIsNotNull((Object)exc, (String)"exc");
                    Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
                    FileAsyncHandler.access$setError$p(this.this$0.FileAsyncHandler.this, exc);
                    FileSubscriber.access$getSubscription$p(this.this$0).cancel();
                    FileAsyncHandler.access$close(this.this$0.FileAsyncHandler.this);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        public void onError(@NotNull Throwable t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            if (!FileAsyncHandler.this.writeInProgressLock.tryAcquire()) {
                this.closeOnLastWrite = true;
            } else {
                try {
                    FileAsyncHandler.this.close();
                }
                finally {
                    FileAsyncHandler.this.writeInProgressLock.release();
                }
            }
        }

        private final void updateLastPage(long writtenLength, ByteBuffer attachment) {
            long endPosition = this.position.addAndGet(writtenLength);
            if (FileAsyncHandler.this.lastPage != null && endPosition >= FileAsyncHandler.this.lastPageStart) {
                attachment.flip();
                if (writtenLength > (long)attachment.limit()) {
                    throw (Throwable)new IllegalStateException("Unexpected buffer state");
                }
                long startPosition = endPosition - writtenLength;
                int skip = 0;
                int offset = 0;
                if (startPosition < FileAsyncHandler.this.lastPageStart) {
                    skip = (int)(FileAsyncHandler.this.lastPageStart - startPosition);
                    offset = 0;
                } else {
                    offset = (int)(startPosition - FileAsyncHandler.this.lastPageStart);
                    skip = 0;
                }
                byte[] bytes = FileAsyncHandler.this.lastPage.getBytes();
                long l = (long)bytes.length - (long)offset;
                long l2 = writtenLength - (long)skip;
                boolean bl = false;
                int length = (int)Math.min(l, l2);
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
                MiscKt.copyBytes(attachment, skip, bytes, offset, length);
                FileAsyncHandler.this.lastPageLength.addAndGet(length);
            }
        }

        @NotNull
        public String toString() {
            return "" + this.getClass() + ':' + FileAsyncHandler.this.path;
        }

        public FileSubscriber() {
            this.position = new AtomicLong(FileAsyncHandler.this.startingLength);
        }

        public static final /* synthetic */ void access$updateLastPage(FileSubscriber $this, long writtenLength, ByteBuffer attachment) {
            $this.updateLastPage(writtenLength, attachment);
        }

        public static final /* synthetic */ boolean access$getCloseOnLastWrite$p(FileSubscriber $this) {
            return $this.closeOnLastWrite;
        }

        public static final /* synthetic */ void access$setCloseOnLastWrite$p(FileSubscriber $this, boolean bl) {
            $this.closeOnLastWrite = bl;
        }

        public static final /* synthetic */ Subscription access$getSubscription$p(FileSubscriber $this) {
            Subscription subscription = $this.subscription;
            if (subscription == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"subscription");
            }
            return subscription;
        }

        public static final /* synthetic */ void access$setSubscription$p(FileSubscriber $this, Subscription subscription) {
            $this.subscription = subscription;
        }
    }
}

