/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.replication.FileFactory;
import jetbrains.exodus.log.replication.LogReplicationDelta;
import jetbrains.exodus.log.replication.WriteResult;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0005H\u0007J%\u0010\r\u001a\u00020\u000e2\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Ljetbrains/exodus/log/replication/LogAppender;", "Lmu/KLogging;", "()V", "appendLog", "Lkotlin/Function0;", "Ljetbrains/exodus/log/LogTip;", "log", "Ljetbrains/exodus/log/Log;", "delta", "Ljetbrains/exodus/log/replication/LogReplicationDelta;", "fileFactory", "Ljetbrains/exodus/log/replication/FileFactory;", "currentTip", "checkPreconditions", "", "Lorg/jetbrains/annotations/NotNull;", "writeFiles", "xodus-multinode"})
public final class LogAppender
extends KLogging {
    public static final LogAppender INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Function0<LogTip> appendLog(@NotNull Log log, @NotNull LogReplicationDelta delta, @NotNull FileFactory fileFactory, @NotNull LogTip currentTip) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        Intrinsics.checkParameterIsNotNull((Object)delta, (String)"delta");
        Intrinsics.checkParameterIsNotNull((Object)fileFactory, (String)"fileFactory");
        Intrinsics.checkParameterIsNotNull((Object)currentTip, (String)"currentTip");
        try {
            INSTANCE.checkPreconditions(log, currentTip, delta);
            long highAddress = delta.getHighAddress();
            if (highAddress < delta.getStartAddress()) {
                throw (Throwable)new IllegalArgumentException("Cannot decrease high address");
            }
            long[] lArray = delta.getFiles();
            boolean bl = false;
            if (lArray.length == 0) {
                log.abortWrite();
                return (Function0)new Function0<LogTip>(log, currentTip, highAddress){
                    final /* synthetic */ Log $log;
                    final /* synthetic */ LogTip $currentTip;
                    final /* synthetic */ long $highAddress;

                    @NotNull
                    public final LogTip invoke() {
                        return this.$log.setHighAddress(this.$currentTip, this.$highAddress);
                    }
                    {
                        this.$log = log;
                        this.$currentTip = logTip;
                        this.$highAddress = l;
                        super(0);
                    }
                };
            }
            long currentHighFile = log.getFileAddress(currentTip.highAddress);
            if (ArraysKt.first((long[])delta.getFiles()) != currentHighFile) {
                log.padWithNulls();
            }
            INSTANCE.writeFiles(log, currentTip, delta, fileFactory);
            return (Function0)new Function0<LogTip>(log){
                final /* synthetic */ Log $log;

                @NotNull
                public final LogTip invoke() {
                    return this.$log.endWrite();
                }
                {
                    this.$log = log;
                    super(0);
                }
            };
        }
        catch (Throwable t) {
            log.revertWrite(currentTip);
            RuntimeException runtimeException = ExodusException.toExodusException((Throwable)t, (String)"Failed to replicate log");
            Intrinsics.checkExpressionValueIsNotNull((Object)runtimeException, (String)"ExodusException.toExodus\u2026Failed to replicate log\")");
            throw (Throwable)runtimeException;
        }
    }

    public static /* synthetic */ Function0 appendLog$default(Log log, LogReplicationDelta logReplicationDelta, FileFactory fileFactory, LogTip logTip, int n, Object object) {
        if ((n & 8) != 0) {
            logTip = log.beginWrite();
        }
        return LogAppender.appendLog(log, logReplicationDelta, fileFactory, logTip);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Function0<LogTip> appendLog(@NotNull Log log, @NotNull LogReplicationDelta delta, @NotNull FileFactory fileFactory) {
        return LogAppender.appendLog$default(log, delta, fileFactory, null, 8, null);
    }

    private final void checkPreconditions(Log log, LogTip currentTip, LogReplicationDelta delta) {
        if (delta.getStartAddress() != currentTip.highAddress || delta.getFileLengthBound() != log.getFileLengthBound()) {
            throw (Throwable)new IllegalArgumentException("Non-matching replication delta");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeFiles(Log log, LogTip currentTip, LogReplicationDelta delta, FileFactory fileFactory) {
        void allWritten;
        long fileSize = log.getFileLengthBound();
        long lastFile = log.getFileAddress(delta.getHighAddress());
        WriteResult lastFileWrite = null;
        long prevAddress = log.getFileAddress(currentTip.highAddress);
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        for (long file : delta.getFiles()) {
            if (file < prevAddress) {
                throw (Throwable)new IllegalStateException("Incorrect file order");
            }
            long startingLength = file == prevAddress ? currentTip.highAddress - prevAddress : 0L;
            prevAddress = file;
            boolean atLastFile = file == lastFile;
            long expectedLength = atLastFile ? delta.getHighAddress() - file : fileSize;
            boolean useLastPage = atLastFile && expectedLength != fileSize;
            log.ensureWriter().setHighAddress(file + startingLength);
            WriteResult created = fileFactory.fetchFile(log, file, startingLength, expectedLength, useLastPage);
            if (created.getWritten() != expectedLength - startingLength) {
                throw (Throwable)new IllegalStateException("Fetched unexpected bytes");
            }
            if (created.getWritten() == 0L) {
                return;
            }
            allWritten.element += created.getWritten();
            if (useLastPage && delta.getHighAddress() - log.getHighPageAddress(delta.getHighAddress()) != (long)created.getLastPageLength()) {
                throw (Throwable)new IllegalStateException("Fetched unexpected last page bytes");
            }
            if (!atLastFile) continue;
            lastFileWrite = created;
        }
        if (lastFileWrite == null) {
            throw (Throwable)new IllegalArgumentException("Last file is not provided");
        }
        this.getLogger().debug((Function0)new Function0<String>((Ref.LongRef)allWritten, log){
            final /* synthetic */ Ref.LongRef $allWritten;
            final /* synthetic */ Log $log;

            @NotNull
            public final String invoke() {
                return "Appended " + this.$allWritten.element + " bytes to log at " + this.$log.getLocation();
            }
            {
                this.$allWritten = longRef;
                this.$log = log;
                super(0);
            }
        });
    }

    private LogAppender() {
    }

    static {
        LogAppender logAppender;
        INSTANCE = logAppender = new LogAppender();
    }
}

