/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentBitTreeLongMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.log.replication.FileNameRulesKt;
import jetbrains.exodus.log.replication.MiscKt;
import jetbrains.exodus.log.replication.S3Block;
import jetbrains.exodus.log.replication.S3BlocksKt;
import jetbrains.exodus.log.replication.S3DataReaderOrWriter;
import jetbrains.exodus.log.replication.S3DataReaderOrWriterKt;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.S3FolderBlock;
import jetbrains.exodus.log.replication.S3SubBlock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"fileBlocks", "", "Ljetbrains/exodus/log/replication/S3Block;", "Ljetbrains/exodus/log/replication/S3DataReaderOrWriter;", "getFileBlocks", "(Ljetbrains/exodus/log/replication/S3DataReaderOrWriter;)Ljava/util/List;", "folderBlocks", "Ljetbrains/exodus/log/replication/S3FolderBlock;", "getFolderBlocks", "xodus-multinode"})
public final class S3BlocksKt {
    @NotNull
    public static final List<S3Block> getFileBlocks(@NotNull S3DataReaderOrWriter $this$fileBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fileBlocks, (String)"$this$fileBlocks");
        ListObjectsRequest.Builder builder = S3DataReaderOrWriterKt.listObjectsBuilder($this$fileBlocks).delimiter("/");
        S3AsyncClient s3AsyncClient = $this$fileBlocks.getS3();
        ListObjectsRequest.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Sequence $this$sortedBy$iv = SequencesKt.map((Sequence)SequencesKt.filter(MiscKt.listObjects(s3AsyncClient, builder2), (Function1)fileBlocks.1.INSTANCE), (Function1)((Function1)new Function1<S3Object, S3Block>($this$fileBlocks){
            final /* synthetic */ S3DataReaderOrWriter $this_fileBlocks;

            @NotNull
            public final S3Block invoke(@NotNull S3Object it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                S3FactoryBoilerplate s3FactoryBoilerplate = this.$this_fileBlocks;
                String string = it.key();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.key()");
                long l = FileNameRulesKt.getAddress(string);
                Long l2 = it.size();
                Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"it.size()");
                return new S3Block(s3FactoryBoilerplate, l, l2);
            }
            {
                this.$this_fileBlocks = s3DataReaderOrWriter;
                super(1);
            }
        }));
        boolean $i$f$sortedBy = false;
        Sequence sequence = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                S3Block it = (S3Block)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getAddr$xodus_multinode());
                it = (S3Block)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getAddr$xodus_multinode();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)comparator));
    }

    @NotNull
    public static final List<S3FolderBlock> getFolderBlocks(@NotNull S3DataReaderOrWriter $this$folderBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)$this$folderBlocks, (String)"$this$folderBlocks");
        ListObjectsRequest.Builder builder = S3DataReaderOrWriterKt.listObjectsBuilder($this$folderBlocks).prefix("_");
        TreeMap folders = new TreeMap();
        S3AsyncClient s3AsyncClient = $this$folderBlocks.getS3();
        ListObjectsRequest.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Sequence<S3Object> $this$forEach$iv = MiscKt.listObjects(s3AsyncClient, builder2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PersistentLongMap.MutableMap $this$write;
            String folderAsFileName;
            S3Object it = (S3Object)element$iv;
            boolean bl = false;
            String string = it.key();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.key()");
            List paths = StringsKt.split$default((CharSequence)string, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            if (paths.size() != 2) continue;
            String folderName = (String)paths.get(0);
            if ((Pair)folders.get(folderName) != null) {
                PersistentLongMap.MutableMap $this$write2;
                Pair pair;
                boolean bl2 = false;
                boolean bl3 = false;
                Pair pair2 = pair;
                boolean bl4 = false;
                if (!FileNameRulesKt.checkAddress((String)paths.get(1))) continue;
                PersistentLongMap $this$write$iv = (PersistentLongMap)pair2.getSecond();
                boolean $i$f$write = false;
                PersistentLongMap.MutableMap mutableMap$iv = $this$write$iv.beginWrite();
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableMap$iv, (String)"mutableMap");
                boolean bl5 = false;
                long address = FileNameRulesKt.decodeAddress((String)paths.get(1));
                S3FactoryBoilerplate s3FactoryBoilerplate = $this$folderBlocks;
                Long l = it.size();
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"it.size()");
                $this$write2.put(address, (Object)new S3SubBlock(s3FactoryBoilerplate, address, l, ((Number)pair2.getFirst()).longValue()));
                mutableMap$iv.endWrite();
                continue;
            }
            if (!StringsKt.startsWith$default((String)folderName, (String)"_", (boolean)false, (int)2, null) || !FileNameRulesKt.isValidAddress(folderAsFileName = FileNameRulesKt.toFileName(StringsKt.drop((String)folderName, (int)1))) || !FileNameRulesKt.checkAddress((String)paths.get(1))) continue;
            long blockAddress = FileNameRulesKt.getAddress(folderAsFileName);
            PersistentBitTreeLongMap persistentBitTreeLongMap = new PersistentBitTreeLongMap();
            Long l = blockAddress;
            String string2 = folderName;
            Map map = folders;
            boolean bl6 = false;
            boolean bl7 = false;
            PersistentBitTreeLongMap $this$apply = persistentBitTreeLongMap;
            boolean bl8 = false;
            PersistentLongMap $this$write$iv = (PersistentLongMap)$this$apply;
            boolean $i$f$write = false;
            PersistentLongMap.MutableMap mutableMap$iv = $this$write$iv.beginWrite();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableMap$iv, (String)"mutableMap");
            boolean bl9 = false;
            long address = FileNameRulesKt.decodeAddress((String)paths.get(1));
            S3FactoryBoilerplate s3FactoryBoilerplate = $this$folderBlocks;
            Long l2 = it.size();
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"it.size()");
            $this$write.put(address, (Object)new S3SubBlock(s3FactoryBoilerplate, address, l2, blockAddress));
            mutableMap$iv.endWrite();
            PersistentBitTreeLongMap persistentBitTreeLongMap2 = persistentBitTreeLongMap;
            map.put(string2, TuplesKt.to((Object)l, (Object)persistentBitTreeLongMap2));
        }
        Collection collection = folders.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"folders.values");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<Pair<? extends Long, ? extends PersistentLongMap<S3SubBlock>>, S3FolderBlock>($this$folderBlocks){
            final /* synthetic */ S3DataReaderOrWriter $this_folderBlocks;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final S3FolderBlock invoke(@NotNull Pair<Long, ? extends PersistentLongMap<S3SubBlock>> it) {
                void $this$fold$iv;
                void $this$read$iv;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                PersistentLongMap persistentLongMap = (PersistentLongMap)it.getSecond();
                long l = ((Number)it.getFirst()).longValue();
                S3FactoryBoilerplate s3FactoryBoilerplate = this.$this_folderBlocks;
                boolean $i$f$read = false;
                PersistentLongMap.ImmutableMap immutableMap = $this$read$iv.beginRead();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"beginRead()");
                PersistentLongMap.ImmutableMap $this$read = immutableMap;
                boolean bl = false;
                Iterable iterable = (Iterable)$this$read;
                long initial$iv = 0L;
                boolean $i$f$fold = false;
                long accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void value;
                    PersistentLongMap.Entry entry = (PersistentLongMap.Entry)element$iv;
                    long acc = accumulator$iv;
                    boolean bl2 = false;
                    void v1 = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"value");
                    accumulator$iv = acc + ((S3SubBlock)v1.getValue()).length();
                }
                long l2 = accumulator$iv;
                PersistentLongMap persistentLongMap2 = (PersistentLongMap)it.getSecond();
                long l3 = l2;
                long l4 = l;
                S3FactoryBoilerplate s3FactoryBoilerplate2 = s3FactoryBoilerplate;
                return new S3FolderBlock(s3FactoryBoilerplate2, l4, l3, (PersistentLongMap<S3SubBlock>)persistentLongMap2);
            }
            {
                this.$this_folderBlocks = s3DataReaderOrWriter;
                super(1);
            }
        })));
    }
}

