/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.io.AbstractDataWriter;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.replication.BasicS3Block;
import jetbrains.exodus.log.replication.MiscKt;
import jetbrains.exodus.log.replication.S3Block;
import jetbrains.exodus.log.replication.S3BlocksKt;
import jetbrains.exodus.log.replication.S3DataReaderOrWriter;
import jetbrains.exodus.log.replication.S3DataReaderOrWriterKt;
import jetbrains.exodus.log.replication.S3DataWriter;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.S3FolderBlock;
import jetbrains.exodus.log.replication.S3FolderBlockKt;
import jetbrains.exodus.log.replication.S3SubBlock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"H\u0014J\b\u0010(\u001a\u00020 H\u0016J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u001bH\u0014J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"H\u0016J \u0010/\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J\u0014\u00105\u001a\u00020\u001b*\u0002062\u0006\u0010'\u001a\u00020\"H\u0002R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Ljetbrains/exodus/log/replication/S3DataWriter;", "Ljetbrains/exodus/log/replication/S3DataReaderOrWriter;", "Ljetbrains/exodus/io/AbstractDataWriter;", "s3Sync", "Lsoftware/amazon/awssdk/services/s3/S3Client;", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "bucket", "", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "log", "Ljetbrains/exodus/log/Log;", "(Lsoftware/amazon/awssdk/services/s3/S3Client;Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;Ljava/lang/String;Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;Ljetbrains/exodus/log/Log;)V", "block", "Ljetbrains/exodus/log/replication/S3FolderBlock;", "getBucket", "()Ljava/lang/String;", "logTip", "Ljetbrains/exodus/log/LogTip;", "getLogTip", "()Ljetbrains/exodus/log/LogTip;", "getRequestOverrideConfig", "()Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "clearImpl", "", "closeImpl", "failIntegrity", "", "lock", "", "timeout", "", "lockInfo", "openOrCreateBlockImpl", "Ljetbrains/exodus/io/Block;", "address", "length", "release", "removeBlock", "blockAddress", "rbt", "Ljetbrains/exodus/io/RemoveBlockType;", "syncImpl", "truncateBlock", "write", "bytes", "", "off", "", "len", "truncate", "Ljetbrains/exodus/log/replication/BasicS3Block;", "Companion", "xodus-multinode"})
public final class S3DataWriter
extends AbstractDataWriter
implements S3DataReaderOrWriter {
    private S3FolderBlock block;
    private final S3Client s3Sync;
    @NotNull
    private final S3AsyncClient s3;
    @NotNull
    private final String bucket;
    @Nullable
    private final AwsRequestOverrideConfiguration requestOverrideConfig;
    private final Log log;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public LogTip getLogTip() {
        Log log = this.log;
        return log != null ? log.getTip() : null;
    }

    protected void syncImpl() {
    }

    @NotNull
    public Block write(@NotNull byte[] bytes, int off, int len) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        S3FolderBlock s3FolderBlock = this.block;
        if (s3FolderBlock == null) {
            throw (Throwable)new ExodusException("Can't write, S3DataWriter is closed");
        }
        S3FolderBlock s3FolderBlock2 = s3FolderBlock;
        boolean bl = false;
        boolean bl2 = false;
        S3FolderBlock $this$with = s3FolderBlock2;
        boolean bl3 = false;
        long subBlockAddress = $this$with.getAddress() + $this$with.length();
        long subBlockSize = len;
        String key = S3DataReaderOrWriterKt.getPartialFolderPrefix($this$with.getAddress()) + S3DataReaderOrWriterKt.getPartialFileName(subBlockAddress);
        Companion.getLogger().info((Function0)new Function0<String>(key, this, len, bytes, off){
            final /* synthetic */ String $key;
            final /* synthetic */ S3DataWriter this$0;
            final /* synthetic */ int $len$inlined;
            final /* synthetic */ byte[] $bytes$inlined;
            final /* synthetic */ int $off$inlined;
            {
                this.$key = string;
                this.this$0 = s3DataWriter;
                this.$len$inlined = n;
                this.$bytes$inlined = byArray;
                this.$off$inlined = n2;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Put file of " + this.$key + ", length: " + this.$len$inlined;
            }
        });
        try {
            PersistentLongMap.MutableMap mutableMap$iv;
            this.s3Sync.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucket()).overrideConfiguration(this.getRequestOverrideConfig()).key(key).contentLength(Long.valueOf(subBlockSize)).build(), RequestBody.fromInputStream((InputStream)new ByteArrayInputStream(bytes, off, len), (long)subBlockSize));
            Object object = $this$with.getBlocks$xodus_multinode().getClone();
            boolean bl4 = false;
            boolean bl5 = false;
            PersistentLongMap $this$apply = object;
            boolean bl6 = false;
            PersistentLongMap $this$write$iv = $this$apply;
            boolean $i$f$write = false;
            PersistentLongMap.MutableMap mutableMap = mutableMap$iv = $this$write$iv.beginWrite();
            Intrinsics.checkExpressionValueIsNotNull((Object)mutableMap, (String)"mutableMap");
            PersistentLongMap.MutableMap $this$write = mutableMap;
            boolean bl7 = false;
            $this$write.put(subBlockAddress, (Object)new S3SubBlock($this$with.getS3factory$xodus_multinode(), subBlockAddress, subBlockSize, $this$with.getAddress()));
            mutableMap$iv.endWrite();
            PersistentLongMap blocksCopy = object;
            S3FactoryBoilerplate s3FactoryBoilerplate = $this$with.getS3factory$xodus_multinode();
            long l = $this$with.getAddress();
            long l2 = $this$with.getSize$xodus_multinode() + subBlockSize;
            PersistentLongMap persistentLongMap = blocksCopy;
            Intrinsics.checkExpressionValueIsNotNull((Object)persistentLongMap, (String)"blocksCopy");
            object = new S3FolderBlock(s3FactoryBoilerplate, l, l2, (PersistentLongMap<S3SubBlock>)persistentLongMap);
            bl4 = false;
            bl5 = false;
            $this$apply = object;
            boolean bl8 = false;
            this.block = $this$apply;
            return (Block)object;
        }
        catch (Exception e) {
            String msg = "failed to update '" + key + "' in S3";
            Companion.getLogger().error(msg, (Throwable)e);
            throw (Throwable)new ExodusException(msg, (Throwable)e);
        }
    }

    @NotNull
    protected Block openOrCreateBlockImpl(long address, long length) {
        S3FolderBlock s3FolderBlock = S3FolderBlockKt.newS3FolderBlock(this, address);
        boolean bl = false;
        boolean bl2 = false;
        S3FolderBlock $this$apply = s3FolderBlock;
        boolean bl3 = false;
        if ($this$apply.length() > length) {
            this.truncateBlock(address, length);
        }
        this.block = $this$apply;
        return s3FolderBlock;
    }

    public void removeBlock(long blockAddress, @NotNull RemoveBlockType rbt) {
        Object $this$apply;
        Object v0;
        Object element$iv3;
        boolean $i$f$firstOrNull;
        Object $this$firstOrNull$iv;
        ArrayList<String> keysToDelete;
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)rbt, (String)"rbt");
            keysToDelete = new ArrayList<String>();
            $this$firstOrNull$iv = S3BlocksKt.getFileBlocks(this);
            $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                element$iv3 = iterator.next();
                S3Block it = (S3Block)element$iv3;
                boolean bl = false;
                if (!(it.getAddress() == blockAddress)) continue;
                v0 = element$iv3;
                break block12;
            }
            v0 = null;
        }
        S3Block s3Block = v0;
        if (s3Block != null) {
            $this$firstOrNull$iv = s3Block;
            $i$f$firstOrNull = false;
            boolean bl = false;
            $this$apply = $this$firstOrNull$iv;
            boolean bl2 = false;
            keysToDelete.add(((S3Block)$this$apply).getKey());
        }
        if (keysToDelete.isEmpty()) {
            Object v2;
            block13: {
                $this$firstOrNull$iv = S3BlocksKt.getFolderBlocks(this);
                $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv3 = iterator.next();
                    S3FolderBlock it = (S3FolderBlock)element$iv3;
                    boolean bl = false;
                    if (!(it.getAddress() == blockAddress)) continue;
                    v2 = element$iv3;
                    break block13;
                }
                v2 = null;
            }
            S3FolderBlock s3FolderBlock = v2;
            if (s3FolderBlock != null) {
                $this$firstOrNull$iv = s3FolderBlock;
                $i$f$firstOrNull = false;
                boolean bl = false;
                $this$apply = $this$firstOrNull$iv;
                boolean bl3 = false;
                PersistentLongMap<S3SubBlock> $this$read$iv = ((S3FolderBlock)$this$apply).getBlocks$xodus_multinode();
                boolean $i$f$read = false;
                PersistentLongMap.ImmutableMap immutableMap = $this$read$iv.beginRead();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"beginRead()");
                PersistentLongMap.ImmutableMap $this$read = immutableMap;
                boolean bl4 = false;
                Iterable $this$forEach$iv = (Iterable)$this$read;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    PersistentLongMap.Entry it = (PersistentLongMap.Entry)element$iv2;
                    boolean bl5 = false;
                    PersistentLongMap.Entry entry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"it");
                    keysToDelete.add(((S3SubBlock)entry.getValue()).getKey());
                }
            }
        }
        if (rbt == RemoveBlockType.Rename) {
            Iterable $this$forEach$iv = keysToDelete;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                String it = (String)element$iv3;
                boolean bl = false;
                String newName = StringsKt.replace$default((String)it, (String)".xd", (String)".del", (boolean)false, (int)4, null);
                Companion.getLogger().debug((Function0)new Function0<String>(it, newName){
                    final /* synthetic */ String $it;
                    final /* synthetic */ String $newName;

                    @NotNull
                    public final String invoke() {
                        return "renaming block " + this.$it + " to " + this.$newName;
                    }
                    {
                        this.$it = string;
                        this.$newName = string2;
                        super(0);
                    }
                });
                try {
                    this.getS3().copyObject((CopyObjectRequest)CopyObjectRequest.builder().bucket(this.getBucket()).overrideConfiguration(this.getRequestOverrideConfig()).copySource(this.getBucket() + '/' + it).key(newName).build()).get();
                }
                catch (Exception e) {
                    String msg = "failed to copy '" + it + "' in S3";
                    Companion.getLogger().error(msg, (Throwable)e);
                    throw (Throwable)new ExodusException(msg, (Throwable)e);
                }
            }
        }
        try {
            MiscKt.deleteS3Objects((List<String>)keysToDelete, this.getS3(), this.getBucket(), this.getRequestOverrideConfig());
        }
        catch (Exception e) {
            String msg = "failed to delete files '" + CollectionsKt.joinToString$default((Iterable)keysToDelete, null, null, null, (int)0, null, null, (int)63, null) + "' in S3";
            Companion.getLogger().error(msg, (Throwable)e);
            throw (Throwable)new ExodusException(msg, (Throwable)e);
        }
    }

    public void truncateBlock(long blockAddress, long length) {
        block2: {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = S3BlocksKt.getFileBlocks(this);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    S3Block it = (S3Block)element$iv;
                    boolean bl = false;
                    if (!(it.getAddress() == blockAddress)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            S3Block s3Block = v0;
            if (s3Block == null) break block2;
            this.truncate(s3Block, length);
        }
    }

    public boolean lock(long timeout) {
        return true;
    }

    public boolean release() {
        return true;
    }

    @Nullable
    public String lockInfo() {
        return null;
    }

    protected void closeImpl() {
        this.block = null;
    }

    protected void clearImpl() {
        Sequence $this$forEach$iv = SequencesKt.windowed((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(MiscKt.listObjects(this.getS3(), MiscKt.listObjectsBuilder(this.getBucket(), this.getRequestOverrideConfig())), (Function1)clearImpl.1.INSTANCE), (Function1)clearImpl.2.INSTANCE), (int)500, (int)500, (boolean)true);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            MiscKt.deleteS3Objects(it, this.getS3(), this.getBucket(), this.getRequestOverrideConfig());
        }
    }

    private final void truncate(@NotNull BasicS3Block $this$truncate, long length) {
        Companion.getLogger().debug((Function0)new Function0<String>($this$truncate, length){
            final /* synthetic */ BasicS3Block $this_truncate;
            final /* synthetic */ long $length;

            @NotNull
            public final String invoke() {
                return "truncating block at " + this.$this_truncate.getKey() + " to " + this.$length;
            }
            {
                this.$this_truncate = basicS3Block;
                this.$length = l;
                super(0);
            }
        });
        try {
            byte[] array = new byte[(int)length];
            $this$truncate.read(array, 0L, 0, (int)length);
            this.getS3().putObject((PutObjectRequest)PutObjectRequest.builder().bucket(this.getBucket()).overrideConfiguration(this.getRequestOverrideConfig()).key($this$truncate.getKey()).contentLength(Long.valueOf(length)).build(), new AsyncRequestBody(length, array){
                final /* synthetic */ long $length;
                final /* synthetic */ byte[] $array;

                public long contentLength() {
                    return this.$length;
                }

                public void subscribe(@NotNull Subscriber<? super ByteBuffer> subscriber) {
                    Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
                    subscriber.onSubscribe(new Subscription(this, subscriber){
                        final /* synthetic */ truncate.2 this$0;
                        final /* synthetic */ Subscriber $subscriber;

                        public void request(long n) {
                            if (n > 0L) {
                                this.$subscriber.onNext((Object)ByteBuffer.wrap(this.this$0.$array));
                                this.$subscriber.onComplete();
                            }
                        }

                        public void cancel() {
                        }
                        {
                            this.this$0 = $outer;
                            this.$subscriber = $captured_local_variable$1;
                        }
                    });
                }
                {
                    this.$length = $captured_local_variable$0;
                    this.$array = $captured_local_variable$1;
                }
            }).get();
        }
        catch (Exception e) {
            String msg = "failed to update " + $this$truncate.getKey();
            Companion.getLogger().error(msg, (Throwable)e);
            throw (Throwable)new ExodusException(msg, (Throwable)e);
        }
    }

    private final Void failIntegrity() {
        throw (Throwable)new IllegalStateException("Concurrency breach");
    }

    @Override
    @NotNull
    public S3AsyncClient getS3() {
        return this.s3;
    }

    @Override
    @NotNull
    public String getBucket() {
        return this.bucket;
    }

    @Override
    @Nullable
    public AwsRequestOverrideConfiguration getRequestOverrideConfig() {
        return this.requestOverrideConfig;
    }

    public S3DataWriter(@NotNull S3Client s3Sync2, @NotNull S3AsyncClient s32, @NotNull String bucket, @Nullable AwsRequestOverrideConfiguration requestOverrideConfig, @Nullable Log log) {
        Intrinsics.checkParameterIsNotNull((Object)s3Sync2, (String)"s3Sync");
        Intrinsics.checkParameterIsNotNull((Object)s32, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        this.s3Sync = s3Sync2;
        this.s3 = s32;
        this.bucket = bucket;
        this.requestOverrideConfig = requestOverrideConfig;
        this.log = log;
    }

    public /* synthetic */ S3DataWriter(S3Client s3Client, S3AsyncClient s3AsyncClient, String string, AwsRequestOverrideConfiguration awsRequestOverrideConfiguration, Log log, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            awsRequestOverrideConfiguration = null;
        }
        if ((n & 0x10) != 0) {
            log = null;
        }
        this(s3Client, s3AsyncClient, string, awsRequestOverrideConfiguration, log);
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> getRemoteFile(long length, long startingLength, @NotNull String name, @NotNull AsyncResponseTransformer<GetObjectResponse, T> handler) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        return S3DataReaderOrWriter.DefaultImpls.getRemoteFile(this, length, startingLength, name, handler);
    }

    @Override
    public boolean checkPreconditions(@NotNull Log log, long expectedLength, long startingLength) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        return S3DataReaderOrWriter.DefaultImpls.checkPreconditions(this, log, expectedLength, startingLength);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/log/replication/S3DataWriter$Companion;", "Lmu/KLogging;", "()V", "xodus-multinode"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

