/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.util.concurrent.CompletableFuture;
import jetbrains.exodus.log.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J@\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00032\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H\u00170\u001bH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "", "bucket", "", "getBucket", "()Ljava/lang/String;", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "getRequestOverrideConfig", "()Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "checkPreconditions", "", "log", "Ljetbrains/exodus/log/Log;", "expectedLength", "", "startingLength", "getRemoteFile", "Ljava/util/concurrent/CompletableFuture;", "T", "length", "name", "handler", "Lsoftware/amazon/awssdk/core/async/AsyncResponseTransformer;", "Lsoftware/amazon/awssdk/services/s3/model/GetObjectResponse;", "xodus-multinode"})
public interface S3FactoryBoilerplate {
    @NotNull
    public S3AsyncClient getS3();

    @NotNull
    public String getBucket();

    @Nullable
    public AwsRequestOverrideConfiguration getRequestOverrideConfig();

    @NotNull
    public <T> CompletableFuture<T> getRemoteFile(long var1, long var3, @NotNull String var5, @NotNull AsyncResponseTransformer<GetObjectResponse, T> var6);

    public boolean checkPreconditions(@NotNull Log var1, long var2, long var4);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static <T> CompletableFuture<T> getRemoteFile(S3FactoryBoilerplate $this, long length, long startingLength, @NotNull String name, @NotNull AsyncResponseTransformer<GetObjectResponse, T> handler) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            CompletableFuture completableFuture = $this.getS3().getObject((GetObjectRequest)GetObjectRequest.builder().range("bytes=" + startingLength + '-' + (length - 1L)).overrideConfiguration($this.getRequestOverrideConfig()).bucket($this.getBucket()).key(name).build(), handler);
            Intrinsics.checkExpressionValueIsNotNull((Object)completableFuture, (String)"s3.getObject(\n          \u2026uild(), handler\n        )");
            return completableFuture;
        }

        public static boolean checkPreconditions(S3FactoryBoilerplate $this, @NotNull Log log, long expectedLength, long startingLength) {
            Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
            if (expectedLength < startingLength || expectedLength > log.getFileLengthBound()) {
                throw (Throwable)new IllegalArgumentException("Incorrect expected length specified");
            }
            return expectedLength == startingLength;
        }
    }
}

