/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.util.List;
import jetbrains.exodus.core.dataStructures.persistent.PersistentBitTreeLongMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.log.replication.FileNameRulesKt;
import jetbrains.exodus.log.replication.MiscKt;
import jetbrains.exodus.log.replication.S3DataReaderOrWriterKt;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.S3FolderBlock;
import jetbrains.exodus.log.replication.S3SubBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"newS3FolderBlock", "Ljetbrains/exodus/log/replication/S3FolderBlock;", "s3factory", "Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "address", "", "xodus-multinode"})
public final class S3FolderBlockKt {
    @NotNull
    public static final S3FolderBlock newS3FolderBlock(@NotNull S3FactoryBoilerplate s3factory, long address) {
        PersistentLongMap.MutableMap mutableMap$iv;
        Intrinsics.checkParameterIsNotNull((Object)s3factory, (String)"s3factory");
        ListObjectsRequest.Builder builder = S3DataReaderOrWriterKt.listObjectsBuilder(s3factory).prefix(S3DataReaderOrWriterKt.getPartialFolderPrefix(address));
        PersistentBitTreeLongMap subBlocks = new PersistentBitTreeLongMap();
        long size = 0L;
        PersistentLongMap $this$write$iv = (PersistentLongMap)subBlocks;
        boolean $i$f$write = false;
        PersistentLongMap.MutableMap mutableMap = mutableMap$iv = $this$write$iv.beginWrite();
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableMap, (String)"mutableMap");
        PersistentLongMap.MutableMap $this$write = mutableMap;
        boolean bl = false;
        S3AsyncClient s3AsyncClient = s3factory.getS3();
        ListObjectsRequest.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        Sequence<S3Object> $this$forEach$iv = MiscKt.listObjects(s3AsyncClient, builder2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Long subBlockSize;
            S3Object it = (S3Object)element$iv;
            boolean bl2 = false;
            String string = it.key();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.key()");
            List paths = StringsKt.split$default((CharSequence)string, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            if (paths.size() != 2) continue;
            long subBlockAddress = FileNameRulesKt.decodeAddress((String)paths.get(1));
            Long l = subBlockSize = it.size();
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"subBlockSize");
            $this$write.put(subBlockAddress, (Object)new S3SubBlock(s3factory, subBlockAddress, l, address));
            size += subBlockSize.longValue();
        }
        mutableMap$iv.endWrite();
        return new S3FolderBlock(s3factory, address, size, (PersistentLongMap<S3SubBlock>)((PersistentLongMap)subBlocks));
    }
}

