/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log.replication;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.log.replication.BufferQueueAsyncHandler;
import jetbrains.exodus.log.replication.FileFactory;
import jetbrains.exodus.log.replication.S3FactoryBoilerplate;
import jetbrains.exodus.log.replication.WriteResult;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ljetbrains/exodus/log/replication/S3ToWriterFileFactory;", "Ljetbrains/exodus/log/replication/S3FactoryBoilerplate;", "Ljetbrains/exodus/log/replication/FileFactory;", "s3", "Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "bucket", "", "requestOverrideConfig", "Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "(Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;Ljava/lang/String;Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;)V", "getBucket", "()Ljava/lang/String;", "getRequestOverrideConfig", "()Lsoftware/amazon/awssdk/awscore/AwsRequestOverrideConfiguration;", "getS3", "()Lsoftware/amazon/awssdk/services/s3/S3AsyncClient;", "fetchFile", "Ljetbrains/exodus/log/replication/WriteResult;", "log", "Ljetbrains/exodus/log/Log;", "address", "", "startingLength", "expectedLength", "finalFile", "", "xodus-multinode"})
public final class S3ToWriterFileFactory
implements S3FactoryBoilerplate,
FileFactory {
    @NotNull
    private final S3AsyncClient s3;
    @NotNull
    private final String bucket;
    @Nullable
    private final AwsRequestOverrideConfiguration requestOverrideConfig;

    @Override
    @NotNull
    public WriteResult fetchFile(@NotNull Log log, long address, long startingLength, long expectedLength, boolean finalFile) {
        ByteBuffer buffer;
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        if (this.checkPreconditions(log, expectedLength, startingLength)) {
            return WriteResult.Companion.getEmpty();
        }
        BufferQueueAsyncHandler handler = new BufferQueueAsyncHandler();
        String string = LogUtil.getLogFilename((long)address);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LogUtil.getLogFilename(address)");
        CompletableFuture request = this.getRemoteFile(expectedLength, startingLength, string, handler);
        ArrayBlockingQueue<ByteBuffer> queue = handler.getQueue();
        Subscription subscription = BufferQueueAsyncHandler.waitForSubscription$default(handler, request, 0L, 2, null);
        long written = 0L;
        while ((buffer = queue.take()) != BufferQueueAsyncHandler.Companion.getFinish()) {
            int count = buffer.remaining();
            byte[] output = new byte[count];
            buffer.get(output);
            subscription.request(1L);
            if (log.writeContinuously(output, count) < 0L) {
                throw (Throwable)new IllegalStateException("Cannot write full file");
            }
            written += (long)count;
        }
        GetObjectResponse response = (GetObjectResponse)request.get();
        Long l = response.contentLength();
        if (l == null || l != written) {
            throw (Throwable)new IllegalStateException("Write length mismatch");
        }
        if (finalFile) {
            log.flush(true);
        }
        return new WriteResult(written, log.ensureWriter().getLastPageLength());
    }

    @Override
    @NotNull
    public S3AsyncClient getS3() {
        return this.s3;
    }

    @Override
    @NotNull
    public String getBucket() {
        return this.bucket;
    }

    @Override
    @Nullable
    public AwsRequestOverrideConfiguration getRequestOverrideConfig() {
        return this.requestOverrideConfig;
    }

    public S3ToWriterFileFactory(@NotNull S3AsyncClient s32, @NotNull String bucket, @Nullable AwsRequestOverrideConfiguration requestOverrideConfig) {
        Intrinsics.checkParameterIsNotNull((Object)s32, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        this.s3 = s32;
        this.bucket = bucket;
        this.requestOverrideConfig = requestOverrideConfig;
    }

    public /* synthetic */ S3ToWriterFileFactory(S3AsyncClient s3AsyncClient, String string, AwsRequestOverrideConfiguration awsRequestOverrideConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            awsRequestOverrideConfiguration = null;
        }
        this(s3AsyncClient, string, awsRequestOverrideConfiguration);
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> getRemoteFile(long length, long startingLength, @NotNull String name, @NotNull AsyncResponseTransformer<GetObjectResponse, T> handler) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        return S3FactoryBoilerplate.DefaultImpls.getRemoteFile(this, length, startingLength, name, handler);
    }

    @Override
    public boolean checkPreconditions(@NotNull Log log, long expectedLength, long startingLength) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        return S3FactoryBoilerplate.DefaultImpls.checkPreconditions(this, log, expectedLength, startingLength);
    }
}

