/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.BooleanBinding;
import jetbrains.exodus.bindings.ByteBinding;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.ComparableSetBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.ShortBinding;
import jetbrains.exodus.bindings.SignedDoubleBinding;
import jetbrains.exodus.bindings.SignedFloatBinding;
import jetbrains.exodus.bindings.StringBinding;
import org.jetbrains.annotations.NotNull;

public class ComparableValueType {
    public static final int STRING_VALUE_TYPE = 2;
    public static final int DOUBLE_VALUE_TYPE = 3;
    public static final int FLOAT_VALUE_TYPE = 7;
    public static final int COMPARABLE_SET_VALUE_TYPE = 8;
    public static final ComparableValueType[] PREDEFINED_COMPARABLE_VALUE_TYPES;
    private static final Class[] PREDEFINED_CLASSES;
    private static final ComparableBinding[] PREDEFINED_BINDINGS;
    private final int typeId;
    private final ComparableBinding binding;
    private final Class<? extends Comparable> clazz;

    public ComparableValueType(int typeId, @NotNull ComparableBinding binding, @NotNull Class<? extends Comparable> clazz) {
        this.typeId = typeId;
        this.binding = binding;
        this.clazz = clazz;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public ComparableBinding getBinding() {
        return this.binding;
    }

    public Class<? extends Comparable> getClazz() {
        return this.clazz;
    }

    public static ComparableBinding getPredefinedBinding(int typeId) {
        return PREDEFINED_BINDINGS[typeId];
    }

    public static ComparableValueType getPredefinedType(@NotNull Class<? extends Comparable> clazz) {
        for (int i = 0; i < PREDEFINED_CLASSES.length; ++i) {
            if (!PREDEFINED_CLASSES[i].equals(clazz)) continue;
            return PREDEFINED_COMPARABLE_VALUE_TYPES[i];
        }
        throw new ExodusException("Unsupported Comparable value type: " + clazz);
    }

    static {
        PREDEFINED_CLASSES = new Class[]{Integer.class, Long.class, String.class, Double.class, Byte.class, Boolean.class, Short.class, Float.class, ComparableSet.class};
        PREDEFINED_BINDINGS = new ComparableBinding[]{IntegerBinding.BINDING, LongBinding.BINDING, StringBinding.BINDING, SignedDoubleBinding.BINDING, ByteBinding.BINDING, BooleanBinding.BINDING, ShortBinding.BINDING, SignedFloatBinding.BINDING, ComparableSetBinding.BINDING};
        PREDEFINED_COMPARABLE_VALUE_TYPES = new ComparableValueType[PREDEFINED_CLASSES.length];
        for (int i = 0; i < PREDEFINED_COMPARABLE_VALUE_TYPES.length; ++i) {
            ComparableValueType.PREDEFINED_COMPARABLE_VALUE_TYPES[i] = new ComparableValueType(i, PREDEFINED_BINDINGS[i], PREDEFINED_CLASSES[i]);
        }
    }
}

