/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.binop.AddNullDecoratorIterable;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.StaticTypedEntityIterable;

public class AddNullStaticTypedEntityIterable
extends StaticTypedEntityIterable {
    private final StaticTypedEntityIterable decorated;
    private final StaticTypedEntityIterable nullContainer;

    public AddNullStaticTypedEntityIterable(String entityType, StaticTypedEntityIterable decorated, StaticTypedEntityIterable nullContainer, QueryEngine engine) {
        super(engine);
        this.entityType = entityType;
        this.decorated = decorated;
        this.nullContainer = nullContainer;
    }

    @Override
    public Iterable<Entity> instantiate() {
        Iterable<Entity> instantiatedDecorated = this.decorated.instantiate();
        Iterable<Entity> instantiatedNullContainer = this.nullContainer.instantiate();
        if (this.queryEngine.isPersistentIterable(instantiatedDecorated) && this.queryEngine.isPersistentIterable(instantiatedNullContainer)) {
            EntityIterableBase entityIterableBaseDecorated = ((EntityIterableBase)instantiatedDecorated).getSource();
            EntityIterableBase entityIterableBaseNullContainer = ((EntityIterableBase)instantiatedNullContainer).getSource();
            return this.queryEngine.wrap((EntityIterable)new AddNullDecoratorIterable(this.queryEngine.getPersistentStore().getAndCheckCurrentTransaction(), entityIterableBaseDecorated, entityIterableBaseNullContainer));
        }
        return () -> new Iterator<Entity>(){
            private Boolean hasNull = null;
            private Iterator iterator = null;

            @Override
            public boolean hasNext() {
                if (this.iterator == null) {
                    this.iterator = AddNullStaticTypedEntityIterable.this.decorated.iterator();
                }
                if (this.iterator.hasNext()) {
                    return true;
                }
                if (this.hasNull == null) {
                    this.hasNull = false;
                    for (Entity entity : AddNullStaticTypedEntityIterable.this.nullContainer) {
                        if (entity != null) continue;
                        this.hasNull = true;
                        break;
                    }
                }
                return this.hasNull;
            }

            @Override
            public Entity next() {
                if (this.hasNext()) {
                    if (this.hasNull == null) {
                        Entity result = (Entity)this.iterator.next();
                        if (result == null) {
                            this.hasNull = false;
                        }
                        return result;
                    }
                    this.hasNull = false;
                    return null;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

