/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.query.NodeBase;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0006\u0010\u0013\u001a\u00020\u0001J\u0006\u0010\u0014\u001a\u00020\u0001J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0001H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0001H\u0004J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0001H\u0004R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ljetbrains/exodus/query/BinaryOperator;", "Ljetbrains/exodus/query/NodeBase;", "left", "right", "(Ljetbrains/exodus/query/NodeBase;Ljetbrains/exodus/query/NodeBase;)V", "children", "", "depth", "", "getDepth", "()I", "setDepth", "(I)V", "getChildren", "", "getHandle", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "getLeft", "getRight", "invalidateDepth", "", "matchChildren", "", "node", "ctx", "Ljetbrains/exodus/query/NodeBase$MatchContext;", "matchChildren$xodus_query", "replaceChild", "child", "newChild", "setLeft", "setRight", "Companion", "xodus-query"})
public abstract class BinaryOperator
extends NodeBase {
    private List<NodeBase> children;
    private int depth;
    private NodeBase left;
    private NodeBase right;
    private static final Logger logger;
    private static final boolean isWarnEnabled;
    private static final int MAXIMUM_LEGAL_DEPTH = 200;
    private static final int LARGE_DEPTH_LOGGING_FREQ = 10000;
    private static volatile long lastLoggedMillis;
    public static final Companion Companion;

    protected final int getDepth() {
        return this.depth;
    }

    protected final void setDepth(int n) {
        this.depth = n;
    }

    @NotNull
    public final NodeBase getLeft() {
        return this.left;
    }

    @NotNull
    public final NodeBase getRight() {
        return this.right;
    }

    @Override
    @NotNull
    public NodeBase replaceChild(@NotNull NodeBase child, @NotNull NodeBase newChild) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Intrinsics.checkParameterIsNotNull((Object)newChild, (String)"newChild");
        if (child == this.left) {
            this.setLeft(newChild);
        } else if (child == this.right) {
            this.setRight(newChild);
        } else {
            throw (Throwable)new ExodusException(this.getClass() + ": can't replace not own child");
        }
        newChild.setParent(this);
        return child;
    }

    @Override
    @NotNull
    public Collection<NodeBase> getChildren() {
        Collection collection;
        List<NodeBase> list = this.children;
        if (list != null) {
            collection = list;
        } else {
            ArrayList<NodeBase> arrayList = new ArrayList<NodeBase>(2);
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<NodeBase> $this$apply = arrayList;
            boolean bl3 = false;
            $this$apply.add(this.left);
            $this$apply.add(this.right);
            this.children = $this$apply;
            collection = arrayList;
        }
        return collection;
    }

    public boolean matchChildren$xodus_query(@NotNull NodeBase node, @NotNull NodeBase.MatchContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        BinaryOperator bo = (BinaryOperator)node;
        return this.left.match(bo.left, ctx) && this.right.match(bo.right, ctx);
    }

    protected final void setLeft(@NotNull NodeBase left) {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        this.left = left;
        List<NodeBase> list = this.children;
        if (list != null) {
            List<NodeBase> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<NodeBase> it = list2;
            boolean bl3 = false;
            it.set(0, left);
        }
        this.invalidateDepth(left, this.right);
    }

    protected final void setRight(@NotNull NodeBase right) {
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        this.right = right;
        List<NodeBase> list = this.children;
        if (list != null) {
            List<NodeBase> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<NodeBase> it = list2;
            boolean bl3 = false;
            it.set(1, right);
        }
        this.invalidateDepth(this.left, right);
    }

    private final void invalidateDepth(NodeBase left, NodeBase right) {
        NodeBase nodeBase = left;
        if (!(nodeBase instanceof BinaryOperator)) {
            nodeBase = null;
        }
        BinaryOperator binaryOperator = (BinaryOperator)nodeBase;
        int leftDepth = binaryOperator != null ? binaryOperator.depth : 1;
        NodeBase nodeBase2 = right;
        if (!(nodeBase2 instanceof BinaryOperator)) {
            nodeBase2 = null;
        }
        BinaryOperator binaryOperator2 = (BinaryOperator)nodeBase2;
        int rightDepth = binaryOperator2 != null ? binaryOperator2.depth : 1;
        this.depth = Integer.max(leftDepth, rightDepth) + 1;
    }

    @Override
    @NotNull
    public StringBuilder getHandle(@NotNull StringBuilder sb) {
        Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
        super.getHandle(sb).append('{');
        StringBuilder stringBuilder = this.right.getHandle(this.left.getHandle(sb).append(',')).append('}');
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"right.getHandle(left.get\u2026.append(',')).append('}')");
        return stringBuilder;
    }

    public BinaryOperator(@NotNull NodeBase left, @NotNull NodeBase right) {
        long millis;
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        this.left = left;
        this.right = right;
        NodeBase nodeBase = NodeBase.getUnderRoot(this.left);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeBase, (String)"getUnderRoot(left)");
        this.left = nodeBase;
        NodeBase nodeBase2 = NodeBase.getUnderRoot(this.right);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeBase2, (String)"getUnderRoot(right)");
        this.right = nodeBase2;
        this.left.setParent(this);
        this.right.setParent(this);
        this.invalidateDepth(this.left, this.right);
        if (isWarnEnabled && this.depth >= 200 && this.depth % 200 == 0 && (millis = System.currentTimeMillis()) - lastLoggedMillis > (long)10000) {
            lastLoggedMillis = millis;
            logger.warn("Binary operator of too great depth", new Throwable());
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = BinaryOperator.logger = LoggerFactory.getLogger(BinaryOperator.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        isWarnEnabled = logger.isWarnEnabled();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/query/BinaryOperator$Companion;", "", "()V", "LARGE_DEPTH_LOGGING_FREQ", "", "MAXIMUM_LEGAL_DEPTH", "isWarnEnabled", "", "lastLoggedMillis", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "xodus-query"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

