/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Sort;
import jetbrains.exodus.query.SortEngine;
import jetbrains.exodus.query.Utils;
import org.jetbrains.annotations.NotNull;

public class ComparableGetterSort
extends Sort {
    private final ComparableGetter valueGetter;

    protected ComparableGetterSort(NodeBase child, ComparableGetter valueGetter, boolean ascending) {
        super(child, ascending);
        this.valueGetter = valueGetter;
    }

    public ComparableGetter getValueGetter() {
        return this.valueGetter;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    public NodeBase getClone() {
        return new ComparableGetterSort(this.getChild().getClone(), this.valueGetter, this.getAscending());
    }

    @Override
    public boolean equalAsSort(Object o) {
        if (!(o instanceof ComparableGetterSort)) {
            return false;
        }
        ComparableGetterSort sort2 = (ComparableGetterSort)o;
        return Utils.safe_equals(this.valueGetter, sort2.valueGetter) && this.getAscending() == sort2.getAscending();
    }

    @Override
    public Iterable<Entity> applySort(String entityType, Iterable<Entity> iterable, @NotNull SortEngine sortEngine) {
        return sortEngine.sortInMemory(iterable, this.valueGetter, this.getAscending());
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        super.getHandle(sb).append('(').append(this.valueGetter).append(' ').append(this.getAscending()).append(')').append('{');
        this.child.getHandle(sb);
        return sb.append('}');
    }

    @Override
    public String getSimpleName() {
        return "cgs";
    }

    public static ComparableGetterSort create(NodeBase child, ComparableGetter valueGetter, boolean ascending) {
        return new ComparableGetterSort(child, valueGetter, ascending);
    }
}

