/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Iterator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.LinkNotNull;
import jetbrains.exodus.query.Minus;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.NodeFactory;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.PropertyEqual;
import jetbrains.exodus.query.PropertyNotNull;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\u0018\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\n\u0010\u0016\u001a\u00060\u0014j\u0002`\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0004J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0014R\u001a\u0010\u0004\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006)"}, d2={"Ljetbrains/exodus/query/LinksEqualDecorator;", "Ljetbrains/exodus/query/NodeBase;", "linkName", "", "decorated", "linkEntityType", "(Ljava/lang/String;Ljetbrains/exodus/query/NodeBase;Ljava/lang/String;)V", "getDecorated", "()Ljetbrains/exodus/query/NodeBase;", "setDecorated", "(Ljetbrains/exodus/query/NodeBase;)V", "getLinkEntityType", "()Ljava/lang/String;", "getLinkName", "equals", "", "other", "", "getClone", "getHandle", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "getSimpleName", "instantiate", "", "Ljetbrains/exodus/entitystore/Entity;", "entityType", "queryEngine", "Ljetbrains/exodus/query/QueryEngine;", "metaData", "Ljetbrains/exodus/query/metadata/ModelMetaData;", "instantiateDecorated", "optimize", "", "sorts", "Ljetbrains/exodus/query/Sorts;", "rules", "Ljetbrains/exodus/query/OptimizationPlan;", "toString", "prefix", "xodus-query"})
public final class LinksEqualDecorator
extends NodeBase {
    @NotNull
    private final String linkName;
    @NotNull
    private NodeBase decorated;
    @NotNull
    private final String linkEntityType;

    @Override
    @NotNull
    public Iterable<Entity> instantiate(@NotNull String entityType, @NotNull QueryEngine queryEngine, @NotNull ModelMetaData metaData) {
        Intrinsics.checkParameterIsNotNull((Object)entityType, (String)"entityType");
        Intrinsics.checkParameterIsNotNull((Object)queryEngine, (String)"queryEngine");
        Intrinsics.checkParameterIsNotNull((Object)metaData, (String)"metaData");
        queryEngine.assertOperational();
        EntityIterable entityIterable = queryEngine.instantiateGetAll(entityType);
        if (entityIterable == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIterableBase");
        }
        EntityIterable entityIterable2 = ((EntityIterableBase)entityIterable).findLinks(this.instantiateDecorated(this.linkEntityType, queryEngine, metaData), this.linkName);
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterable2, (String)"(queryEngine.instantiate\u2026ine, metaData), linkName)");
        return (Iterable)entityIterable2;
    }

    @Override
    @NotNull
    public NodeBase getClone() {
        NodeBase nodeBase = this.decorated.getClone();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeBase, (String)"decorated.clone");
        return new LinksEqualDecorator(this.linkName, nodeBase, this.linkEntityType);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final Iterable<Entity> instantiateDecorated(@NotNull String entityType, @NotNull QueryEngine queryEngine, @Nullable ModelMetaData metaData) {
        EntityMetaData emd;
        Intrinsics.checkParameterIsNotNull((Object)entityType, (String)"entityType");
        Intrinsics.checkParameterIsNotNull((Object)queryEngine, (String)"queryEngine");
        ModelMetaData modelMetaData = metaData;
        EntityMetaData entityMetaData = emd = modelMetaData != null ? modelMetaData.getEntityMetaData(entityType) : null;
        Iterable<Entity> result = entityMetaData != null && entityMetaData.isAbstract() ? (Iterable<Entity>)EntityIterableBase.EMPTY : this.decorated.instantiate(entityType, queryEngine, metaData);
        Object object = emd;
        if (object == null || (object = object.getSubTypes()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator2 = object.iterator();
        while (true) {
            String subType;
            if (!iterator2.hasNext()) {
                Iterable<Entity> iterable = result;
                Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"result");
                return iterable;
            }
            String string = subType = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"subType");
            result = queryEngine.unionAdjusted(result, this.instantiateDecorated(string, queryEngine, metaData));
        }
    }

    @Override
    public void optimize(@NotNull Sorts sorts, @NotNull OptimizationPlan rules) {
        Intrinsics.checkParameterIsNotNull((Object)sorts, (String)"sorts");
        Intrinsics.checkParameterIsNotNull((Object)rules, (String)"rules");
        if (this.decorated instanceof LinkEqual) {
            NodeBase nodeBase = this.decorated;
            if (nodeBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.query.LinkEqual");
            }
            LinkEqual linkEqual = (LinkEqual)nodeBase;
            if (linkEqual.getToId() == null) {
                this.decorated = new Minus(NodeFactory.all(), new LinkNotNull(linkEqual.getName()));
            }
        } else if (this.decorated instanceof PropertyEqual) {
            NodeBase nodeBase = this.decorated;
            if (nodeBase == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.query.PropertyEqual");
            }
            PropertyEqual propEqual = (PropertyEqual)nodeBase;
            if (propEqual.getValue() == null) {
                this.decorated = new Minus(NodeFactory.all(), new PropertyNotNull(propEqual.getName()));
            }
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        this.checkWildcard(other);
        if (!(other instanceof LinksEqualDecorator)) {
            return false;
        }
        Object decorator = other;
        return !Utils.safe_equals(this.linkName, ((LinksEqualDecorator)decorator).linkName) || !Utils.safe_equals(this.linkEntityType, ((LinksEqualDecorator)decorator).linkEntityType) ? false : Utils.safe_equals(this.decorated, ((LinksEqualDecorator)decorator).decorated);
    }

    @Override
    @NotNull
    protected String toString(@NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return StringsKt.trimIndent((String)("\n            " + super.toString(prefix) + "\n            " + this.decorated.toString("  " + prefix) + "\n            "));
    }

    @Override
    @NotNull
    public StringBuilder getHandle(@NotNull StringBuilder sb) {
        Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
        super.getHandle(sb).append('(').append(this.linkName).append(',').append(this.linkEntityType).append(')').append('{');
        StringBuilder stringBuilder = this.decorated.getHandle(sb).append('}');
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"decorated.getHandle(sb).append('}')");
        return stringBuilder;
    }

    @Override
    @NotNull
    public String getSimpleName() {
        return "led";
    }

    @NotNull
    public final String getLinkName() {
        return this.linkName;
    }

    @NotNull
    public final NodeBase getDecorated() {
        return this.decorated;
    }

    public final void setDecorated(@NotNull NodeBase nodeBase) {
        Intrinsics.checkParameterIsNotNull((Object)nodeBase, (String)"<set-?>");
        this.decorated = nodeBase;
    }

    @NotNull
    public final String getLinkEntityType() {
        return this.linkEntityType;
    }

    public LinksEqualDecorator(@NotNull String linkName, @NotNull NodeBase decorated, @NotNull String linkEntityType) {
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        Intrinsics.checkParameterIsNotNull((Object)decorated, (String)"decorated");
        Intrinsics.checkParameterIsNotNull((Object)linkEntityType, (String)"linkEntityType");
        this.linkName = linkName;
        this.decorated = decorated;
        this.linkEntityType = linkEntityType;
    }
}

