/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.ConversionWildcard;
import jetbrains.exodus.query.OptimizationPlan;
import jetbrains.exodus.query.OptimizationRule;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Root;
import jetbrains.exodus.query.Sorts;
import jetbrains.exodus.query.UnaryNode;
import jetbrains.exodus.query.Wildcard;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.exodus.util.StringInterner;

public abstract class NodeBase {
    protected static final List<NodeBase> NO_CHILDREN = Collections.emptyList();
    static final String TREE_LEVEL_INDENT = "  ";
    private NodeBase parent;

    protected NodeBase() {
    }

    public NodeBase getParent() {
        return this.parent;
    }

    public void setParent(NodeBase parent) {
        if (this.parent != null) {
            this.parent = null;
        }
        this.parent = parent;
    }

    public NodeBase replaceChild(NodeBase child, NodeBase newChild) {
        throw new ExodusException(this.getClass() + ": can't replace child.");
    }

    public abstract Iterable<Entity> instantiate(String var1, QueryEngine var2, ModelMetaData var3);

    public abstract NodeBase getClone();

    public Collection<NodeBase> getChildren() {
        return NO_CHILDREN;
    }

    public void optimize(Sorts sorts, OptimizationPlan rules) {
        boolean applied = true;
        block0: while (applied) {
            applied = false;
            for (NodeBase child : this.getChildren()) {
                child.optimize(sorts, rules);
                if (!child.optimize(rules)) continue;
                applied = true;
                continue block0;
            }
        }
    }

    private boolean optimize(OptimizationPlan rules) {
        for (OptimizationRule rule : rules.rules) {
            if (!this.replaceIfMatches(rule)) continue;
            return true;
        }
        return false;
    }

    public void cleanSorts(Sorts sorts) {
        for (NodeBase child : this.getChildren()) {
            child.cleanSorts(sorts);
        }
    }

    public boolean equals(Object obj) {
        NodeBase node = (NodeBase)obj;
        Iterator<NodeBase> iterator2 = node.getChildren().iterator();
        for (NodeBase child1 : this.getChildren()) {
            NodeBase child2;
            if (child1.equals(child2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public void checkWildcard(Object obj) {
        if (obj instanceof Wildcard || obj instanceof ConversionWildcard) {
            throw new RuntimeException("Can't compare wildcard with " + obj.getClass() + '.');
        }
    }

    boolean canBeCached() {
        for (NodeBase child : this.getChildren()) {
            if (child == this || child.canBeCached()) continue;
            return false;
        }
        return true;
    }

    boolean replaceIfMatches(OptimizationRule rule) {
        MatchContext ctx = new MatchContext();
        if (!this.match(rule.getSource(), ctx)) {
            return false;
        }
        this.parent.replaceChild(this, NodeBase.substituteMatches(rule.getDest(), ctx));
        return true;
    }

    protected boolean match(NodeBase node, MatchContext ctx) {
        if (node instanceof Wildcard) {
            NodeBase nodeInst = ctx.getNode((Wildcard)node);
            if (nodeInst == null) {
                ctx.putNode((Wildcard)node, this);
                return true;
            }
            return this.equals(nodeInst);
        }
        if (node instanceof ConversionWildcard) {
            ConversionWildcard customWildcard = (ConversionWildcard)node;
            if (!this.getClass().equals(customWildcard.getClazz())) {
                return false;
            }
            if (!customWildcard.isOk(this)) {
                return false;
            }
            NodeBase leafInst = ctx.getLeave((ConversionWildcard)node);
            if (leafInst == null) {
                ctx.putLeave(customWildcard, this);
                return true;
            }
            return this.equals(leafInst);
        }
        return this.getClass().equals(node.getClass()) && this.matchChildren(node, ctx);
    }

    protected boolean polymorphic() {
        return false;
    }

    boolean matchChildren(NodeBase node, MatchContext ctx) {
        return true;
    }

    public String toString() {
        return this.toString("");
    }

    boolean toString(StringBuilder result, NodeBase subtree, String presentation) {
        return this.toString(result, "", subtree, presentation);
    }

    protected String toString(String prefix) {
        StringBuilder result = new StringBuilder(prefix).append(this.getClass().getSimpleName());
        for (NodeBase child : this.getChildren()) {
            result.append('\n').append(child.toString(TREE_LEVEL_INDENT + prefix));
        }
        return result.toString();
    }

    private boolean toString(StringBuilder result, String prefix, NodeBase subtree, String presentation) {
        if (this.equals(subtree)) {
            result.append((prefix + presentation).replace("\n", '\n' + prefix));
            return true;
        }
        result.append(prefix);
        result.append(this.getClass().getSimpleName());
        boolean used = false;
        for (NodeBase child : this.getChildren()) {
            boolean presentationUsed;
            result.append('\n');
            StringBuilder childResult = new StringBuilder();
            boolean bl = presentationUsed = !used && child.toString(childResult, TREE_LEVEL_INDENT + prefix, subtree, presentation);
            if (presentationUsed) {
                subtree = null;
                result.append((CharSequence)childResult);
            } else {
                result.append(child.toString(TREE_LEVEL_INDENT + prefix));
            }
            used |= presentationUsed;
        }
        return used;
    }

    String getHandle() {
        return StringInterner.intern((StringBuilder)this.getHandle(new StringBuilder(32)), (int)100);
    }

    public StringBuilder getHandle(StringBuilder sb) {
        return sb.append(this.getSimpleName());
    }

    public abstract String getSimpleName();

    public int size() {
        int r = 1;
        for (NodeBase child : this.getChildren()) {
            r += child.size();
        }
        return r;
    }

    public Iterable<NodeBase> getDescendants() {
        return () -> {
            final LinkedList<NodeBase> stack = new LinkedList<NodeBase>();
            stack.add(this);
            return new Iterator<NodeBase>(){

                @Override
                public boolean hasNext() {
                    return !stack.isEmpty();
                }

                @Override
                public NodeBase next() {
                    if (stack.isEmpty()) {
                        throw new NoSuchElementException();
                    }
                    NodeBase result = (NodeBase)stack.remove(0);
                    stack.addAll(0, result.getChildren());
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        };
    }

    public static NodeBase getUnderRoot(NodeBase root) {
        while (root instanceof Root) {
            root = ((UnaryNode)root).getChild();
        }
        return root;
    }

    private static NodeBase substituteMatches(NodeBase pattern, MatchContext ctx) {
        Root root = new Root(pattern.getClone());
        for (NodeBase node : root.getDescendants()) {
            if (node instanceof Wildcard) {
                node.parent.replaceChild(node, ctx.getNode((Wildcard)node));
                continue;
            }
            if (!(node instanceof ConversionWildcard)) continue;
            ConversionWildcard customWildcard = (ConversionWildcard)node;
            node.parent.replaceChild(node, customWildcard.convert(ctx.getLeave((ConversionWildcard)node)));
        }
        return root.getChild();
    }

    static class MatchContext {
        private Map<Wildcard, NodeBase> nodes;
        private Map<ConversionWildcard, NodeBase> leaves;

        private MatchContext() {
        }

        private NodeBase getNode(Wildcard wildcard) {
            return this.nodes == null ? null : this.nodes.get(wildcard);
        }

        private void putNode(Wildcard wildcard, NodeBase node) {
            if (this.nodes == null) {
                this.nodes = new HashMap<Wildcard, NodeBase>();
            }
            this.nodes.put(wildcard, node);
        }

        private NodeBase getLeave(ConversionWildcard wildcard) {
            return this.leaves == null ? null : this.leaves.get(wildcard);
        }

        private void putLeave(ConversionWildcard wildcard, NodeBase node) {
            if (this.leaves == null) {
                this.leaves = new HashMap<ConversionWildcard, NodeBase>();
            }
            this.leaves.put(wildcard, node);
        }
    }
}

