/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import jetbrains.exodus.query.metadata.PropertyMetaData;
import jetbrains.exodus.query.metadata.PropertyType;

public class PropertyNotNull
extends NodeBase {
    private final String name;

    public PropertyNotNull(String name) {
        this.name = name;
    }

    @Override
    public Iterable<Entity> instantiate(String entityType, QueryEngine queryEngine, ModelMetaData metaData) {
        EntityMetaData emd = metaData == null ? null : metaData.getEntityMetaData(entityType);
        PropertyMetaData pmd = emd == null ? null : emd.getPropertyMetaData(this.name);
        queryEngine.assertOperational();
        PersistentStoreTransaction txn = queryEngine.getPersistentStore().getAndCheckCurrentTransaction();
        return pmd == null || pmd.getType() == PropertyType.PRIMITIVE ? txn.findWithProp(entityType, this.name) : txn.findWithBlob(entityType, this.name);
    }

    @Override
    public NodeBase getClone() {
        return new PropertyNotNull(this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        this.checkWildcard(obj);
        if (!(obj instanceof PropertyNotNull)) {
            return false;
        }
        PropertyNotNull propertyNotNull = (PropertyNotNull)obj;
        return Utils.safe_equals(this.name, propertyNotNull.name);
    }

    @Override
    public String toString(String prefix) {
        return super.toString(prefix) + '(' + this.name + "!=null) ";
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        return super.getHandle(sb).append('(').append(this.name).append(')');
    }

    @Override
    public String getSimpleName() {
        return "pnn";
    }
}

