/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Sort;
import jetbrains.exodus.query.SortEngine;
import jetbrains.exodus.query.Utils;
import org.jetbrains.annotations.NotNull;

public class SortByLinkProperty
extends Sort {
    private final String enumType;
    private final String propName;
    private final String linkName;

    public SortByLinkProperty(NodeBase child, String enumType, String propName, String linkName, boolean ascending) {
        super(child, ascending);
        this.enumType = enumType;
        this.propName = propName;
        this.linkName = linkName;
    }

    @Override
    public NodeBase getClone() {
        return new SortByLinkProperty(this.getChild().getClone(), this.enumType, this.propName, this.linkName, this.getAscending());
    }

    @Override
    public boolean equalAsSort(Object o) {
        if (!(o instanceof SortByLinkProperty)) {
            return false;
        }
        SortByLinkProperty sort2 = (SortByLinkProperty)o;
        return this.getAscending() == sort2.getAscending() && Utils.safe_equals(this.enumType, sort2.enumType) && Utils.safe_equals(this.propName, sort2.propName) && Utils.safe_equals(this.linkName, sort2.linkName);
    }

    @Override
    public Iterable<Entity> applySort(String entityType, Iterable<Entity> iterable, @NotNull SortEngine sortEngine) {
        return sortEngine.sort(this.enumType, this.propName, entityType, this.linkName, iterable, this.getAscending());
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        super.getHandle(sb).append('(').append(this.enumType).append(',').append(this.propName).append(',').append(this.linkName).append(',').append(this.getAscending()).append(')').append('{');
        this.child.getHandle(sb);
        return sb.append('}');
    }

    @Override
    public String getSimpleName() {
        return "slp";
    }
}

