/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Sort;
import jetbrains.exodus.query.SortEngine;
import jetbrains.exodus.query.Utils;
import org.jetbrains.annotations.NotNull;

public class SortByProperty
extends Sort {
    private final String propertyName;

    public SortByProperty(NodeBase child, String propertyName, boolean ascending) {
        super(child, ascending);
        this.propertyName = propertyName;
    }

    @Override
    public NodeBase getClone() {
        return new SortByProperty(this.getChild().getClone(), this.propertyName, this.getAscending());
    }

    @Override
    public boolean equalAsSort(Object o) {
        if (!(o instanceof SortByProperty)) {
            return false;
        }
        SortByProperty sort2 = (SortByProperty)o;
        return this.getAscending() == sort2.getAscending() && Utils.safe_equals(this.propertyName, sort2.propertyName);
    }

    @Override
    public Iterable<Entity> applySort(String entityType, Iterable<Entity> iterable, @NotNull SortEngine sortEngine) {
        return sortEngine.sort(entityType, this.propertyName, iterable, this.getAscending());
    }

    @Override
    public StringBuilder getHandle(StringBuilder sb) {
        super.getHandle(sb).append('(').append(this.propertyName).append(',').append(this.getAscending()).append(')').append('{');
        this.child.getHandle(sb);
        return sb.append('}');
    }

    @Override
    public String getSimpleName() {
        return "sp";
    }
}

