/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

public class ObjectCache<K, V>
extends ObjectCacheBase<K, V> {
    public static final float DEFAULT_SECOND_GENERATION_QUEUE_SIZE_RATIO = 0.4f;
    private final Lock lock = new ReentrantLock();
    private final float secondGenSizeRatio;
    private LinkedHashMap<K, V> firstGenerationQueue;
    private LinkedHashMap<K, V> secondGenerationQueue;
    private DeletedPairsListener<K, V>[] listeners;
    private V pushedOutValue;

    public ObjectCache() {
        this(8192);
    }

    public ObjectCache(int cacheSize) {
        this(cacheSize, 0.4f);
    }

    public ObjectCache(int cacheSize, float secondGenSizeRatio) {
        super(cacheSize);
        if (secondGenSizeRatio < 0.05f) {
            secondGenSizeRatio = 0.05f;
        } else if (secondGenSizeRatio > 0.95f) {
            secondGenSizeRatio = 0.95f;
        }
        this.secondGenSizeRatio = secondGenSizeRatio;
        this.clear();
        this.addDeletedPairsListener((key, value) -> {
            this.pushedOutValue = value;
        });
    }

    @Override
    public void clear() {
        if (this.firstGenerationQueue != null && this.secondGenerationQueue != null && this.isEmpty()) {
            return;
        }
        this.firstGenerationQueue = new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                boolean result;
                boolean bl = result = this.size() + ObjectCache.this.secondGenerationQueue.size() > ObjectCache.this.size;
                if (result) {
                    ObjectCache.this.fireListenersAboutDeletion(eldest.getKey(), eldest.getValue());
                }
                return result;
            }
        };
        final int secondGenSizeBound = (int)((float)this.size * this.secondGenSizeRatio);
        this.secondGenerationQueue = new LinkedHashMap<K, V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                boolean result;
                boolean bl = result = this.size() > secondGenSizeBound;
                if (result) {
                    --this.size;
                    ObjectCache.this.firstGenerationQueue.put(eldest.getKey(), eldest.getValue());
                    ++this.size;
                }
                return result;
            }
        };
    }

    @Override
    public void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    @Override
    public void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    @Override
    public V remove(@NotNull K key) {
        V x = this.firstGenerationQueue.remove(key);
        if (x != null) {
            this.fireListenersAboutDeletion(key, x);
        } else {
            x = this.secondGenerationQueue.remove(key);
            if (x != null) {
                this.fireListenersAboutDeletion(key, x);
            }
        }
        return x;
    }

    public void removeAll() {
        for (Map.Entry entry : this.firstGenerationQueue.entrySet()) {
            this.fireListenersAboutDeletion(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.secondGenerationQueue.entrySet()) {
            this.fireListenersAboutDeletion(entry.getKey(), entry.getValue());
        }
        this.clear();
    }

    @Override
    public V cacheObject(@NotNull K key, @NotNull V x) {
        this.pushedOutValue = null;
        if (this.firstGenerationQueue.put(key, x) == null) {
            this.secondGenerationQueue.remove(key);
        }
        return this.pushedOutValue;
    }

    @Override
    public V tryKey(@NotNull K key) {
        this.incAttempts();
        Object result = this.secondGenerationQueue.get(key);
        if (result == null && (result = this.firstGenerationQueue.remove(key)) != null) {
            this.secondGenerationQueue.put(key, result);
        }
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    @Override
    public V getObject(@NotNull K key) {
        Object result = this.firstGenerationQueue.get(key);
        if (result == null) {
            result = this.secondGenerationQueue.get(key);
        }
        return result;
    }

    @Override
    public int count() {
        return this.firstGenerationQueue.size() + this.secondGenerationQueue.size();
    }

    public Iterator<K> keys() {
        return new ObjectCacheKeysIterator(this);
    }

    public Iterator<V> values() {
        return new ObjectCacheValuesIterator(this);
    }

    public void addDeletedPairsListener(DeletedPairsListener<K, V> listener) {
        if (this.listeners == null) {
            this.listeners = new DeletedPairsListener[1];
        } else {
            DeletedPairsListener[] newListeners = new DeletedPairsListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
            this.listeners = newListeners;
        }
        this.listeners[this.listeners.length - 1] = listener;
    }

    public void removeDeletedPairsListener(DeletedPairsListener<K, V> listener) {
        if (this.listeners != null) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                DeletedPairsListener[] newListeners = new DeletedPairsListener[this.listeners.length - 1];
                int i = 0;
                for (DeletedPairsListener<K, V> myListener : this.listeners) {
                    if (myListener == listener) continue;
                    newListeners[i++] = myListener;
                }
                this.listeners = newListeners;
            }
        }
    }

    private void fireListenersAboutDeletion(K key, V x) {
        if (this.listeners != null) {
            for (DeletedPairsListener<K, V> myListener : this.listeners) {
                myListener.objectRemoved(key, x);
            }
        }
    }

    public static interface DeletedPairsListener<K, V>
    extends EventListener {
        public void objectRemoved(K var1, V var2);
    }

    protected static class ObjectCacheValuesIterator<K, V>
    implements Iterator<V> {
        private final Iterator<V> firstGenIterator;
        private final Iterator<V> secondGenIterator;

        protected ObjectCacheValuesIterator(ObjectCache<K, V> cache) {
            this.firstGenIterator = ((ObjectCache)cache).firstGenerationQueue.values().iterator();
            this.secondGenIterator = ((ObjectCache)cache).secondGenerationQueue.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.firstGenIterator.hasNext() || this.secondGenIterator.hasNext();
        }

        @Override
        public V next() {
            return this.firstGenIterator.hasNext() ? this.firstGenIterator.next() : this.secondGenIterator.next();
        }

        @Override
        public void remove() {
            if (this.firstGenIterator.hasNext()) {
                this.firstGenIterator.remove();
            } else {
                this.secondGenIterator.remove();
            }
        }
    }

    protected static class ObjectCacheKeysIterator<K, V>
    implements Iterator<K> {
        private final Iterator<K> firstGenIterator;
        private final Iterator<K> secondGenIterator;

        protected ObjectCacheKeysIterator(ObjectCache<K, V> cache) {
            this.firstGenIterator = ((ObjectCache)cache).firstGenerationQueue.keySet().iterator();
            this.secondGenIterator = ((ObjectCache)cache).secondGenerationQueue.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.firstGenIterator.hasNext() || this.secondGenIterator.hasNext();
        }

        @Override
        public K next() {
            return this.firstGenIterator.hasNext() ? this.firstGenIterator.next() : this.secondGenIterator.next();
        }

        @Override
        public void remove() {
            if (this.firstGenIterator.hasNext()) {
                this.firstGenIterator.remove();
            } else {
                this.secondGenIterator.remove();
            }
        }
    }
}

