/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.Set;
import jetbrains.exodus.core.dataStructures.decorators.QueueDecorator;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/core/execution/SharedTimer;", "Lmu/KLogging;", "()V", "PERIOD", "", "processor", "Ljetbrains/exodus/core/execution/JobProcessor;", "registeredTasks", "", "Ljetbrains/exodus/core/execution/SharedTimer$ExpirablePeriodicTask;", "ensureIdle", "", "registerPeriodicTask", "task", "registerPeriodicTaskIn", "millis", "", "unregisterPeriodicTask", "ExpirablePeriodicTask", "Ticker", "xodus-utils"})
public final class SharedTimer
extends KLogging {
    private static final int PERIOD = 1000;
    private static final Set<ExpirablePeriodicTask> registeredTasks;
    private static final JobProcessor processor;
    public static final SharedTimer INSTANCE;

    @JvmStatic
    public static final void registerPeriodicTask(@NotNull ExpirablePeriodicTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        processor.queue(new Job(task){
            final /* synthetic */ ExpirablePeriodicTask $task;

            protected void execute() {
                SharedTimer.access$getRegisteredTasks$p(SharedTimer.INSTANCE).add(this.$task);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void registerPeriodicTaskIn(@NotNull ExpirablePeriodicTask task, long millis) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        processor.queueIn(new Job(task){
            final /* synthetic */ ExpirablePeriodicTask $task;

            protected void execute() {
                SharedTimer.access$getRegisteredTasks$p(SharedTimer.INSTANCE).add(this.$task);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        }, millis);
    }

    @JvmStatic
    public static final void unregisterPeriodicTask(@NotNull ExpirablePeriodicTask task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        processor.queue(new Job(task){
            final /* synthetic */ ExpirablePeriodicTask $task;

            protected void execute() {
                SharedTimer.access$getRegisteredTasks$p(SharedTimer.INSTANCE).remove(this.$task);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    public static final void ensureIdle() {
        processor.waitForJobs(1L);
    }

    private SharedTimer() {
    }

    static {
        SharedTimer sharedTimer;
        INSTANCE = sharedTimer = new SharedTimer();
        PERIOD = 1000;
        registeredTasks = new HashSet();
        ThreadJobProcessor threadJobProcessor = ThreadJobProcessorPool.getOrCreateJobProcessor("Exodus shared timer thread");
        Intrinsics.checkExpressionValueIsNotNull((Object)threadJobProcessor, (String)"ThreadJobProcessorPool.g\u2026dus shared timer thread\")");
        processor = threadJobProcessor;
        processor.queueIn(new Ticker(), PERIOD);
    }

    public static final /* synthetic */ int access$getPERIOD$p(SharedTimer $this) {
        SharedTimer sharedTimer = $this;
        return PERIOD;
    }

    public static final /* synthetic */ Set access$getRegisteredTasks$p(SharedTimer $this) {
        SharedTimer sharedTimer = $this;
        return registeredTasks;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/exodus/core/execution/SharedTimer$ExpirablePeriodicTask;", "Ljava/lang/Runnable;", "isExpired", "", "()Z", "xodus-utils"})
    public static interface ExpirablePeriodicTask
    extends Runnable {
        public boolean isExpired();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014\u00a8\u0006\u0005"}, d2={"Ljetbrains/exodus/core/execution/SharedTimer$Ticker;", "Ljetbrains/exodus/core/execution/Job;", "()V", "execute", "", "xodus-utils"})
    private static final class Ticker
    extends Job {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() {
            long nextTick = System.currentTimeMillis() + (long)SharedTimer.access$getPERIOD$p(INSTANCE);
            try {
                QueueDecorator<ExpirablePeriodicTask> expiredTasks = new QueueDecorator<ExpirablePeriodicTask>();
                Iterable $this$forEach$iv = SharedTimer.access$getRegisteredTasks$p(INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ExpirablePeriodicTask task = (ExpirablePeriodicTask)element$iv;
                    boolean bl = false;
                    if (task.isExpired()) {
                        expiredTasks.add(task);
                        continue;
                    }
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        INSTANCE.getLogger().error("Periodic task failure", t);
                    }
                }
                for (ExpirablePeriodicTask expiredTask : expiredTasks) {
                    SharedTimer.access$getRegisteredTasks$p(INSTANCE).remove(expiredTask);
                }
            }
            finally {
                this.getProcessor().queueAt(this, nextTick);
            }
        }
    }
}

