/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import jetbrains.exodus.system.JVMConstants;
import jetbrains.exodus.util.SafeByteBufferCleaner;
import jetbrains.exodus.util.UnsafeHolder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/util/SafeByteBufferCleaner;", "", "()V", "cleanMethod", "Ljava/lang/reflect/Method;", "dbbCleanerMethod", "dbbFreeMethod", "directByteBufferClass", "Ljava/lang/Class;", "invokeCleanerMethod", "clean", "", "buffer", "Ljava/nio/ByteBuffer;", "getDirectByteBufferCleanerMethod", "getDirectByteBufferFreeMethod", "getDirectByteBufferMethod", "name", "", "xodus-utils"})
public final class SafeByteBufferCleaner {
    private static final Method invokeCleanerMethod;
    private static final Class<?> directByteBufferClass;
    private static final Method dbbFreeMethod;
    private static final Method dbbCleanerMethod;
    private static final Method cleanMethod;
    public static final SafeByteBufferCleaner INSTANCE;

    public final void clean(@NotNull ByteBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        try {
            UnsafeHolder.INSTANCE.doPrivileged$xodus_utils((Function0)new Function0<Unit>(buffer){
                final /* synthetic */ ByteBuffer $buffer;

                public final void invoke() {
                    block6: {
                        block7: {
                            block5: {
                                if (JVMConstants.INSTANCE.getIS_JAVA9_OR_HIGHER() && SafeByteBufferCleaner.access$getInvokeCleanerMethod$p(SafeByteBufferCleaner.INSTANCE) != null) {
                                    try {
                                        SafeByteBufferCleaner.access$getInvokeCleanerMethod$p(SafeByteBufferCleaner.INSTANCE).invoke(UnsafeHolder.INSTANCE.getTheUnsafe(), this.$buffer);
                                        return;
                                    }
                                    catch (Throwable t) {
                                        throw (Throwable)new RuntimeException(t);
                                    }
                                }
                                if (!Intrinsics.areEqual((Object)this.$buffer.getClass().getSimpleName(), (Object)"MappedByteBufferAdapter")) break block5;
                                if (!JVMConstants.INSTANCE.getIS_ANDROID()) {
                                    throw (Throwable)new RuntimeException("MappedByteBufferAdapter only supported for Android");
                                }
                                Method method = SafeByteBufferCleaner.access$getDbbFreeMethod$p(SafeByteBufferCleaner.INSTANCE);
                                if (method == null) break block6;
                                method.invoke((Object)this.$buffer, new Object[0]);
                                break block6;
                            }
                            if (SafeByteBufferCleaner.access$getDbbCleanerMethod$p(SafeByteBufferCleaner.INSTANCE) == null || SafeByteBufferCleaner.access$getCleanMethod$p(SafeByteBufferCleaner.INSTANCE) == null) break block7;
                            Object cleaner = SafeByteBufferCleaner.access$getDbbCleanerMethod$p(SafeByteBufferCleaner.INSTANCE).invoke((Object)this.$buffer, new Object[0]);
                            SafeByteBufferCleaner.access$getCleanMethod$p(SafeByteBufferCleaner.INSTANCE).invoke(cleaner, new Object[0]);
                            break block6;
                        }
                        if (!JVMConstants.INSTANCE.getIS_ANDROID()) break block6;
                        Method method = SafeByteBufferCleaner.access$getDbbFreeMethod$p(SafeByteBufferCleaner.INSTANCE);
                        if (method != null) {
                            method.invoke((Object)this.$buffer, new Object[0]);
                        }
                    }
                }
                {
                    this.$buffer = byteBuffer;
                    super(0);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private final Method getDirectByteBufferFreeMethod() {
        return this.getDirectByteBufferMethod("cleaner");
    }

    private final Method getDirectByteBufferCleanerMethod() {
        return this.getDirectByteBufferMethod("cleaner");
    }

    private final Method getDirectByteBufferMethod(String name) {
        Method method;
        try {
            method = directByteBufferClass.getMethod(name, new Class[0]);
            boolean bl = false;
            boolean bl2 = false;
            Method $this$apply = method;
            boolean bl3 = false;
            $this$apply.setAccessible(true);
        }
        catch (Throwable t) {
            method = null;
        }
        return method;
    }

    private SafeByteBufferCleaner() {
    }

    static {
        SafeByteBufferCleaner safeByteBufferCleaner;
        INSTANCE = safeByteBufferCleaner = new SafeByteBufferCleaner();
        invokeCleanerMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged$xodus_utils(invokeCleanerMethod.1.INSTANCE);
        Object t = UnsafeHolder.INSTANCE.doPrivileged$xodus_utils(directByteBufferClass.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"doPrivileged { Class.for\u2026.nio.DirectByteBuffer\") }");
        directByteBufferClass = (Class)t;
        dbbFreeMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged$xodus_utils(dbbFreeMethod.1.INSTANCE);
        dbbCleanerMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged$xodus_utils(dbbCleanerMethod.1.INSTANCE);
        cleanMethod = (Method)UnsafeHolder.INSTANCE.doPrivileged$xodus_utils(cleanMethod.1.INSTANCE);
    }

    public static final /* synthetic */ Method access$getInvokeCleanerMethod$p(SafeByteBufferCleaner $this) {
        SafeByteBufferCleaner safeByteBufferCleaner = $this;
        return invokeCleanerMethod;
    }

    public static final /* synthetic */ Method access$getDbbFreeMethod$p(SafeByteBufferCleaner $this) {
        SafeByteBufferCleaner safeByteBufferCleaner = $this;
        return dbbFreeMethod;
    }

    public static final /* synthetic */ Method access$getDbbCleanerMethod$p(SafeByteBufferCleaner $this) {
        SafeByteBufferCleaner safeByteBufferCleaner = $this;
        return dbbCleanerMethod;
    }

    public static final /* synthetic */ Method access$getCleanMethod$p(SafeByteBufferCleaner $this) {
        SafeByteBufferCleaner safeByteBufferCleaner = $this;
        return cleanMethod;
    }

    public static final /* synthetic */ Method access$getDirectByteBufferFreeMethod(SafeByteBufferCleaner $this) {
        return $this.getDirectByteBufferFreeMethod();
    }

    public static final /* synthetic */ Method access$getDirectByteBufferCleanerMethod(SafeByteBufferCleaner $this) {
        return $this.getDirectByteBufferCleanerMethod();
    }
}

