/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.vfs;

import java.io.Closeable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.vfs.Cluster;
import jetbrains.exodus.vfs.ClusterConverter;
import jetbrains.exodus.vfs.ClusterKey;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.File;
import jetbrains.exodus.vfs.IOCancellingPolicy;
import jetbrains.exodus.vfs.IOCancellingPolicyProvider;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.exodus.vfs.VirtualFileSystem;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0016J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020\u001aJ\u0006\u0010%\u001a\u00020\u001aJ\u0006\u0010&\u001a\u00020 J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010+\u001a\u00020\nR\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/exodus/vfs/ClusterIterator;", "Ljava/io/Closeable;", "vfs", "Ljetbrains/exodus/vfs/VirtualFileSystem;", "txn", "Ljetbrains/exodus/env/Transaction;", "file", "Ljetbrains/exodus/vfs/File;", "(Ljetbrains/exodus/vfs/VirtualFileSystem;Ljetbrains/exodus/env/Transaction;Ljetbrains/exodus/vfs/File;)V", "fd", "", "position", "(Ljetbrains/exodus/vfs/VirtualFileSystem;Ljetbrains/exodus/env/Transaction;JJ)V", "cancellingPolicy", "Ljetbrains/exodus/vfs/IOCancellingPolicy;", "getCancellingPolicy", "()Ljetbrains/exodus/vfs/IOCancellingPolicy;", "cancellingPolicy$delegate", "Lkotlin/Lazy;", "<set-?>", "Ljetbrains/exodus/vfs/Cluster;", "current", "getCurrent", "()Ljetbrains/exodus/vfs/Cluster;", "cursor", "Ljetbrains/exodus/env/Cursor;", "", "isClosed", "()Z", "getTxn", "()Ljetbrains/exodus/env/Transaction;", "adjustCurrentCluster", "", "cancelIfNeeded", "close", "deleteCurrent", "hasCluster", "isObsolete", "moveToNext", "readCluster", "it", "Ljetbrains/exodus/ByteIterable;", "seek", "size", "xodus-vfs"})
public final class ClusterIterator
implements Closeable {
    private final Cursor cursor;
    private final Lazy cancellingPolicy$delegate;
    @Nullable
    private Cluster current;
    private boolean isClosed;
    private final VirtualFileSystem vfs;
    @NotNull
    private final Transaction txn;
    private final long fd;

    private final IOCancellingPolicy getCancellingPolicy() {
        Lazy lazy = this.cancellingPolicy$delegate;
        ClusterIterator clusterIterator = this;
        Object var3_3 = null;
        boolean bl = false;
        return (IOCancellingPolicy)lazy.getValue();
    }

    @Nullable
    public final Cluster getCurrent() {
        return this.current;
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final void seek(long position) {
        block6: {
            ByteIterable it;
            ClusteringStrategy cs;
            long pos;
            block4: {
                int firstClusterSize;
                block5: {
                    pos = position;
                    VfsConfig vfsConfig = this.vfs.getConfig();
                    Intrinsics.checkExpressionValueIsNotNull((Object)vfsConfig, (String)"vfs.config");
                    ClusteringStrategy clusteringStrategy = vfsConfig.getClusteringStrategy();
                    Intrinsics.checkExpressionValueIsNotNull((Object)clusteringStrategy, (String)"vfs.config.clusteringStrategy");
                    cs = clusteringStrategy;
                    it = null;
                    if (!cs.isLinear()) break block4;
                    firstClusterSize = cs.getFirstClusterSize();
                    it = this.cursor.getSearchKeyRange((ByteIterable)ClusterKey.Companion.toByteIterable(this.fd, pos / (long)firstClusterSize));
                    if (it != null) break block5;
                    this.current = null;
                    break block6;
                }
                this.current = this.readCluster(it);
                this.adjustCurrentCluster();
                Cluster currentCluster = this.current;
                if (currentCluster == null) break block6;
                currentCluster.setStartingPosition(currentCluster.getClusterNumber() * (long)firstClusterSize);
                break block6;
            }
            it = this.cursor.getSearchKeyRange((ByteIterable)ClusterKey.Companion.toByteIterable(this.fd, 0L));
            if (it == null) {
                this.current = null;
            } else {
                int maxClusterSize = cs.getMaxClusterSize();
                long clusterSize = 0L;
                this.current = this.readCluster(it);
                long startingPosition = 0L;
                this.adjustCurrentCluster();
                while (this.current != null) {
                    Cluster notNullCluster = (Cluster)KodusKt.getNotNull((Object)this.current);
                    if (clusterSize < (long)maxClusterSize) {
                        clusterSize = notNullCluster.getSize();
                    }
                    notNullCluster.setStartingPosition(startingPosition);
                    if (pos < clusterSize) break;
                    pos -= clusterSize;
                    startingPosition += clusterSize;
                    this.moveToNext();
                }
            }
        }
    }

    public final long size() {
        long result = 0L;
        VfsConfig vfsConfig = this.vfs.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)vfsConfig, (String)"vfs.config");
        ClusteringStrategy clusteringStrategy = vfsConfig.getClusteringStrategy();
        Intrinsics.checkExpressionValueIsNotNull((Object)clusteringStrategy, (String)"vfs.config.clusteringStrategy");
        ClusteringStrategy cs = clusteringStrategy;
        if (cs.isLinear()) {
            long clusterSize = cs.getFirstClusterSize();
            if (this.cursor.getSearchKeyRange((ByteIterable)ClusterKey.Companion.toByteIterable(this.fd + 1L, 0L)) != null && this.cursor.getPrev() || this.cursor.getPrev()) {
                ByteIterable byteIterable = this.cursor.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable, (String)"cursor.key");
                ClusterKey clusterKey = new ClusterKey(byteIterable);
                if (clusterKey.getDescriptor() == this.fd) {
                    long l = clusterKey.getClusterNumber() * clusterSize;
                    ByteIterable byteIterable2 = this.cursor.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable2, (String)"cursor.value");
                    return l + (long)this.readCluster(byteIterable2).getSize();
                }
            }
            this.seek(0L);
            Cluster previous = null;
            while (this.hasCluster()) {
                if (previous != null) {
                    result += clusterSize;
                }
                previous = this.current;
                this.moveToNext();
            }
            if (previous != null) {
                result += (long)previous.getSize();
            }
        } else {
            this.seek(0L);
            while (this.hasCluster()) {
                result += (long)((Cluster)KodusKt.getNotNull((Object)this.current)).getSize();
                this.moveToNext();
            }
        }
        return result;
    }

    public final boolean hasCluster() {
        return this.current != null;
    }

    public final void moveToNext() {
        this.cancelIfNeeded();
        if (this.current != null) {
            if (!this.cursor.getNext()) {
                this.current = null;
            } else {
                ByteIterable byteIterable = this.cursor.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable, (String)"cursor.value");
                this.current = this.readCluster(byteIterable);
                this.adjustCurrentCluster();
            }
        }
    }

    public final void deleteCurrent() {
        if (this.current != null) {
            this.cursor.deleteCurrent();
        }
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.cursor.close();
            this.isClosed = true;
        }
    }

    public final boolean isObsolete() {
        return this.txn.isFinished();
    }

    private final Cluster readCluster(ByteIterable it) {
        ClusterConverter clusterConverter = this.vfs.getClusterConverter();
        ClusterConverter clusterConverter2 = clusterConverter;
        if (clusterConverter2 == null || (clusterConverter2 = clusterConverter2.onRead(it)) == null) {
            clusterConverter2 = it;
        }
        return new Cluster((ByteIterable)clusterConverter2);
    }

    private final void adjustCurrentCluster() {
        ByteIterable byteIterable = this.cursor.getKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteIterable, (String)"cursor.key");
        ClusterKey clusterKey = new ClusterKey(byteIterable);
        if (clusterKey.getDescriptor() != this.fd) {
            this.current = null;
        } else {
            ((Cluster)KodusKt.getNotNull((Object)this.current)).setClusterNumber(clusterKey.getClusterNumber());
        }
    }

    private final void cancelIfNeeded() {
        block1: {
            IOCancellingPolicy iOCancellingPolicy = this.getCancellingPolicy();
            if (iOCancellingPolicy == null) break block1;
            IOCancellingPolicy iOCancellingPolicy2 = iOCancellingPolicy;
            boolean bl = false;
            boolean bl2 = false;
            IOCancellingPolicy $this$run = iOCancellingPolicy2;
            boolean bl3 = false;
            if ($this$run.needToCancel()) {
                $this$run.doCancel();
            }
        }
    }

    @NotNull
    public final Transaction getTxn() {
        return this.txn;
    }

    @JvmOverloads
    public ClusterIterator(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fd, long position) {
        Intrinsics.checkParameterIsNotNull((Object)vfs, (String)"vfs");
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        this.vfs = vfs;
        this.txn = txn;
        this.fd = fd;
        Cursor cursor = this.vfs.getContents().openCursor(this.txn);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"vfs.contents.openCursor(txn)");
        this.cursor = cursor;
        this.cancellingPolicy$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IOCancellingPolicy>(this){
            final /* synthetic */ ClusterIterator this$0;

            @Nullable
            public final IOCancellingPolicy invoke() {
                IOCancellingPolicy iOCancellingPolicy;
                IOCancellingPolicyProvider iOCancellingPolicyProvider = ClusterIterator.access$getVfs$p(this.this$0).getCancellingPolicyProvider();
                if (iOCancellingPolicyProvider != null) {
                    IOCancellingPolicyProvider iOCancellingPolicyProvider2 = iOCancellingPolicyProvider;
                    boolean bl = false;
                    boolean bl2 = false;
                    IOCancellingPolicyProvider $this$run = iOCancellingPolicyProvider2;
                    boolean bl3 = false;
                    iOCancellingPolicy = (IOCancellingPolicy)this.this$0.getTxn().getUserObject((Object)"CP_KEY");
                    if (iOCancellingPolicy == null) {
                        IOCancellingPolicy iOCancellingPolicy2 = $this$run.getPolicy();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        IOCancellingPolicy $this$apply = iOCancellingPolicy2;
                        boolean bl6 = false;
                        this.this$0.getTxn().setUserObject((Object)"CP_KEY", (Object)$this$apply);
                        IOCancellingPolicy iOCancellingPolicy3 = iOCancellingPolicy2;
                        iOCancellingPolicy = iOCancellingPolicy3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iOCancellingPolicy3, (String)"policy.apply {\n         \u2026_KEY, this)\n            }");
                    }
                } else {
                    iOCancellingPolicy = null;
                }
                return iOCancellingPolicy;
            }
            {
                this.this$0 = clusterIterator;
                super(0);
            }
        }));
        Transaction transaction = this.txn;
        if (transaction == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.env.TransactionBase");
        }
        ((TransactionBase)transaction).checkIsFinished();
        if (position >= 0L) {
            this.seek(position);
        }
        this.isClosed = false;
    }

    public /* synthetic */ ClusterIterator(VirtualFileSystem virtualFileSystem, Transaction transaction, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        this(virtualFileSystem, transaction, l, l2);
    }

    @JvmOverloads
    public ClusterIterator(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, long fd) {
        this(vfs, txn, fd, 0L, 8, null);
    }

    public ClusterIterator(@NotNull VirtualFileSystem vfs, @NotNull Transaction txn, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)vfs, (String)"vfs");
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this(vfs, txn, file.getDescriptor(), 0L, 8, null);
    }

    public static final /* synthetic */ VirtualFileSystem access$getVfs$p(ClusterIterator $this) {
        return $this.vfs;
    }
}

