/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.api.misc;

import java.net.UnknownHostException;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.misc.UpdateCheckResult;
import jetbrains.youtrack.core.dates.DateFormats;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0011\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/api/misc/UpdateCheckResult;", "", "success", "", "updateAvailable", "message", "", "(ZZLjava/lang/String;)V", "date", "", "getDate", "()Ljava/lang/Long;", "setDate", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "downloadUrl", "getDownloadUrl", "()Ljava/lang/String;", "setDownloadUrl", "(Ljava/lang/String;)V", "getMessage", "getSuccess", "()Z", "getUpdateAvailable", "Companion", "LocalizedUpdateCheckResult", "youtrack-api"})
public class UpdateCheckResult {
    @Nullable
    private Long date;
    @Nullable
    private String downloadUrl;
    private final boolean success;
    private final boolean updateAvailable;
    @Nullable
    private final String message;
    private static final LocalizedUpdateCheckResult NOTHING_FOUND_TO_UPDATE;
    private static final LocalizedUpdateCheckResult UPDATE_INFO_UNAVAILABLE;
    private static final LocalizedUpdateCheckResult FAIL;
    public static final Companion Companion;

    @Nullable
    public final Long getDate() {
        return this.date;
    }

    public final void setDate(@Nullable Long l) {
        this.date = l;
    }

    @Nullable
    public final String getDownloadUrl() {
        return this.downloadUrl;
    }

    public final void setDownloadUrl(@Nullable String string) {
        this.downloadUrl = string;
    }

    public final boolean getSuccess() {
        return this.success;
    }

    public final boolean getUpdateAvailable() {
        return this.updateAvailable;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public UpdateCheckResult(boolean success, boolean updateAvailable, @Nullable String message) {
        this.success = success;
        this.updateAvailable = updateAvailable;
        this.message = message;
    }

    static {
        Companion = new Companion(null);
        NOTHING_FOUND_TO_UPDATE = new LocalizedUpdateCheckResult(true, false, "UpdateCheckResult.Nothing_found_to_update");
        UPDATE_INFO_UNAVAILABLE = new LocalizedUpdateCheckResult(true, false, "UpdateCheckResult.Update_info_is_not_available");
        FAIL = new LocalizedUpdateCheckResult(false, false, "UpdateCheckResult.Update_info_is_not_available");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/api/misc/UpdateCheckResult$LocalizedUpdateCheckResult;", "Ljetbrains/youtrack/api/misc/UpdateCheckResult;", "success", "", "updateAvailable", "localizationId", "", "(ZZLjava/lang/String;)V", "<set-?>", "getLocalizationId", "()Ljava/lang/String;", "message", "getMessage", "youtrack-api"})
    private static final class LocalizedUpdateCheckResult
    extends UpdateCheckResult {
        @Nullable
        private String localizationId;

        @Nullable
        public final String getLocalizationId() {
            return this.localizationId;
        }

        @Override
        @Nullable
        public String getMessage() {
            return BeansKt.getLocalizer().localizedMsg(this.localizationId, new Object[0]);
        }

        public LocalizedUpdateCheckResult(boolean success, boolean updateAvailable, @Nullable String localizationId) {
            super(success, updateAvailable, null);
            this.localizationId = localizationId;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\nJ\u0012\u0010\r\u001a\u00020\b2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u0006\u0010\u0011\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/youtrack/api/misc/UpdateCheckResult$Companion;", "Lmu/KLogging;", "()V", "FAIL", "Ljetbrains/youtrack/api/misc/UpdateCheckResult$LocalizedUpdateCheckResult;", "NOTHING_FOUND_TO_UPDATE", "UPDATE_INFO_UNAVAILABLE", "available", "Ljetbrains/youtrack/api/misc/UpdateCheckResult;", "message", "", "date", "downloadUrl", "fail", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "notAvailable", "nothingFoundToUpdate", "youtrack-api"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final UpdateCheckResult nothingFoundToUpdate() {
            return NOTHING_FOUND_TO_UPDATE;
        }

        @NotNull
        public final UpdateCheckResult notAvailable() {
            return UPDATE_INFO_UNAVAILABLE;
        }

        @NotNull
        public final UpdateCheckResult available(@Nullable String message, @Nullable String date, @Nullable String downloadUrl) {
            UpdateCheckResult result = new UpdateCheckResult(true, true, message);
            if (date != null) {
                CharSequence charSequence = date;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    try {
                        result.setDate(DateTimeOperations.convert((DateTime)DateTimeOperations.parseDateTime((String)date, (DateTimeFormatter)DateFormats.INSTANCE.getFormatter("releaseDateFormat"), (DateTimeZone)DateTimeZone.UTC, null, null)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            result.setDownloadUrl(downloadUrl);
            return result;
        }

        @NotNull
        public final UpdateCheckResult fail(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (e instanceof UnknownHostException) {
                this.getLogger().error((Function0)fail.1.INSTANCE);
            } else {
                this.getLogger().error((Throwable)e, (Function0)new Function0<String>(e){
                    final /* synthetic */ Exception $e;

                    @Nullable
                    public final String invoke() {
                        return this.$e.getMessage();
                    }
                    {
                        this.$e = exception;
                        super(0);
                    }
                });
            }
            return FAIL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

