/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.api.user;

import java.util.Collection;
import java.util.List;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.user.UserGroupMergeHandler;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rR$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Ljetbrains/youtrack/api/user/UserGroupMergeHandlers;", "", "()V", "handlers", "", "Ljetbrains/youtrack/api/user/UserGroupMergeHandler;", "getHandlers", "()Ljava/util/List;", "setHandlers", "(Ljava/util/List;)V", "deleteWithSuccessor", "", "toDelete", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "successor", "hasUsages", "", "group", "merge", "from", "into", "Companion", "youtrack-api"})
public final class UserGroupMergeHandlers {
    @Autowired
    @NotNull
    public List<? extends UserGroupMergeHandler> handlers;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<UserGroupMergeHandler> getHandlers() {
        List<UserGroupMergeHandler> list = this.handlers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        return list;
    }

    public final void setHandlers(@NotNull List<? extends UserGroupMergeHandler> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.handlers = list;
    }

    public final void merge(@NotNull XdUserGroup from, @NotNull XdUserGroup into) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)into, (String)"into");
        if (Intrinsics.areEqual((Object)from, (Object)into)) {
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("Can't merge group " + into.getName() + " into itself", null, 2, null));
        }
        if (from.getAllUsersGroup()) {
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("All Users group can't be merged into the other group", null, 2, null));
        }
        List<? extends UserGroupMergeHandler> list = this.handlers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserGroupMergeHandler it = (UserGroupMergeHandler)element$iv;
            boolean bl = false;
            it.groupMerged(from, into);
        }
        from.delete();
    }

    public final void deleteWithSuccessor(@NotNull XdUserGroup toDelete, @NotNull XdUserGroup successor) {
        Intrinsics.checkParameterIsNotNull((Object)toDelete, (String)"toDelete");
        Intrinsics.checkParameterIsNotNull((Object)successor, (String)"successor");
        if (Intrinsics.areEqual((Object)toDelete, (Object)successor)) {
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException("A user group can't be it's own successor", null, 2, null));
        }
        if (toDelete.getAllUsersGroup()) {
            String string = BeansKt.getLocalizer().localizedMsg("All Users group cannot be removed", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026group cannot be removed\")");
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(string, null, 2, null));
        }
        List<? extends UserGroupMergeHandler> list = this.handlers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserGroupMergeHandler it = (UserGroupMergeHandler)element$iv;
            boolean bl = false;
            it.groupDeleted(toDelete, successor);
        }
        toDelete.delete();
    }

    public final boolean hasUsages(@NotNull XdUserGroup group2) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group");
            List<? extends UserGroupMergeHandler> list = this.handlers;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
            }
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UserGroupMergeHandler it = (UserGroupMergeHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.hasUsages(group2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/api/user/UserGroupMergeHandlers$Companion;", "Lmu/KLogging;", "()V", "youtrack-api"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

