/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.api.user;

import java.util.List;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.UserConstraintValidationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.application.BeansKt;
import jetbrains.youtrack.api.application.RuleEngine;
import jetbrains.youtrack.api.user.UserMergeHandler;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u000b*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Ljetbrains/youtrack/api/user/UserMergeHandlers;", "", "()V", "handlers", "", "Ljetbrains/youtrack/api/user/UserMergeHandler;", "getHandlers", "()Ljava/util/List;", "setHandlers", "(Ljava/util/List;)V", "deleteWithSuccessor", "", "toDelete", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "successor", "merge", "from", "into", "throwConstraintsValidationException", "message", "", "ignoreThread", "Ljetbrains/youtrack/api/application/RuleEngine;", "closure", "Lkotlin/Function0;", "Companion", "youtrack-api"})
public final class UserMergeHandlers {
    @Autowired
    @NotNull
    public List<? extends UserMergeHandler> handlers;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<UserMergeHandler> getHandlers() {
        List<UserMergeHandler> list = this.handlers;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"handlers");
        }
        return list;
    }

    public final void setHandlers(@NotNull List<? extends UserMergeHandler> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.handlers = list;
    }

    public final void merge(@NotNull XdUser from, @NotNull XdUser into) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)into, (String)"into");
        if (Intrinsics.areEqual((Object)from, (Object)into)) {
            this.throwConstraintsValidationException(from, "Can't merge a user with itself");
        }
        if (from.isGuest()) {
            this.throwConstraintsValidationException(from, "Guest user can't be merged into other user");
        }
        this.ignoreThread(BeansKt.getRuleEngine(), (Function0<Unit>)((Function0)new Function0<Unit>(this, from, into){
            final /* synthetic */ UserMergeHandlers this$0;
            final /* synthetic */ XdUser $from;
            final /* synthetic */ XdUser $into;

            public final void invoke() {
                Iterable $this$forEach$iv = this.this$0.getHandlers();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UserMergeHandler handler = (UserMergeHandler)element$iv;
                    boolean bl = false;
                    handler.userMerged(this.$from, this.$into);
                    try {
                        LegacySupportKt.flush();
                    }
                    catch (Exception e) {
                        UserMergeHandlers.Companion.getLogger().warn("An error occurred during user merge", (Throwable)e);
                        LegacySupportKt.revert();
                    }
                }
            }
            {
                this.this$0 = userMergeHandlers;
                this.$from = xdUser;
                this.$into = xdUser2;
                super(0);
            }
        }));
        from.delete();
    }

    public final void deleteWithSuccessor(@NotNull XdUser toDelete, @NotNull XdUser successor) {
        Intrinsics.checkParameterIsNotNull((Object)toDelete, (String)"toDelete");
        Intrinsics.checkParameterIsNotNull((Object)successor, (String)"successor");
        if (Intrinsics.areEqual((Object)toDelete, (Object)successor)) {
            this.throwConstraintsValidationException(toDelete, "A user can't be its own successor");
        }
        if (toDelete.isGuest()) {
            this.throwConstraintsValidationException(toDelete, "Guest user can't be deleted");
        }
        this.ignoreThread(BeansKt.getRuleEngine(), (Function0<Unit>)((Function0)new Function0<Unit>(this, toDelete, successor){
            final /* synthetic */ UserMergeHandlers this$0;
            final /* synthetic */ XdUser $toDelete;
            final /* synthetic */ XdUser $successor;

            public final void invoke() {
                Iterable $this$forEach$iv = this.this$0.getHandlers();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UserMergeHandler handler = (UserMergeHandler)element$iv;
                    boolean bl = false;
                    handler.userDeleted(this.$toDelete, this.$successor);
                    try {
                        LegacySupportKt.flush();
                    }
                    catch (Exception e) {
                        UserMergeHandlers.Companion.getLogger().warn("An error occurred during user removal", (Throwable)e);
                        LegacySupportKt.revert();
                    }
                }
            }
            {
                this.this$0 = userMergeHandlers;
                this.$toDelete = xdUser;
                this.$successor = xdUser2;
                super(0);
            }
        }));
        toDelete.delete();
    }

    private final void throwConstraintsValidationException(XdUser from, String message) {
        Throwable throwable;
        if (from.isRemoved()) {
            throwable = (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message, null, 2, null));
        } else {
            Entity entity = from.getEntity();
            if (entity == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
            }
            throwable = (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new UserConstraintValidationException(message, (Entity)((TransientEntity)entity)));
        }
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ignoreThread(@NotNull RuleEngine $this$ignoreThread, Function0<Unit> closure) {
        boolean ignoredAlready = $this$ignoreThread.isIgnoreThread();
        if (!ignoredAlready) {
            $this$ignoreThread.addIgnoreThread();
        }
        try {
            closure.invoke();
        }
        finally {
            if (!ignoredAlready) {
                $this$ignoreThread.removeIgnoreThread();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/api/user/UserMergeHandlers$Companion;", "Lmu/KLogging;", "()V", "youtrack-api"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

