/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.bootstrap;

import jetbrains.charisma.bootstrap.YouTrackRepilcator;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.persistent.EventsMultiplexerJobProcessor;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.entitystore.MetaServer;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.replication.MetaServerImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.youtrack.api.application.DatabaseSettingsFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="databaseSettingsFactory")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016\u00a8\u0006\u0018"}, d2={"Ljetbrains/charisma/bootstrap/DatabaseSettingsFactoryImpl;", "Ljetbrains/youtrack/api/application/DatabaseSettingsFactory;", "()V", "adjustCipherSettings", "Ljetbrains/exodus/env/EnvironmentConfig;", "config", "adjustNioSetting", "ec", "adjustReplicationSetting", "createEnvironmentConfig", "createEventsMultiplexerJobProcessor", "Ljetbrains/exodus/core/execution/JobProcessor;", "key", "", "createPersistentEntityStore", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "createStoreConfig", "Ljetbrains/exodus/entitystore/PersistentEntityStoreConfig;", "createTextIndexEnvironmentConfig", "getPathParameter", "default", "resolveBackupLocation", "resolveDbLocation", "Companion", "youtrack-application"})
public final class DatabaseSettingsFactoryImpl
implements DatabaseSettingsFactory {
    @NotNull
    public static final String databaseKey = "teamsysstore";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String resolveDbLocation() {
        String string;
        if (ConfigurationUtil.isYoutrackHosted()) {
            String location = ConfigurationParameter.getParameter((String)"youtrack.hosted.database.location");
            string = location;
            if (string == null) {
                throw (Throwable)new IllegalStateException("youtrack.hosted.database.location should be specified for a hosted instance");
            }
        } else {
            string = this.getPathParameter("database.location", "/teamsysdata") + "/youtrack";
        }
        return string;
    }

    @Nullable
    public String resolveBackupLocation() {
        return ConfigurationUtil.isYoutrackHosted() ? ConfigurationParameter.getParameter((String)"youtrack.hosted.database.backup.location") : this.getPathParameter("database.backup.location", "/teamsysdata-backup");
    }

    private final String getPathParameter(String key2, String string) {
        String string2 = ConfigurationParameter.getParameter((String)key2);
        if (string2 == null) {
            string2 = System.getProperty("user.home") + string;
        }
        return string2;
    }

    @NotNull
    public EnvironmentConfig createTextIndexEnvironmentConfig() {
        EnvironmentConfig environmentConfig = new EnvironmentConfig().setGcMinUtilization(80).setTreeMaxPageSize(256).setLogClearInvalid(true).setLogFileSize((long)16384).setManagementOperationsRestricted(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"EnvironmentConfig().setG\u2026erationsRestricted(false)");
        return this.adjustCipherSettings(this.adjustNioSetting(environmentConfig));
    }

    @NotNull
    public PersistentEntityStoreImpl createPersistentEntityStore() {
        PersistentEntityStoreImpl persistentEntityStoreImpl;
        String dbLocation = this.resolveDbLocation();
        EnvironmentConfig envConfig = this.createEnvironmentConfig();
        PersistentEntityStoreConfig config = this.createStoreConfig();
        String replicationHost = ConfigurationParameter.getParameter((String)"jetbrains.youtrack.replication.host");
        if (replicationHost == null) {
            Environment env = Environments.newInstance((String)dbLocation, (EnvironmentConfig)envConfig);
            PersistentEntityStoreImpl persistentEntityStoreImpl2 = new PersistentEntityStoreImpl(config, env, null, databaseKey);
            boolean bl = false;
            boolean bl2 = false;
            PersistentEntityStoreImpl $this$apply = persistentEntityStoreImpl2;
            boolean bl3 = false;
            $this$apply.setCloseEnvironment(true);
            persistentEntityStoreImpl = persistentEntityStoreImpl2;
        } else {
            persistentEntityStoreImpl = new YouTrackRepilcator(replicationHost).doReplicate(envConfig, config);
        }
        return persistentEntityStoreImpl;
    }

    @NotNull
    public JobProcessor createEventsMultiplexerJobProcessor(@NotNull String key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return (JobProcessor)new EventsMultiplexerJobProcessor(key2);
    }

    private final EnvironmentConfig createEnvironmentConfig() {
        EnvironmentConfig config = new EnvironmentConfig(ConfigurationParameter.STRATEGY);
        config = this.adjustReplicationSetting(config);
        return this.adjustNioSetting(config);
    }

    private final EnvironmentConfig adjustNioSetting(EnvironmentConfig ec) {
        EnvironmentConfig environmentConfig;
        if (ConfigurationParameter.STRATEGY.getProperty("exodus.log.cache.useNIO") == null) {
            EnvironmentConfig environmentConfig2 = ec.setLogCacheUseNio(false);
            environmentConfig = environmentConfig2;
            Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig2, (String)"ec.setLogCacheUseNio(false)");
        } else {
            environmentConfig = ec;
        }
        return environmentConfig;
    }

    private final EnvironmentConfig adjustReplicationSetting(EnvironmentConfig config) {
        String replicationPort = ConfigurationParameter.getParameter((String)"jetbrains.youtrack.replication.server.port");
        if (replicationPort != null) {
            try {
                int port2 = Integer.parseInt(replicationPort);
                if (port2 > 0) {
                    MetaServerImpl server = new MetaServerImpl(port2);
                    EnvironmentConfig environmentConfig = config.setMetaServer((MetaServer)server);
                    Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"config.setMetaServer(server)");
                    return environmentConfig;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return config;
    }

    private final PersistentEntityStoreConfig createStoreConfig() {
        return new PersistentEntityStoreConfig(ConfigurationParameter.STRATEGY);
    }

    private final EnvironmentConfig adjustCipherSettings(EnvironmentConfig config) {
        String cipherKey;
        String cipherBasicIV;
        EnvironmentConfig ec = config;
        String cipherID = ConfigurationParameter.STRATEGY.getProperty("exodus.cipherId");
        if (cipherID != null) {
            EnvironmentConfig environmentConfig = ec.setCipherId(cipherID);
            Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"ec.setCipherId(cipherID)");
            ec = environmentConfig;
        }
        if ((cipherBasicIV = ConfigurationParameter.STRATEGY.getProperty("exodus.cipherBasicIV")) != null) {
            EnvironmentConfig environmentConfig = ec.setCipherBasicIV(Long.parseLong(cipherBasicIV));
            Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"ec.setCipherBasicIV(java\u2026parseLong(cipherBasicIV))");
            ec = environmentConfig;
        }
        if ((cipherKey = ConfigurationParameter.STRATEGY.getProperty("exodus.cipherKey")) != null) {
            EnvironmentConfig environmentConfig = ec.setCipherKey(cipherKey);
            Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"ec.setCipherKey(cipherKey)");
            ec = environmentConfig;
        }
        return ec;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/charisma/bootstrap/DatabaseSettingsFactoryImpl$Companion;", "", "()V", "databaseKey", "", "youtrack-application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

