/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import java.util.concurrent.ConcurrentHashMap;
import jetbrains.charisma.persistent.queries.YouTrackTransientQueryEngine;
import jetbrains.youtrack.api.webr.LocalScoped;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="issueUpdateMonitoringService")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0007R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/charisma/main/IssueUpdateMonitoringService;", "", "queryEngine", "Ljetbrains/charisma/persistent/queries/YouTrackTransientQueryEngine;", "(Ljetbrains/charisma/persistent/queries/YouTrackTransientQueryEngine;)V", "accessingIssues", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getAccessingIssues$youtrack_application", "()Ljava/util/concurrent/ConcurrentHashMap;", "enabled", "getEnabled", "()Z", "issueTypePrefix", "finishUpdate", "", "issueId", "isDatabaseId", "isUpdating", "Companion", "youtrack-application"})
public final class IssueUpdateMonitoringService {
    private final boolean enabled;
    private final String issueTypePrefix;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> accessingIssues;
    private final YouTrackTransientQueryEngine queryEngine;
    @NotNull
    public static final String FAIL_ON_CONCURRENT_UPDATES = "youtrack.feature.failOnIssueConcurrentUpdates";
    public static final Companion Companion = new Companion(null);

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final ConcurrentHashMap<String, Boolean> getAccessingIssues$youtrack_application() {
        return this.accessingIssues;
    }

    public final boolean isDatabaseId(@NotNull String issueId) {
        Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
        return StringsKt.startsWith$default((String)issueId, (String)this.issueTypePrefix, (boolean)false, (int)2, null);
    }

    public final boolean isUpdating(@NotNull String issueId) {
        Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
        if (this.enabled) {
            Boolean result2 = this.accessingIssues.putIfAbsent(issueId, true);
            return result2 != null;
        }
        return false;
    }

    public final void finishUpdate(@NotNull String issueId) {
        Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
        if (this.enabled) {
            this.accessingIssues.remove(issueId);
        }
    }

    public IssueUpdateMonitoringService(@Autowired @NotNull YouTrackTransientQueryEngine queryEngine) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)queryEngine), (String)"queryEngine");
        this.queryEngine = queryEngine;
        IssueUpdateMonitoringService issueUpdateMonitoringService = this;
        String string = System.getProperty(FAIL_ON_CONCURRENT_UPDATES, "false");
        if (string != null) {
            String string2 = string;
            IssueUpdateMonitoringService issueUpdateMonitoringService2 = issueUpdateMonitoringService;
            boolean bl2 = false;
            boolean bl3 = Boolean.parseBoolean(string2);
            issueUpdateMonitoringService = issueUpdateMonitoringService2;
            bl = bl3;
        } else {
            bl = false;
        }
        issueUpdateMonitoringService.enabled = bl;
        this.issueTypePrefix = "" + this.queryEngine.getIssueType() + '-';
        this.accessingIssues = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/charisma/main/IssueUpdateMonitoringService$Companion;", "", "()V", "FAIL_ON_CONCURRENT_UPDATES", "", "youtrack-application"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

