/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jetbrains.charisma.main.YouTrackPrincipalManager;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.mps.webr.runtime.util.DomainUtil;
import jetbrains.mps.webr.userManagement.runtime.ClientPrincipalManager;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.BeansKt;
import jetbrains.youtrack.persistent.PersitenceExtensionsKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import mu.KLogging;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webr.framework.controller.BaseApplication;

@LocalScoped
@Service(value="principalManager")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0017\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00110\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0016\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00070\u00070\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0012\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\"\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\fH\u0016J\u0012\u0010$\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010%\u001a\u00020\u000eH\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\fH\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ljetbrains/charisma/main/YouTrackPrincipalManager;", "Ljetbrains/mps/webr/userManagement/runtime/PrincipalManager;", "()V", "clientPrincipalManager", "Ljetbrains/mps/webr/userManagement/runtime/ClientPrincipalManager;", "principals", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/io/Serializable;", "", "temporaryServerPrincipal", "Ljava/lang/ThreadLocal;", "Ljava/util/LinkedList;", "", "dumpLoggedInUsers", "", "getClientPrincipal", "getClientPrincipalName", "", "getClientPrincipalValue", "kotlin.jvm.PlatformType", "userPrincipal", "getLoggedInCount", "getLoggedInPrincipals", "", "getPrincipal", "getPrincipalRaw", "session", "Ljavax/servlet/http/HttpSession;", "isLoggedIn", "", "principalRaw", "putLoginToMDC", "removePrincipal", "principal", "setClientPrincipal", "setServerPrincipal", "setTemporaryServerPrincipal", "unsetServerPrincipal", "unsetTemporaryServerPrincipal", "Companion", "youtrack-application"})
public class YouTrackPrincipalManager
implements PrincipalManager {
    @Autowired
    private ClientPrincipalManager clientPrincipalManager;
    private final ThreadLocal<LinkedList<Object>> temporaryServerPrincipal = new ThreadLocal();
    private final ConcurrentHashMap<Serializable, Integer> principals = new ConcurrentHashMap();
    @NotNull
    public static final String INTERNAL_LOGIN = "internal";
    @NotNull
    public static final String USERNAME_KEY = "username";
    @NotNull
    public static final String FALLBACK_LOGIN_ATTRIBUTE_NAME = "jetbrains.charisma.main.security.FALLBACK_PRINCIPAL";
    private static final String PRINCIPAL_NAME = "jetbrains.charisma.main.security.PRINCIPAL";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public int getLoggedInCount() {
        void $this$filterTo$iv$iv;
        Entity entity2 = BeansKt.getSecurity().getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"security.root");
        EntityId entityId = entity2.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"security.root.id");
        String xdUserTypeId = String.valueOf(entityId.getTypeId());
        Map $this$filter$iv = this.principals;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var7_7.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)it.getKey().toString(), (String)(xdUserTypeId + '-'), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv.size();
    }

    public void setServerPrincipal(@NotNull Object principal) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)principal, (String)"principal");
            Object loggedInPrincipal = this.getPrincipal();
            if (loggedInPrincipal != null && Intrinsics.areEqual((Object)loggedInPrincipal, (Object)principal) ^ true) {
                this.unsetServerPrincipal();
                Serializable serializable = this.getPrincipalRaw();
                if (serializable != null) {
                    Serializable serializable2 = serializable;
                    boolean bl = false;
                    boolean bl2 = false;
                    Serializable rawPrincipal = serializable2;
                    boolean bl3 = false;
                    this.principals.compute(rawPrincipal, setServerPrincipal.1.1.INSTANCE);
                }
            }
            BaseApplication.setSessionField((String)PRINCIPAL_NAME, (Object)principal);
            HttpServletRequest httpServletRequest = BaseApplication.getRequest();
            if (httpServletRequest == null) break block2;
            httpServletRequest.setAttribute(FALLBACK_LOGIN_ATTRIBUTE_NAME, principal);
        }
    }

    public void unsetServerPrincipal() {
        block0: {
            this.removePrincipal(this.getPrincipalRaw());
            BaseApplication.setSessionField((String)PRINCIPAL_NAME, null);
            HttpServletRequest httpServletRequest = BaseApplication.getRequest();
            if (httpServletRequest == null) break block0;
            httpServletRequest.removeAttribute(FALLBACK_LOGIN_ATTRIBUTE_NAME);
        }
    }

    public void unsetServerPrincipal(@NotNull HttpSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.removePrincipal(this.getPrincipalRaw(session));
    }

    public boolean isLoggedIn() {
        return (Boolean)LegacySupportKt.transactional((Function1)isLoggedIn.1.INSTANCE);
    }

    public boolean isLoggedIn(@NotNull Serializable principalRaw) {
        Intrinsics.checkParameterIsNotNull((Object)principalRaw, (String)"principalRaw");
        return this.principals.containsKey(principalRaw);
    }

    @NotNull
    public Set<Serializable> getLoggedInPrincipals() {
        Enumeration<Serializable> enumeration = this.principals.keys();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"principals.keys()");
        Enumeration<Serializable> enumeration2 = enumeration;
        boolean bl = false;
        ArrayList<Serializable> arrayList = Collections.list(enumeration2);
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
        return CollectionsKt.toSet((Iterable)arrayList);
    }

    @Nullable
    public Object getPrincipal() {
        LinkedList<Object> linkedList;
        LinkedList<Object> linkedList2 = this.temporaryServerPrincipal.get();
        if (linkedList2 == null || (linkedList2 = CollectionsKt.firstOrNull((List)linkedList2)) == null) {
            linkedList2 = linkedList = BaseApplication.getSessionField((String)PRINCIPAL_NAME);
        }
        if (linkedList2 == null) {
            HttpServletRequest httpServletRequest = BaseApplication.getRequest();
            linkedList = httpServletRequest != null ? httpServletRequest.getAttribute(FALLBACK_LOGIN_ATTRIBUTE_NAME) : null;
        }
        return linkedList;
    }

    private final Serializable getPrincipalRaw() {
        HttpServletRequest httpServletRequest = BaseApplication.getRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
        HttpSession httpSession = httpServletRequest.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpSession, (String)"BaseApplication.getRequest().session");
        return this.getPrincipalRaw(httpSession);
    }

    @Nullable
    public Serializable getPrincipalRaw(@NotNull HttpSession session) {
        Serializable serializable;
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        try {
            Map map2 = BaseApplication.getSessionBean((HttpSession)session);
            serializable = map2 != null ? (Serializable)map2.get(PRINCIPAL_NAME) : null;
        }
        catch (IllegalStateException e) {
            serializable = null;
        }
        return serializable;
    }

    public void setClientPrincipal(@Nullable Object userPrincipal) {
        String cookieValue = this.getClientPrincipalValue(userPrincipal);
        HttpServletRequest httpServletRequest = BaseApplication.getRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
        String localDomain = httpServletRequest.getServerName();
        String domainPattern = DomainUtil.getDomainPattern((String)localDomain);
        BaseApplication.setCookieField((String)PRINCIPAL_NAME, (Object)cookieValue, (String)domainPattern);
    }

    @Nullable
    public Object getClientPrincipal() {
        String cookieValue = (String)BaseApplication.getCookieField((String)PRINCIPAL_NAME, (String)String.class.getName());
        ClientPrincipalManager clientPrincipalManager = this.clientPrincipalManager;
        if (clientPrincipalManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientPrincipalManager");
        }
        return clientPrincipalManager.fromCookieString(cookieValue);
    }

    @NotNull
    public String getClientPrincipalValue() {
        String string = this.getClientPrincipalValue(this.getPrincipal());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.getClientPrincipalValue(this.getPrincipal())");
        return string;
    }

    @NotNull
    public String getClientPrincipalName() {
        return PRINCIPAL_NAME;
    }

    public void setTemporaryServerPrincipal(@Nullable Object userPrincipal) {
        LinkedList<Object> list = this.temporaryServerPrincipal.get();
        if (list == null) {
            list = new LinkedList();
            this.temporaryServerPrincipal.set(list);
        }
        list.addFirst(userPrincipal);
        if (userPrincipal != null) {
            this.putLoginToMDC(userPrincipal);
        }
    }

    @Nullable
    public Object unsetTemporaryServerPrincipal() {
        Object userPrincipal;
        LinkedList<Object> linkedList = this.temporaryServerPrincipal.get();
        if (linkedList == null) {
            return null;
        }
        LinkedList<Object> list = linkedList;
        list.removeFirst();
        Object prev = list.peek();
        Object object = prev;
        if (object == null) {
            object = userPrincipal = BaseApplication.getSessionField((String)PRINCIPAL_NAME);
        }
        if (userPrincipal == null) {
            MDC.remove((String)USERNAME_KEY);
        } else {
            this.putLoginToMDC(userPrincipal);
        }
        return userPrincipal;
    }

    public final void dumpLoggedInUsers() {
        StringBuilder builder;
        StringBuilder stringBuilder = builder = new StringBuilder();
        String string = "=== Logged in users dump:";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        Map $this$forEach$iv = this.principals;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl3 = false;
            StringBuilder stringBuilder3 = builder;
            StringBuilder stringBuilder4 = new StringBuilder();
            Object object = (XdUser)PersitenceExtensionsKt.tryFindById((XdEntityType)XdUser.Companion, entry.getKey().toString());
            if (object == null || (object = object.getLogin()) == null) {
                object = "No login";
            }
            String string2 = stringBuilder4.append((String)object).append(" : ").append(((Number)entry.getValue()).intValue()).toString();
            boolean bl4 = false;
            StringBuilder stringBuilder5 = stringBuilder3.append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
        }
        stringBuilder = builder;
        String string3 = "==========================";
        boolean bl5 = false;
        StringBuilder stringBuilder6 = stringBuilder.append(string3);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder6);
        Companion.getLogger().info(builder.toString());
    }

    private final String getClientPrincipalValue(Object userPrincipal) {
        ClientPrincipalManager clientPrincipalManager = this.clientPrincipalManager;
        if (clientPrincipalManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientPrincipalManager");
        }
        return clientPrincipalManager.toCookieString(userPrincipal);
    }

    private final void removePrincipal(Serializable principal) {
        if (principal != null) {
            this.principals.computeIfPresent(principal, removePrincipal.1.INSTANCE);
            this.principals.remove(principal, 0);
        }
    }

    private final void putLoginToMDC(Object userPrincipal) {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(userPrincipal){
            final /* synthetic */ Object $userPrincipal;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Object object = this.$userPrincipal;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.Entity");
                }
                Object login = PrimitiveAssociationSemantics.get((Entity)((Entity)object), (String)"login", null);
                StringBuilder stringBuilder = new StringBuilder();
                Object object2 = login;
                if (object2 == null) {
                    object2 = "internal";
                }
                HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                MDC.put((String)"username", (String)stringBuilder.append(object2).append('@').append(httpServletRequest != null ? httpServletRequest.getRemoteAddr() : null).toString());
            }
            {
                this.$userPrincipal = object;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/charisma/main/YouTrackPrincipalManager$Companion;", "Lmu/KLogging;", "()V", "FALLBACK_LOGIN_ATTRIBUTE_NAME", "", "INTERNAL_LOGIN", "PRINCIPAL_NAME", "USERNAME_KEY", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

