/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main;

import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import java.io.Closeable;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import jetbrains.charisma.main.IssueUpdateMonitoringService;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.mps.webr.rpc.rest.filter.runtime.TransactionalResourceFilter;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.service.BeansKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.NamedKLogging;
import org.glassfish.jersey.server.CloseableService;
import org.jetbrains.annotations.NotNull;

@Provider
@PreMatching
@Priority(value=2000)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u000f\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0018*\u00020\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Ljetbrains/charisma/main/YouTrackTransactionalFilter;", "Ljavax/ws/rs/container/ContainerRequestFilter;", "Ljavax/ws/rs/container/ContainerResponseFilter;", "closeableService", "Lorg/glassfish/jersey/server/CloseableService;", "(Lorg/glassfish/jersey/server/CloseableService;)V", "getCloseableService", "()Lorg/glassfish/jersey/server/CloseableService;", "monitoringService", "Ljetbrains/charisma/main/IssueUpdateMonitoringService;", "getMonitoringService", "()Ljetbrains/charisma/main/IssueUpdateMonitoringService;", "beginTransaction", "Ljetbrains/exodus/database/TransientStoreSession;", "filter", "", "context", "Ljavax/ws/rs/container/ContainerRequestContext;", "request", "response", "Ljavax/ws/rs/container/ContainerResponseContext;", "isRevertRequired", "", "toXDId", "", "issueId", "findAndCacheIssueId", "Companion", "TransactionCloseable", "youtrack-application"})
public final class YouTrackTransactionalFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    @NotNull
    private final CloseableService closeableService;
    private static final String SESSION_KEY;
    private static final String ISSUE_ID_KEY = "ISSUE_ID_PROCESSOR_KEY";
    public static final Companion Companion;

    private final IssueUpdateMonitoringService getMonitoringService() {
        String name$iv = "issueUpdateMonitoringService";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.main.IssueUpdateMonitoringService");
        }
        return (IssueUpdateMonitoringService)object;
    }

    public void filter(@NotNull ContainerRequestContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TransientStoreSession session = DnqUtils.getCurrentTransientSession();
        if (session != null) {
            TransientStoreUtil.abort((TransientStoreSession)session);
        }
        session = this.beginTransaction();
        Companion.getLogger().debug("Begin rest transaction");
        String issueId = this.findAndCacheIssueId(context);
        if (issueId != null && this.getMonitoringService().isUpdating(issueId)) {
            this.closeableService.add((Closeable)new TransactionCloseable(session));
            context.abortWith(Response.status((Response.Status)Response.Status.CONFLICT).build());
        } else {
            context.setProperty(SESSION_KEY, (Object)session);
            this.closeableService.add((Closeable)new TransactionCloseable(session));
        }
    }

    private final TransientStoreSession beginTransaction() {
        TransientStoreSession transientStoreSession = DnqUtils.beginTransientSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)transientStoreSession, (String)"DnqUtils.beginTransientSession()");
        return transientStoreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(@NotNull ContainerRequestContext request, @NotNull ContainerResponseContext response) {
        TransientStoreSession session;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Object object = request.getProperty(SESSION_KEY);
        if (!(object instanceof TransientStoreSession)) {
            object = null;
        }
        if ((session = (TransientStoreSession)object) != null) {
            Object object2;
            block12: {
                try {
                    if (this.isRevertRequired(response)) {
                        session.revert();
                        Companion.getLogger().debug("Revert rest transaction");
                        break block12;
                    }
                    try {
                        Companion.getLogger().debug("Commit rest transaction");
                        while (session.hasChanges()) {
                            session.flush();
                        }
                    }
                    catch (RuntimeException e) {
                        Companion.getLogger().warn("Can't commit rest transaction", (Throwable)e);
                        throw (Throwable)e;
                    }
                }
                catch (Throwable throwable) {
                    Object object3 = request.getProperty(ISSUE_ID_KEY);
                    if (!(object3 instanceof String)) {
                        object3 = null;
                    }
                    String string = (String)object3;
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        this.getMonitoringService().finishUpdate(it);
                    }
                    throw throwable;
                }
            }
            if (!((object2 = request.getProperty(ISSUE_ID_KEY)) instanceof String)) {
                object2 = null;
            }
            String string = (String)object2;
            if (string != null) {
                String string3 = string;
                boolean bl = false;
                boolean bl4 = false;
                String it = string3;
                boolean bl5 = false;
                this.getMonitoringService().finishUpdate(it);
            }
        }
    }

    private final boolean isRevertRequired(ContainerResponseContext response) {
        Response.StatusType statusType = response.getStatusInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"response.statusInfo");
        return statusType.getStatusCode() >= 400;
    }

    private final String findAndCacheIssueId(@NotNull ContainerRequestContext $this$findAndCacheIssueId) {
        String string = $this$findAndCacheIssueId.getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        String method2 = string4;
        if (Intrinsics.areEqual((Object)method2, (Object)"POST") || Intrinsics.areEqual((Object)method2, (Object)"PUT") || Intrinsics.areEqual((Object)method2, (Object)"DELETE")) {
            UriInfo uriInfo = $this$findAndCacheIssueId.getUriInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"uriInfo");
            List pathSegments = uriInfo.getPathSegments();
            if (pathSegments.size() >= 2) {
                Object e = pathSegments.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"pathSegments[0]");
                if (Intrinsics.areEqual((Object)((PathSegment)e).getPath(), (Object)"issues")) {
                    Object e2 = pathSegments.get(1);
                    Intrinsics.checkExpressionValueIsNotNull(e2, (String)"pathSegments[1]");
                    String canBeIssueId = ((PathSegment)e2).getPath();
                    if (Intrinsics.areEqual((Object)canBeIssueId, (Object)"similar")) {
                        return null;
                    }
                    String string5 = canBeIssueId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"canBeIssueId");
                    String string6 = this.toXDId(string5);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it = string6;
                    boolean bl4 = false;
                    $this$findAndCacheIssueId.setProperty(ISSUE_ID_KEY, (Object)it);
                    return string6;
                }
            }
        }
        return null;
    }

    private final String toXDId(String issueId) {
        String string;
        if (this.getMonitoringService().isDatabaseId(issueId)) {
            string = issueId;
        } else {
            string = BeansKt.getIssueByIdProvider().getIssueById(issueId);
            if (string == null || (string = string.toIdString()) == null) {
                string = issueId;
            }
        }
        return string;
    }

    @NotNull
    public final CloseableService getCloseableService() {
        return this.closeableService;
    }

    public YouTrackTransactionalFilter(@Context @NotNull CloseableService closeableService) {
        Intrinsics.checkParameterIsNotNull((Object)closeableService, (String)"closeableService");
        this.closeableService = closeableService;
    }

    static {
        Companion = new Companion(null);
        SESSION_KEY = TransactionalResourceFilter.class.getCanonicalName() + ".STORE_SESSION";
        ISSUE_ID_KEY = ISSUE_ID_KEY;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/charisma/main/YouTrackTransactionalFilter$TransactionCloseable;", "Ljava/io/Closeable;", "transaction", "Ljetbrains/exodus/database/TransientStoreSession;", "(Ljetbrains/charisma/main/YouTrackTransactionalFilter;Ljetbrains/exodus/database/TransientStoreSession;)V", "close", "", "youtrack-application"})
    public final class TransactionCloseable
    implements Closeable {
        private final TransientStoreSession transaction;

        @Override
        public void close() {
            if (this.transaction.isOpened()) {
                Companion.getLogger().debug("Abort rest transaction from fail-safe wrapper");
                this.transaction.abort();
            }
        }

        public TransactionCloseable(TransientStoreSession transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.transaction = transaction;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/charisma/main/YouTrackTransactionalFilter$Companion;", "Lmu/NamedKLogging;", "()V", "ISSUE_ID_KEY", "", "SESSION_KEY", "youtrack-application"})
    public static final class Companion
    extends NamedKLogging {
        private Companion() {
            String string = TransactionalResourceFilter.class.getCanonicalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"TransactionalResourceFil\u2026:class.java.canonicalName");
            super(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

