/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.config.DelegatedEmailConfiguration;
import jetbrains.charisma.main.config.YoutrackConfigurator;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.ReadOnlyKt;
import jetbrains.youtrack.api.notifications.EmailConfiguration;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.CoreKt;
import jetbrains.youtrack.core.persistent.XdMailSendProtocol;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import jetbrains.youtrack.core.ssl.SSLContextFactoryKt;
import jetbrains.youtrack.core.ssl.XdStorageEntry;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Service;
import webr.framework.url.HostToBaseUrlConfiguration;

@Service
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/charisma/main/config/EmailConfigurator;", "Ljetbrains/charisma/main/config/YoutrackConfigurator;", "mail", "Lorg/springframework/mail/javamail/JavaMailSenderImpl;", "templateMessage", "Lorg/springframework/mail/SimpleMailMessage;", "hostToBaseUrl", "Lwebr/framework/url/HostToBaseUrlConfiguration;", "(Lorg/springframework/mail/javamail/JavaMailSenderImpl;Lorg/springframework/mail/SimpleMailMessage;Lwebr/framework/url/HostToBaseUrlConfiguration;)V", "config", "Ljetbrains/youtrack/api/notifications/EmailConfiguration;", "getConfig", "()Ljetbrains/youtrack/api/notifications/EmailConfiguration;", "delegatedConfig", "Ljetbrains/charisma/main/config/DelegatedEmailConfiguration;", "configure", "", "fixHostedConfig", "fixStandaloneConfig", "populateMailConfigurationParameters", "properties", "Ljava/util/Properties;", "Companion", "youtrack-application"})
public final class EmailConfigurator
implements YoutrackConfigurator {
    private final DelegatedEmailConfiguration delegatedConfig;
    private final JavaMailSenderImpl mail;
    private final SimpleMailMessage templateMessage;
    private final HostToBaseUrlConfiguration hostToBaseUrl;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EmailConfiguration getConfig() {
        if (BeansKt.getXdNotificationsConfig().getDefaultSmtp()) {
            EmailConfiguration emailConfiguration = BeansKt.getNotificationSettingsRestorers().getDefaultEmailConfiguration();
            if (emailConfiguration == null) {
                emailConfiguration = this.delegatedConfig;
            }
            return emailConfiguration;
        }
        return this.delegatedConfig;
    }

    @Override
    public void configure() {
        if (!ReadOnlyKt.isReadonly()) {
            if (CoreKt.isYoutrackHosted()) {
                this.fixHostedConfig();
            } else {
                this.fixStandaloneConfig();
            }
        }
        this.configure(this.mail, this.templateMessage, this.hostToBaseUrl);
    }

    public final void configure(@NotNull JavaMailSenderImpl mail, @NotNull SimpleMailMessage templateMessage, @Nullable HostToBaseUrlConfiguration hostToBaseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)mail, (String)"mail");
        Intrinsics.checkParameterIsNotNull((Object)templateMessage, (String)"templateMessage");
        XdNotificationsConfig xdConfig = BeansKt.getXdNotificationsConfig();
        EmailConfiguration config = this.getConfig();
        HostToBaseUrlConfiguration hostToBaseUrlConfiguration = hostToBaseUrl;
        if (hostToBaseUrlConfiguration != null) {
            hostToBaseUrlConfiguration.setDefaultBaseUrl(xdConfig.getBaseUrl());
        }
        if (xdConfig.getEnableSmtp()) {
            XdMailSendProtocol mailSendProtocol;
            Object object;
            mail.setHost(config.getSmtpHost());
            int port2 = config.getSmtpPort();
            if (port2 > 0) {
                mail.setPort(port2);
            }
            if (!config.getSmtpAnonymous()) {
                mail.setUsername(config.getSmtpLogin());
                mail.setPassword(config.getSmtpPassword());
            }
            if ((object = (mailSendProtocol = config.getMailProtocol())) == null || (object = object.getValue()) == null) {
                object = "smtp";
            }
            Object protocol = object;
            mail.setProtocol((String)protocol);
            templateMessage.setFrom(config.getSmtpFrom());
            Properties props = new Properties();
            SSLSocketFactory sslSocketFactory = SSLContextFactoryKt.createSSLContext((XdStorageEntry)config.getSslKey()).getSocketFactory();
            ((Map)props).put("mail." + (String)protocol + ".connectiontimeout", 30000);
            ((Map)props).put("mail." + (String)protocol + ".timeout", 30000);
            ((Map)props).put("mail." + (String)protocol + ".ssl.socketFactory", sslSocketFactory);
            ((Map)props).put("mail." + (String)protocol + ".auth", String.valueOf(!config.getSmtpAnonymous()));
            String smtpEnvelopeFrom = config.getSmtpEnvelopeFrom();
            if (smtpEnvelopeFrom != null && xdConfig.getDefaultSmtp()) {
                ((Map)props).put("mail." + (String)protocol + ".from", smtpEnvelopeFrom);
            }
            if (Intrinsics.areEqual((Object)mailSendProtocol, (Object)XdMailSendProtocol.Companion.getSMTP_TLS())) {
                ((Map)props).put("mail.smtp.starttls.enable", true);
            }
            ((Map)props).put("mail.mime.address.strict", false);
            this.populateMailConfigurationParameters(props);
            mail.setJavaMailProperties(props);
        } else {
            mail.setHost("");
            mail.setPort(0);
        }
    }

    public static /* synthetic */ void configure$default(EmailConfigurator emailConfigurator, JavaMailSenderImpl javaMailSenderImpl, SimpleMailMessage simpleMailMessage, HostToBaseUrlConfiguration hostToBaseUrlConfiguration, int n, Object object) {
        if ((n & 4) != 0) {
            hostToBaseUrlConfiguration = null;
        }
        emailConfigurator.configure(javaMailSenderImpl, simpleMailMessage, hostToBaseUrlConfiguration);
    }

    /*
     * WARNING - void declaration
     */
    private final void populateMailConfigurationParameters(Properties properties2) {
        void $this$filterTo$iv$iv;
        Set set2 = ConfigurationParameter.getParameterKeySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"ConfigurationParameter.getParameterKeySet()");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (!StringsKt.startsWith$default((String)string, (String)"mail.", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Map)properties2).put(it, ConfigurationParameter.getParameter((String)it));
        }
    }

    private final void fixHostedConfig() {
        XdNotificationsConfig config = BeansKt.getXdNotificationsConfig();
        if (Intrinsics.areEqual((Object)config.getSmtpHost(), (Object)ConfigurationParameter.getParameter((String)ConfigurationParameter.SMTP_HOST.getKey()[0]))) {
            int n = config.getSmtpPort();
            String string = ConfigurationParameter.getParameter((String)ConfigurationParameter.SMTP_PORT.getKey()[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ConfigurationParameter.g\u2026rameter.SMTP_PORT.key[0])");
            String string2 = string;
            int n2 = n;
            boolean bl = false;
            int n3 = Integer.parseInt(string2);
            if (n2 == n3) {
                config.setDefaultSmtp(true);
                config.setSmtpHost((String)null);
                config.setSmtpLogin((String)null);
                config.setSmtpPassword((String)null);
            }
        }
    }

    private final void fixStandaloneConfig() {
        XdNotificationsConfig config = BeansKt.getXdNotificationsConfig();
        if (config.getDefaultSmtp()) {
            config.setDefaultSmtp(false);
            config.setEnableSmtp(false);
            config.setSmtpHost((String)null);
            config.setSmtpLogin((String)null);
            config.setSmtpPassword((String)null);
        }
    }

    public EmailConfigurator(@Qualifier(value="mailSender") @NotNull JavaMailSenderImpl mail, @Qualifier(value="templateMessage") @NotNull SimpleMailMessage templateMessage, @Qualifier(value="hostToBaseUrlConfiguration") @NotNull HostToBaseUrlConfiguration hostToBaseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)mail, (String)"mail");
        Intrinsics.checkParameterIsNotNull((Object)templateMessage, (String)"templateMessage");
        Intrinsics.checkParameterIsNotNull((Object)hostToBaseUrl, (String)"hostToBaseUrl");
        this.mail = mail;
        this.templateMessage = templateMessage;
        this.hostToBaseUrl = hostToBaseUrl;
        this.delegatedConfig = new DelegatedEmailConfiguration(BeansKt.getXdNotificationsConfig());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/charisma/main/config/EmailConfigurator$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

