/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.main.config;

import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.charisma.main.config.DelegatedJabberConfiguration;
import jetbrains.charisma.main.config.YoutrackConfigurator;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.ReadOnlyKt;
import jetbrains.youtrack.api.notifications.JabberConfiguration;
import jetbrains.youtrack.api.notifications.jabber.JabberSenderConfigurator;
import jetbrains.youtrack.api.notifications.jabber.YoutrackJabberService;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.CoreKt;
import jetbrains.youtrack.core.persistent.XdNotificationsConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="youtrackJabberConfigurator")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/charisma/main/config/JabberConfigurator;", "Ljetbrains/charisma/main/config/YoutrackConfigurator;", "jabber", "Ljetbrains/youtrack/api/notifications/jabber/JabberSenderConfigurator;", "jabberService", "Ljetbrains/youtrack/api/notifications/jabber/YoutrackJabberService;", "(Ljetbrains/youtrack/api/notifications/jabber/JabberSenderConfigurator;Ljetbrains/youtrack/api/notifications/jabber/YoutrackJabberService;)V", "config", "Ljetbrains/youtrack/api/notifications/JabberConfiguration;", "getConfig", "()Ljetbrains/youtrack/api/notifications/JabberConfiguration;", "delegatedConfig", "Ljetbrains/charisma/main/config/DelegatedJabberConfiguration;", "getDelegatedConfig", "()Ljetbrains/charisma/main/config/DelegatedJabberConfiguration;", "configure", "", "fixHosted", "fixStandalone", "youtrack-application"})
public final class JabberConfigurator
implements YoutrackConfigurator {
    private final JabberSenderConfigurator jabber;
    private final YoutrackJabberService jabberService;

    private final DelegatedJabberConfiguration getDelegatedConfig() {
        return new DelegatedJabberConfiguration(BeansKt.getXdNotificationsConfig());
    }

    @NotNull
    public final JabberConfiguration getConfig() {
        if (BeansKt.getXdNotificationsConfig().getDefaultJabber()) {
            JabberConfiguration jabberConfiguration = BeansKt.getNotificationSettingsRestorers().getDefaultJabberConfiguration();
            if (jabberConfiguration == null) {
                jabberConfiguration = this.getDelegatedConfig();
            }
            return jabberConfiguration;
        }
        return this.getDelegatedConfig();
    }

    @Override
    public void configure() {
        if (!ReadOnlyKt.isReadonly()) {
            if (CoreKt.isYoutrackHosted()) {
                this.fixHosted();
            } else {
                this.fixStandalone();
            }
        }
        this.jabber.configure(this.jabberService, this.getConfig(), true);
    }

    private final void fixHosted() {
        XdNotificationsConfig config = BeansKt.getXdNotificationsConfig();
        if (Intrinsics.areEqual((Object)config.getJabberServer(), (Object)ConfigurationParameter.getParameter((String)ConfigurationParameter.JABBER_SERVER.getKey()[0]))) {
            config.setDefaultJabber(true);
            config.setJabberServer((String)null);
            config.setJabberLogin((String)null);
            config.setJabberPassword((String)null);
        }
    }

    private final void fixStandalone() {
        XdNotificationsConfig config = BeansKt.getXdNotificationsConfig();
        if (config.getDefaultJabber()) {
            config.setDefaultJabber(false);
            config.setEnableJabber(false);
            config.setJabberServer((String)null);
            config.setJabberLogin((String)null);
            config.setJabberPassword((String)null);
        }
    }

    public JabberConfigurator(@NotNull JabberSenderConfigurator jabber, @NotNull YoutrackJabberService jabberService) {
        Intrinsics.checkParameterIsNotNull((Object)jabber, (String)"jabber");
        Intrinsics.checkParameterIsNotNull((Object)jabberService, (String)"jabberService");
        this.jabber = jabber;
        this.jabberService = jabberService;
    }
}

