/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.maintenance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.charisma.main.ConfigurationUtil;
import jetbrains.charisma.main.Limitation;
import jetbrains.charisma.main.TimeLimitation;
import jetbrains.charisma.maintenance.AnnualLicenseLimitationPercentageTweaker;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.UserClient;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.UserImpl;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="licenseLimitationProvider")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u0011R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Ljetbrains/charisma/maintenance/LicenseLimitationProvider;", "", "()V", "annualLicenseLimitationPercentageTweaker", "Ljetbrains/charisma/maintenance/AnnualLicenseLimitationPercentageTweaker;", "getAnnualLicenseLimitationPercentageTweaker", "()Ljetbrains/charisma/maintenance/AnnualLicenseLimitationPercentageTweaker;", "setAnnualLicenseLimitationPercentageTweaker", "(Ljetbrains/charisma/maintenance/AnnualLicenseLimitationPercentageTweaker;)V", "countLocalNonBannedUsers", "", "doGetUserCountForLicenseCheck", "getLimitations", "", "Ljetbrains/charisma/main/Limitation;", "getUserCountForLicenseCheck", "isTrial", "", "Companion", "youtrack-application"})
public final class LicenseLimitationProvider {
    @Autowired(required=false)
    @Nullable
    private AnnualLicenseLimitationPercentageTweaker annualLicenseLimitationPercentageTweaker;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final AnnualLicenseLimitationPercentageTweaker getAnnualLicenseLimitationPercentageTweaker() {
        return this.annualLicenseLimitationPercentageTweaker;
    }

    public final void setAnnualLicenseLimitationPercentageTweaker(@Nullable AnnualLicenseLimitationPercentageTweaker annualLicenseLimitationPercentageTweaker) {
        this.annualLicenseLimitationPercentageTweaker = annualLicenseLimitationPercentageTweaker;
    }

    @NotNull
    public final Collection<Limitation> getLimitations() {
        ArrayList<AnnualLicenseLimitationPercentageTweaker> limitations2 = new ArrayList<AnnualLicenseLimitationPercentageTweaker>();
        long licenseExpirationTime = CharismaLicenseChecker.getLicenseExpirationTime();
        long licenseFreeUpdateEnd = CharismaLicenseChecker.getLicenseFreeUpdateEnd();
        boolean banGuestForbidden = CharismaLicenseChecker.checkFlag((LicenseFlag)LicenseFlag.BAN_GUEST_FORBIDDEN);
        Limitation limitation = new Limitation("user_count", (long)this.getUserCountForLicenseCheck(), (long)CharismaLicenseChecker.getUserCount(), (long)Integer.MAX_VALUE);
        ArrayList<AnnualLicenseLimitationPercentageTweaker> arrayList = limitations2;
        boolean bl = false;
        boolean bl2 = false;
        Limitation limit = limitation;
        boolean bl3 = false;
        AnnualLicenseLimitationPercentageTweaker annualLicenseLimitationPercentageTweaker = this.annualLicenseLimitationPercentageTweaker;
        if (annualLicenseLimitationPercentageTweaker == null || (annualLicenseLimitationPercentageTweaker = annualLicenseLimitationPercentageTweaker.recalculateUsersCountLimitation(limit)) == null) {
            annualLicenseLimitationPercentageTweaker = limit;
        }
        AnnualLicenseLimitationPercentageTweaker annualLicenseLimitationPercentageTweaker2 = annualLicenseLimitationPercentageTweaker;
        arrayList.add(annualLicenseLimitationPercentageTweaker2);
        limitations2.add((AnnualLicenseLimitationPercentageTweaker)new Limitation("project_count", (long)XdQueryKt.size((XdQuery)XdProject.Companion.all()), (long)CharismaLicenseChecker.getProjectCount(), (long)Integer.MAX_VALUE));
        limitations2.add((AnnualLicenseLimitationPercentageTweaker)new Limitation("issue_count", (long)QueryOperations.roughSize((Iterable)jetbrains.charisma.persistent.BeansKt.getPermissions().excludeDraftsAndDeleted(XdIssue.Companion.all().getEntityIterable())), CharismaLicenseChecker.getIssueCount(), Long.MAX_VALUE));
        limitation = new Limitation("disk_space", CharismaLicenseChecker.getDiskSpace() == Integer.MAX_VALUE ? 0L : jetbrains.charisma.persistent.BeansKt.getDiskSpaceManagement().getStorageSizeWithBackups() >> 20, (long)CharismaLicenseChecker.getDiskSpace(), (long)Integer.MAX_VALUE);
        arrayList = limitations2;
        bl = false;
        bl2 = false;
        limit = limitation;
        boolean bl4 = false;
        AnnualLicenseLimitationPercentageTweaker annualLicenseLimitationPercentageTweaker3 = this.annualLicenseLimitationPercentageTweaker;
        if (annualLicenseLimitationPercentageTweaker3 == null || (annualLicenseLimitationPercentageTweaker3 = annualLicenseLimitationPercentageTweaker3.recalculateDiskUsageLimitation(limit)) == null) {
            annualLicenseLimitationPercentageTweaker3 = limit;
        }
        annualLicenseLimitationPercentageTweaker2 = annualLicenseLimitationPercentageTweaker3;
        arrayList.add(annualLicenseLimitationPercentageTweaker2);
        if (ConfigurationUtil.isYoutrackHosted()) {
            limitations2.add((AnnualLicenseLimitationPercentageTweaker)new Limitation("private_projects", 0L, banGuestForbidden ? 0L : 1L, 0L));
        }
        if (Long.MAX_VALUE == licenseExpirationTime) {
            limitations2.add((AnnualLicenseLimitationPercentageTweaker)new TimeLimitation("expiration_date", 0L, licenseExpirationTime, licenseExpirationTime));
        } else {
            if (ConfigurationUtil.isYoutrackHosted() && !this.isTrial()) {
                licenseExpirationTime -= TimeUnit.DAYS.toMillis(30L);
            }
            limitations2.add((AnnualLicenseLimitationPercentageTweaker)new TimeLimitation("expiration_date", 0L, licenseExpirationTime, 0L));
        }
        if (licenseFreeUpdateEnd != Long.MAX_VALUE && !ConfigurationUtil.isYoutrackHosted()) {
            limitations2.add((AnnualLicenseLimitationPercentageTweaker)new TimeLimitation("free_update_end", 0L, licenseFreeUpdateEnd, 0L));
        }
        limitations2.add((AnnualLicenseLimitationPercentageTweaker)new Limitation("change_logo_forbidden", 0L, CharismaLicenseChecker.checkFlag((LicenseFlag)LicenseFlag.CHANGE_LOGO_FORBIDDEN) ? 1L : 0L, 0L));
        return limitations2;
    }

    public final boolean isTrial() {
        return CharismaLicenseChecker.getLicenseType_() == 2;
    }

    public final int getUserCountForLicenseCheck() {
        return ((Number)LegacySupportKt.transactionalReadonly((Function1)((Function1)new Function1<TransientStoreSession, Integer>(this){
            final /* synthetic */ LicenseLimitationProvider this$0;

            public final int invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return LicenseLimitationProvider.access$doGetUserCountForLicenseCheck(this.this$0);
            }
            {
                this.this$0 = licenseLimitationProvider;
                super(1);
            }
        }))).intValue();
    }

    private final int doGetUserCountForLicenseCheck() {
        if (!BeansKt.getRingConfig().hasEmbeddedHub()) {
            try {
                UserClient client = jetbrains.charisma.persistent.security.BeansKt.getRingApi().getRingClient().getUserClient();
                Filter filter2 = new Filter(null, 1, null);
                filter2.query("hasLicense: {" + BeansKt.getRingConfig().getYouTrackServiceId() + "} and not is: banned");
                Integer total = client.getUserPage((BaseFilter)filter2, (FieldPartial)Partial.user((Partial.User[])new Partial.User[]{Partial.User.ID})).getTotal();
                return total == null || total == 0 ? this.countLocalNonBannedUsers() : total.intValue();
            }
            catch (Exception e) {
                Companion.getLogger().warn("License limitation provider can't get user count from Hub, falling back to local user count", (Throwable)e);
            }
        }
        return this.countLocalNonBannedUsers();
    }

    private final int countLocalNonBannedUsers() {
        return QueryOperations.getSize((Iterable)UserImpl.filterBanned((Iterable)UserImpl.all(), (boolean)false));
    }

    public static final /* synthetic */ int access$doGetUserCountForLicenseCheck(LicenseLimitationProvider $this) {
        return $this.doGetUserCountForLicenseCheck();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/charisma/maintenance/LicenseLimitationProvider$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

