/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.attachments;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import jetbrains.charisma.persistence.attachments.BigBufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/charisma/persistence/attachments/BigImageMultiStepRescaleOp;", "Lcom/mortennobel/imagescaling/AdvancedResizeOp;", "dstWidth", "", "dstHeight", "renderingHintInterpolation", "", "(IILjava/lang/Object;)V", "doFilter", "Ljava/awt/image/BufferedImage;", "img", "dest", "youtrack-application"})
public final class BigImageMultiStepRescaleOp
extends AdvancedResizeOp {
    private final Object renderingHintInterpolation;

    @NotNull
    public BufferedImage doFilter(@NotNull BufferedImage img, @Nullable BufferedImage dest, int dstWidth, int dstHeight) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        BufferedImage currentImage = img;
        int w = img.getWidth();
        int h = img.getHeight();
        while (true) {
            BufferedImage bufferedImage;
            if (w > dstWidth) {
                if ((w /= 2) < dstWidth) {
                    w = dstWidth;
                }
            } else {
                w = dstWidth;
            }
            if (h > dstHeight) {
                if ((h /= 2) < dstHeight) {
                    h = dstHeight;
                }
            } else {
                h = dstHeight;
            }
            if (dest != null && dest.getWidth() == w && dest.getHeight() == h && w == dstWidth && h == dstHeight) {
                bufferedImage = dest;
            } else {
                ColorModel colorModel = img.getColorModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)colorModel, (String)"img.colorModel");
                bufferedImage = BigBufferedImage.Companion.allocate(colorModel, w, h);
            }
            BufferedImage tmp = bufferedImage;
            Graphics2D outputGraphics = tmp.createGraphics();
            outputGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.renderingHintInterpolation);
            outputGraphics.drawImage(currentImage, 0, 0, w, h, null);
            outputGraphics.dispose();
            if (currentImage != img) {
                BigBufferedImage.Companion.dispose(currentImage);
            }
            if (w == dstWidth && h == dstHeight) {
                return tmp;
            }
            currentImage = tmp;
        }
    }

    public BigImageMultiStepRescaleOp(int dstWidth, int dstHeight, @NotNull Object renderingHintInterpolation) {
        Intrinsics.checkParameterIsNotNull((Object)renderingHintInterpolation, (String)"renderingHintInterpolation");
        super(DimensionConstrain.createAbsolutionDimension((int)dstWidth, (int)dstHeight));
        this.renderingHintInterpolation = renderingHintInterpolation;
    }

    public /* synthetic */ BigImageMultiStepRescaleOp(int n, int n2, Object object, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            Object object2 = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"RenderingHints.VALUE_INTERPOLATION_BILINEAR");
            object = object2;
        }
        this(n, n2, object);
    }
}

