/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistence.attachments;

import com.mortennobel.imagescaling.ThumpnailRescaleOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import jetbrains.charisma.persistence.attachments.BigBufferedImage;
import jetbrains.charisma.persistence.attachments.BigImageMultiStepRescaleOp;
import jetbrains.charisma.persistence.attachments.ImageIOExtKt;
import jetbrains.charisma.smartui.panel.attachment.AttachmentThumbnailImpl;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityStore;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.teamsys.dnq.runtime.files.FileMeta;
import jetbrains.youtrack.core.persistent.XdPersistentFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a8\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002\u001a6\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u001a\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0000\u001a.\u0010\u0018\u001a\u00020\u0003*\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a2\u0010\u001a\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"originalImageMsg", "", "getImageThumbnail", "Ljava/io/InputStream;", "maxWidth", "", "maxHeight", "cropped", "", "fileMeta", "Ljetbrains/teamsys/dnq/runtime/files/FileMeta;", "streamGetter", "Lkotlin/Function0;", "getImageThumbnailSafe", "getter", "imageError", "e", "", "draw", "", "Ljava/awt/image/BufferedImage;", "part", "x", "y", "getThumbnail", "Ljetbrains/youtrack/core/persistent/XdPersistentFile;", "scale", "width", "height", "youtrack-application"})
public final class ImageIOExtKt {
    private static final String originalImageMsg = "Failed to create thumbnail for image. Will return original image";

    @JvmOverloads
    @NotNull
    public static final InputStream getThumbnail(@NotNull XdPersistentFile $this$getThumbnail, int maxWidth, int maxHeight, boolean cropped, @NotNull FileMeta fileMeta) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getThumbnail, (String)"$this$getThumbnail");
        Intrinsics.checkParameterIsNotNull((Object)fileMeta, (String)"fileMeta");
        Entity e = $this$getThumbnail.getEntity();
        if (e instanceof TransientEntity && (((TransientEntity)e).isNew() || ((TransientEntity)e).hasChanges("content"))) {
            throw (Throwable)new UnsupportedOperationException("Can't preview un-flushed file content");
        }
        Function0 contentGetter2 = (Function0)new Function0<InputStream>($this$getThumbnail, e){
            final /* synthetic */ XdPersistentFile $this_getThumbnail;
            final /* synthetic */ Entity $e;

            @NotNull
            public final InputStream invoke() {
                EntityStore entityStore = this.$e.getStore();
                if (entityStore == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntityStore");
                }
                return (InputStream)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)((TransientEntityStore)entityStore), (boolean)true, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, InputStream>(this){
                    final /* synthetic */ getThumbnail.contentGetter.1 this$0;

                    @NotNull
                    public final InputStream invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        InputStream inputStream = this.this$0.$this_getThumbnail.getContent();
                        if (inputStream == null) {
                            Intrinsics.throwNpe();
                        }
                        return inputStream;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)6, null);
            }
            {
                this.$this_getThumbnail = xdPersistentFile;
                this.$e = entity2;
                super(0);
            }
        };
        InputStream inputStream = $this$getThumbnail.getContent();
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = inputStream2;
            boolean bl3 = false;
            InputStream result2 = ImageIOExtKt.getImageThumbnailSafe(maxWidth, maxHeight, cropped, fileMeta, (Function0<? extends InputStream>)contentGetter2);
            if (result2 != null) {
                it.close();
                return result2;
            }
            return it;
        }
        throw (Throwable)new IllegalStateException("No file content");
    }

    public static /* synthetic */ InputStream getThumbnail$default(XdPersistentFile xdPersistentFile, int n, int n2, boolean bl, FileMeta fileMeta, int n3, Object object) {
        if ((n3 & 8) != 0) {
            fileMeta = new FileMeta(xdPersistentFile.getEntity());
        }
        return ImageIOExtKt.getThumbnail(xdPersistentFile, n, n2, bl, fileMeta);
    }

    @JvmOverloads
    @NotNull
    public static final InputStream getThumbnail(@NotNull XdPersistentFile $this$getThumbnail, int maxWidth, int maxHeight, boolean cropped) {
        return ImageIOExtKt.getThumbnail$default($this$getThumbnail, maxWidth, maxHeight, cropped, null, 8, null);
    }

    @Nullable
    public static final InputStream getImageThumbnailSafe(int maxWidth, int maxHeight, boolean cropped, @NotNull FileMeta fileMeta, @NotNull Function0<? extends InputStream> getter) {
        Intrinsics.checkParameterIsNotNull((Object)fileMeta, (String)"fileMeta");
        Intrinsics.checkParameterIsNotNull(getter, (String)"getter");
        try {
            return ImageIOExtKt.getImageThumbnail(maxWidth, maxHeight, cropped, fileMeta, getter);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            XdPersistentFile.Companion.getLogger().info((Function0)new Function0<String>(e, fileMeta){
                final /* synthetic */ ArrayIndexOutOfBoundsException $e;
                final /* synthetic */ FileMeta $fileMeta;

                @NotNull
                public final String invoke() {
                    return ImageIOExtKt.access$imageError(this.$e, this.$fileMeta);
                }
                {
                    this.$e = arrayIndexOutOfBoundsException;
                    this.$fileMeta = fileMeta;
                    super(0);
                }
            });
            XdPersistentFile.Companion.getLogger().trace("", (Throwable)e);
        }
        catch (NullPointerException e) {
            XdPersistentFile.Companion.getLogger().info((Function0)new Function0<String>(e, fileMeta){
                final /* synthetic */ NullPointerException $e;
                final /* synthetic */ FileMeta $fileMeta;

                @NotNull
                public final String invoke() {
                    return ImageIOExtKt.access$imageError(this.$e, this.$fileMeta);
                }
                {
                    this.$e = nullPointerException;
                    this.$fileMeta = fileMeta;
                    super(0);
                }
            });
            XdPersistentFile.Companion.getLogger().trace("", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            XdPersistentFile.Companion.getLogger().info((Function0)new Function0<String>(e, fileMeta){
                final /* synthetic */ IllegalArgumentException $e;
                final /* synthetic */ FileMeta $fileMeta;

                @NotNull
                public final String invoke() {
                    return ImageIOExtKt.access$imageError(this.$e, this.$fileMeta);
                }
                {
                    this.$e = illegalArgumentException;
                    this.$fileMeta = fileMeta;
                    super(0);
                }
            });
            XdPersistentFile.Companion.getLogger().trace("", (Throwable)e);
        }
        catch (IIOException e) {
            XdPersistentFile.Companion.getLogger().info((Function0)new Function0<String>(e, fileMeta){
                final /* synthetic */ IIOException $e;
                final /* synthetic */ FileMeta $fileMeta;

                @NotNull
                public final String invoke() {
                    return ImageIOExtKt.access$imageError(this.$e, this.$fileMeta);
                }
                {
                    this.$e = iIOException;
                    this.$fileMeta = fileMeta;
                    super(0);
                }
            });
            XdPersistentFile.Companion.getLogger().trace("", (Throwable)e);
        }
        catch (TimeoutException t2) {
            XdPersistentFile.Companion.getLogger().warn((Throwable)t2, (Function0)new Function0<String>(fileMeta){
                final /* synthetic */ FileMeta $fileMeta;

                @NotNull
                public final String invoke() {
                    return "Timeout while calculating image thumbnail for " + this.$fileMeta.getName() + ", mime type: " + this.$fileMeta.getMimeType();
                }
                {
                    this.$fileMeta = fileMeta;
                    super(0);
                }
            });
        }
        catch (Throwable t3) {
            XdPersistentFile.Companion.getLogger().error(t3, (Function0)new Function0<String>(fileMeta){
                final /* synthetic */ FileMeta $fileMeta;

                @NotNull
                public final String invoke() {
                    return "Failed to create thumbnail for image. Will return original image, mime type: " + this.$fileMeta.getMimeType();
                }
                {
                    this.$fileMeta = fileMeta;
                    super(0);
                }
            });
        }
        return null;
    }

    public static final void draw(@NotNull BufferedImage $this$draw, @NotNull BufferedImage part, int x, int y) {
        Intrinsics.checkParameterIsNotNull((Object)$this$draw, (String)"$this$draw");
        Intrinsics.checkParameterIsNotNull((Object)part, (String)"part");
        WritableRaster source = part.getRaster();
        WritableRaster target = $this$draw.getRaster();
        WritableRaster writableRaster = source;
        Intrinsics.checkExpressionValueIsNotNull((Object)writableRaster, (String)"source");
        int n = writableRaster.getNumBands();
        WritableRaster writableRaster2 = target;
        Intrinsics.checkExpressionValueIsNotNull((Object)writableRaster2, (String)"target");
        if (n != writableRaster2.getNumBands()) {
            $this$draw.getGraphics().drawImage(part, x, y, null);
        } else {
            target.setRect(x, y, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final InputStream getImageThumbnail(int maxWidth, int maxHeight, boolean cropped, FileMeta fileMeta, Function0<? extends InputStream> streamGetter) {
        BufferedImage image = BigBufferedImage.Companion.read(streamGetter);
        if (image != null) {
            try {
                int width = image.getWidth();
                int height = image.getHeight();
                if (width > maxWidth || height > maxHeight) {
                    fileMeta.usePngAsDefault();
                    if (fileMeta.getMimeType() != null) {
                        String string = fileMeta.getMimeType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileMeta.mimeType");
                        String string2 = string;
                        List list = AttachmentThumbnailImpl.formatsToConvertToPNG;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        String string5 = string4;
                        if (list.contains(string5)) {
                            fileMeta.forcePng();
                        }
                    }
                    BufferedImage thumbImage = ImageIOExtKt.scale(image, maxWidth, maxHeight, cropped, width, height);
                    try {
                        LightByteArrayOutputStream out = new LightByteArrayOutputStream();
                        ImageIO.write((RenderedImage)thumbImage, fileMeta.getFormat(), (OutputStream)out);
                        byte[] byteArray = out.toByteArray();
                        fileMeta.setSize((long)byteArray.length);
                        InputStream inputStream = new ByteArrayInputStream(byteArray);
                        return inputStream;
                    }
                    finally {
                        BigBufferedImage.Companion.dispose(thumbImage);
                    }
                }
                InputStream inputStream = (InputStream)streamGetter.invoke();
                return inputStream;
            }
            finally {
                BigBufferedImage.Companion.dispose(image);
            }
        }
        return null;
    }

    @NotNull
    public static final BufferedImage scale(@NotNull BufferedImage $this$scale, int maxWidth, int maxHeight, boolean cropped, int width, int height) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2;
        Intrinsics.checkParameterIsNotNull((Object)$this$scale, (String)"$this$scale");
        double xRatio = (double)maxWidth / (double)width;
        double yRatio = (double)maxHeight / (double)height;
        double ratio = Math.min(1.0, cropped ? Math.max(xRatio, yRatio) : Math.min(xRatio, yRatio));
        boolean thumbnail = ratio < FileMeta.MAX_RESAMPLING_RATIO;
        int thumbWidth = (int)((double)width * ratio);
        int thumbHeight = (int)((double)height * ratio);
        if (thumbnail) {
            ThumpnailRescaleOp thumpnailRescaleOp = new ThumpnailRescaleOp(thumbWidth, thumbHeight);
            ColorModel colorModel = $this$scale.getColorModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)colorModel, (String)"colorModel");
            bufferedImage2 = thumpnailRescaleOp.filter($this$scale, BigBufferedImage.Companion.allocate(colorModel, thumbWidth, thumbHeight));
        } else {
            bufferedImage2 = new BigImageMultiStepRescaleOp(thumbWidth, thumbHeight, null, 4, null).filter($this$scale, null);
        }
        BufferedImage bufferedImage3 = bufferedImage2;
        boolean bl = false;
        boolean bl2 = false;
        BufferedImage it = bufferedImage3;
        boolean bl3 = false;
        if (cropped) {
            BufferedImage bufferedImage4 = it.getSubimage(0, 0, thumbWidth > maxWidth ? maxWidth : thumbWidth, thumbHeight > maxHeight ? maxHeight : thumbHeight);
            bufferedImage = bufferedImage4;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage4, (String)"it.getSubimage(0, 0, if \u2026humbHeight\n            })");
        } else {
            BufferedImage bufferedImage5 = it;
            bufferedImage = bufferedImage5;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage5, (String)"it");
        }
        return bufferedImage;
    }

    private static final String imageError(Throwable e, FileMeta fileMeta) {
        return "Failed to create thumbnail for image. Will return original image. " + e.getClass().getName() + " " + e.getMessage() + ", mime type: " + fileMeta.getMimeType();
    }

    public static final /* synthetic */ String access$imageError(Throwable e, FileMeta fileMeta) {
        return ImageIOExtKt.imageError(e, fileMeta);
    }
}

