/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent.issue;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.charisma.persistent.issue.CacheParentStrategy;
import jetbrains.charisma.persistent.issue.ParentIssueCachingStrategy;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.SourceMappingIterator;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdFilteringQueryKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J:\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/charisma/persistent/issue/CacheParentStrategy;", "Ljetbrains/charisma/persistent/issue/ParentIssueCachingStrategy;", "()V", "parents", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljetbrains/exodus/entitystore/EntityId;", "addedOrUpdated", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "extractParentIds", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "", "issues", "", "Ljetbrains/exodus/entitystore/Entity;", "list", "", "indices", "", "init", "removed", "Companion", "youtrack-application"})
public final class CacheParentStrategy
implements ParentIssueCachingStrategy {
    private final ConcurrentHashMap<Long, EntityId> parents = new ConcurrentHashMap();
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public LongHashMap<Object> extractParentIds(@NotNull Iterable<? extends Entity> issues2, @NotNull List<? extends EntityId> list, @NotNull LongHashMap<Integer> indices) {
        Intrinsics.checkParameterIsNotNull(issues2, (String)"issues");
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
        LongHashMap result2 = new LongHashMap();
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityId it = (EntityId)element$iv;
            boolean bl = false;
            long localId = it.getLocalId();
            EntityId candidate = this.parents.get(localId);
            if (candidate == null || indices.get(candidate.getLocalId()) == null) continue;
            ((Map)result2).put(localId, candidate);
        }
        return result2;
    }

    @Override
    public void addedOrUpdated(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdIssue parent2 = issue2.getParent();
        if (parent2 == null || issue2.getDeleted()) {
            this.parents.remove(issue2.getEntityId().getLocalId());
        } else {
            ((Map)this.parents).put(issue2.getEntityId().getLocalId(), parent2.getEntityId());
        }
    }

    @Override
    public void removed(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        this.parents.remove(issue2.getEntityId().getLocalId());
    }

    @Override
    public void init() {
        long timestamp = System.currentTimeMillis();
        Companion.getLogger().info("starting initializing parent issues cache");
        Iterable iterable = XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdIssue.Companion), (Function2)init.issuesWithParent.1.INSTANCE).getEntityIterable();
        if (iterable == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.query.TreeKeepingEntityIterable");
        }
        TreeKeepingEntityIterable issuesWithParent2 = (TreeKeepingEntityIterable)iterable;
        Iterable iterable2 = issuesWithParent2.instantiate();
        if (iterable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIterableBase");
        }
        EntityIterator entityIterator = ((EntityIterableBase)iterable2).selectMany("parent").iterator();
        if (!(entityIterator instanceof SourceMappingIterator)) {
            entityIterator = null;
        }
        SourceMappingIterator sourceMappingIterator = (SourceMappingIterator)entityIterator;
        if (sourceMappingIterator != null) {
            SourceMappingIterator sourceMappingIterator2 = sourceMappingIterator;
            boolean bl = false;
            boolean bl2 = false;
            SourceMappingIterator it = sourceMappingIterator2;
            boolean bl3 = false;
            while (it.hasNext()) {
                EntityId parentId = it.nextId();
                if (parentId == null) continue;
                Map map2 = this.parents;
                EntityId entityId = it.getSourceId();
                Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"it.sourceId");
                map2.put(entityId.getLocalId(), parentId);
            }
        }
        Companion.getLogger().info("initializing parent issues cache took " + (System.currentTimeMillis() - timestamp) + " ms");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/charisma/persistent/issue/CacheParentStrategy$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

