/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent.project;

import java.util.regex.Pattern;
import jetbrains.charisma.persistent.Constraints;
import jetbrains.charisma.persistent.project.FieldRelatedUserConstraintValidationException;
import jetbrains.charisma.persistent.project.ProjectNameChangeListener$updatedSyncBeforeConstraints$1;
import jetbrains.charisma.persistent.project.ProjectNameChangeListener$updatedSyncBeforeConstraints$2;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.persistent.listeners.LocalXdListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/charisma/persistent/project/ProjectNameChangeListener;", "Ljetbrains/youtrack/persistent/listeners/LocalXdListener;", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "()V", "addedSyncBeforeConstraints", "", "added", "assertName", "project", "assertShortName", "updatedSyncBeforeConstraints", "old", "current", "youtrack-application"})
public final class ProjectNameChangeListener
extends LocalXdListener<XdProject> {
    @Override
    public void updatedSyncBeforeConstraints(@NotNull XdProject old, @NotNull XdProject current) {
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        CharSequence charSequence = current.getName();
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = current.getShortName();
            bl = false;
            if (charSequence.length() > 0) {
                if (ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)current), (KProperty1)((KProperty1)ProjectNameChangeListener$updatedSyncBeforeConstraints$1.INSTANCE))) {
                    this.assertName(current);
                }
                Constraints.assertNoForbiddenPathChars((Entity)current.getEntity(), (String)"name", (String)BeansKt.getLocalizer().localizedMsg("Project.name", new Object[0]));
                if (ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)current), (KProperty1)((KProperty1)ProjectNameChangeListener$updatedSyncBeforeConstraints$2.INSTANCE))) {
                    this.assertShortName(current);
                }
            }
        }
    }

    @Override
    public void addedSyncBeforeConstraints(@NotNull XdProject added) {
        Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
        CharSequence charSequence = added.getName();
        boolean bl = false;
        if (charSequence.length() > 0) {
            charSequence = added.getShortName();
            bl = false;
            if (charSequence.length() > 0) {
                this.assertName(added);
                Constraints.assertNoForbiddenPathChars((Entity)added.getEntity(), (String)"name", (String)BeansKt.getLocalizer().localizedMsg("Project.name", new Object[0]));
                this.assertShortName(added);
            }
        }
    }

    private final void assertShortName(XdProject project2) throws ConstraintsValidationException {
        boolean matches2 = Pattern.compile("[a-zA-Z0-9_]+").matcher(project2.getShortName()).matches();
        if (!matches2) {
            String string = BeansKt.getLocalizer().localizedMsg("Project.Forbidden_characters_in_project_ID_Only_letters_digits_and_underscore_are_allowed", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026_underscore_are_allowed\")");
            Entity entity2 = project2.getEntity();
            if (entity2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
            }
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new FieldRelatedUserConstraintValidationException(string, (TransientEntity)entity2, "shortName"));
        }
    }

    private final void assertName(XdProject project2) throws ConstraintsValidationException {
        String string = project2.getName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String name2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (StringsKt.startsWith$default((String)name2, (String)"$t$-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"$s$-", (boolean)false, (int)2, null)) {
            String string3 = BeansKt.getLocalizer().localizedMsg("Project.Project_name_can_not_start_with_{0}-_or_with_{1}-", new Object[]{"$t$", "$s$"});
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"localizer.localizedMsg(\"\u2026SavedQueryImpl.ID_PREFIX)");
            Entity entity2 = project2.getEntity();
            if (entity2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.database.TransientEntity");
            }
            throw (Throwable)new ConstraintsValidationException((DataIntegrityViolationException)new FieldRelatedUserConstraintValidationException(string3, (TransientEntity)entity2, "name"));
        }
    }
}

