/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.persistent.security;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.main.RestEntityUtilsKt;
import jetbrains.charisma.main.SingleSmtpAdressWrapper;
import jetbrains.charisma.persistence.user.User;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.persistent.Project;
import jetbrains.charisma.persistent.project.ProjectBuilder;
import jetbrains.charisma.persistent.project.ProjectTemplate;
import jetbrains.charisma.persistent.security.PrincipalsKt;
import jetbrains.charisma.persistent.security.ProjectsResource;
import jetbrains.charisma.persistent.security.ProjectsResource$canCreate$1$1;
import jetbrains.charisma.persistent.security.ProjectsResource$canCreate$1$3;
import jetbrains.charisma.persistent.security.ProjectsResource$doCreate$1;
import jetbrains.charisma.persistent.security.ProjectsResource$doCreate$2;
import jetbrains.charisma.persistent.security.ProjectsResource$doCreate$3;
import jetbrains.charisma.persistent.security.ProjectsResource$doCreate$4;
import jetbrains.charisma.persistent.security.ProjectsResource$doCreate$5;
import jetbrains.charisma.persistent.security.ProjectsResource$doCreate$6;
import jetbrains.charisma.persistent.security.ProjectsResource$getElementById$project$1;
import jetbrains.charisma.persistent.security.ProjectsResource$getElementById$project$2;
import jetbrains.charisma.persistent.security.ProjectsResource$validateStartingNumber$1;
import jetbrains.charisma.plugin.PluggableResource;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.query.NodeBase;
import jetbrains.gap.resource.SecurityFiltersKt;
import jetbrains.gap.resource.WebUtilsKt;
import jetbrains.xodus.lang.EntitiesKt;
import jetbrains.youtrack.api.rest.RestPublic;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.issue.XdProjectHistoricalName;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.db.XodusDatabase;
import jetbrains.youtrack.gaprest.db.mapping.SimpleTypeMapping;
import jetbrains.youtrack.gaprest.db.mapping.TypeMapping;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.gaprest.exception.ExceptionsKt;
import jetbrains.youtrack.gaprest.exception.LocalizedBadRequestException;
import jetbrains.youtrack.gaprest.exception.LocalizedFieldException;
import jetbrains.youtrack.gaprest.exception.LocalizedForbiddenException;
import jetbrains.youtrack.persistent.XdProjectExtKt;
import jetbrains.youtrack.persistent.XdProjectPinKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RestPublic
@Path(value="admin/projects")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0007J\u0012\u0010\n\u001a\u00020\u00022\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/charisma/persistent/security/ProjectsResource;", "Ljetbrains/charisma/plugin/PluggableResource;", "Ljetbrains/charisma/persistent/Project;", "()V", "args", "Ljavax/ws/rs/core/UriInfo;", "assertUpdateAccess", "", "canCreate", "project", "clone", "id", "", "doCreate", "Ljetbrains/youtrack/gaprest/db/DatabaseEntity;", "entity", "template", "Ljetbrains/charisma/persistent/project/ProjectTemplate;", "doDelete", "filterAll", "Lkotlin/sequences/Sequence;", "query", "getAll", "getElementById", "", "validateStartingNumber", "youtrack-application"})
public final class ProjectsResource
extends PluggableResource<Project> {
    @Context
    private UriInfo args;

    public void assertUpdateAccess() {
        PrincipalsKt.assertAccess(PrincipalsKt.hasPermission((Entity)BeansKt.getLoggedInUser(), Permission.CREATE_PROJECT));
    }

    public void doDelete(@NotNull DatabaseEntity entity2) {
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        XdProjectExtKt.deleteProject(((Project)entity2).getXdEntity());
    }

    @NotNull
    public Sequence<DatabaseEntity> filterAll(@Nullable String query2) {
        CharSequence charSequence = query2;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return super.filterAll(query2);
        }
        String string = query2;
        bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String normalizedQuery = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Sequence<Project> projects2 = this.getAll();
        return SequencesKt.filter(projects2, (Function1)((Function1)new Function1<Project, Boolean>(normalizedQuery){
            final /* synthetic */ String $normalizedQuery;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Project it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                String string = it.getName();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                if (StringsKt.contains((CharSequence)string2, (CharSequence)this.$normalizedQuery, (boolean)true)) return true;
                string = it.getShortName();
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    string3 = "";
                }
                if (!StringsKt.contains((CharSequence)string3, (CharSequence)this.$normalizedQuery, (boolean)true)) return false;
                return true;
            }
            {
                this.$normalizedQuery = string;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Sequence<Project> getAll() {
        void $this$filterTo$iv$iv;
        XdUser user2 = BeansKt.getXdLoggedInUser();
        List list = jetbrains.youtrack.core.security.BeansKt.getSecurity().getProjects(user2.getEntity(), Permission.READ_PROJECT, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"security.getProjects(use\u2026ssion.READ_PROJECT, true)");
        List readProject = list;
        List list2 = jetbrains.youtrack.core.security.BeansKt.getSecurity().getProjects(user2.getEntity(), Permission.READ_PROJECT_BASIC, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"security.getProjects(use\u2026READ_PROJECT_BASIC, true)");
        List readIssue = list2;
        Iterable $this$filter$iv = CollectionsKt.union((Iterable)readProject, (Iterable)readIssue);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(!EntityOperations.isRemoved((Entity)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List accessibleProjects = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = accessibleProjects;
        boolean $i$f$sortedBy = false;
        Iterable iterable2 = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Entity it = (Entity)a;
                boolean bl2 = false;
                Entity entity2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity2, (String)"it");
                String string = (String)EntitiesKt.get((Entity)entity2, (String)"name");
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                string = string2;
                bl3 = false;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                it = (Entity)b;
                Comparable comparable = (Comparable)((Object)string4);
                bl2 = false;
                Entity entity3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)entity3, (String)"it");
                string = (String)EntitiesKt.get((Entity)entity3, (String)"name");
                bl3 = false;
                String string5 = string;
                if (string5 == null) {
                    string5 = "";
                }
                string = string5;
                bl3 = false;
                String string6 = string;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                String string8 = string7;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string8)));
            }
        };
        Sequence<XdProject> sortedProjects2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator)), (Function1)getAll.sortedProjects.2.INSTANCE);
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        return SequencesKt.map(Intrinsics.areEqual((Object)WebUtilsKt.get((UriInfo)uriInfo, (String)"sorting"), (Object)"natural") ? XdProjectPinKt.withNaturalSort(sortedProjects2, user2) : sortedProjects2, (Function1)getAll.1.INSTANCE);
    }

    private final DatabaseEntity doCreate(DatabaseEntity entity2, ProjectTemplate template) {
        DatabaseEntity databaseEntity = entity2;
        if (databaseEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.persistent.Project");
        }
        Project project2 = (Project)databaseEntity;
        ExceptionsKt.require((jetbrains.gap.resource.Entity)((jetbrains.gap.resource.Entity)project2), (KProperty1)((KProperty1)ProjectsResource$doCreate$1.INSTANCE));
        ExceptionsKt.require((jetbrains.gap.resource.Entity)((jetbrains.gap.resource.Entity)project2), (KProperty1)((KProperty1)ProjectsResource$doCreate$2.INSTANCE));
        ExceptionsKt.require((jetbrains.gap.resource.Entity)((jetbrains.gap.resource.Entity)project2), (KProperty1)((KProperty1)ProjectsResource$doCreate$3.INSTANCE));
        ProjectBuilder projectBuilder = template.getProjectBuilder();
        String string = project2.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        ProjectBuilder projectBuilder2 = projectBuilder.withName(string);
        String string2 = project2.getShortName();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        ProjectBuilder projectBuilder3 = projectBuilder2.withShortName(string2).withDescription(project2.getDescription());
        User user2 = project2.getLeader();
        if (user2 == null) {
            Intrinsics.throwNpe();
        }
        ProjectBuilder builder = projectBuilder3.withLeader(((User)HelpersKt.find$default((DatabaseEntity)user2, null, (int)1, null)).getXdEntity());
        if (project2.provides((KProperty1)ProjectsResource$doCreate$4.INSTANCE)) {
            SingleSmtpAdressWrapper smtpWrapper = new SingleSmtpAdressWrapper();
            smtpWrapper.parse(project2.getFromEmail());
            builder = builder.withFromEmailWrapper(smtpWrapper);
        }
        if (project2.provides((KProperty1)ProjectsResource$doCreate$5.INSTANCE)) {
            this.validateStartingNumber(project2);
            builder = builder.withStartingNumber(project2.getStartingNumber() - 1L);
        }
        XdEntity $this$kt$iv = (XdEntity)builder.buildProject();
        boolean $i$f$kt = false;
        Entity $receiver$iv$iv = $this$kt$iv.getEntity();
        Project result2 = (Project)XodusDatabase.INSTANCE.wrap(Project.class, $receiver$iv$iv, new Object[0]);
        jetbrains.gap.resource.HelpersKt.apply((jetbrains.gap.resource.Entity)((jetbrains.gap.resource.Entity)result2), (jetbrains.gap.resource.Entity)((jetbrains.gap.resource.Entity)entity2), (KMutableProperty1)ProjectsResource$doCreate$6.INSTANCE);
        result2.updateFrom((jetbrains.gap.resource.Entity)entity2);
        return result2;
    }

    private final void validateStartingNumber(Project project2) {
        if (project2.provides((KProperty1)ProjectsResource$validateStartingNumber$1.INSTANCE) && project2.getStartingNumber() < 0L) {
            throw (Throwable)new LocalizedBadRequestException("Resources.starting_number_cannot_be_less_than_zero", new Object[0]);
        }
    }

    @NotNull
    public DatabaseEntity doCreate(@NotNull DatabaseEntity entity2) {
        ProjectTemplate projectTemplate;
        Intrinsics.checkParameterIsNotNull((Object)entity2, (String)"entity");
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        String template = WebUtilsKt.get((UriInfo)uriInfo, (String)"template");
        CharSequence charSequence = template;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            projectTemplate = BeansKt.getDefaultProjectTemplate();
        } else {
            projectTemplate = BeansKt.getProjectTemplates().findTemplateByName(template);
            if (projectTemplate == null) {
                throw (Throwable)new NotFoundException();
            }
        }
        ProjectTemplate projectTemplate2 = projectTemplate;
        return this.doCreate((Project)entity2, projectTemplate2);
    }

    @NotNull
    public Object getElementById(@NotNull String id) {
        XdProject project2;
        Object object;
        NodeBase nodeBase;
        KProperty1 $receiver$iv;
        XdEntityType xdEntityType;
        XdProject xdProject;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        List tokens = StringsKt.split$default((CharSequence)id, (char[])new char[]{'-'}, (boolean)false, (int)0, (int)6, null);
        if (tokens.size() == 2) {
            return super.getElementById(id);
        }
        XdProject xdProject2 = BeansKt.getHubUuidResolver().resolveProjectByResourceUuid(id);
        if (xdProject2 == null) {
            xdProject2 = xdProject = jetbrains.charisma.ring.BeansKt.getRingDataStore().getProject(id);
        }
        if (xdProject2 == null) {
            KProperty1 kProperty1 = (KProperty1)ProjectsResource$getElementById$project$1.INSTANCE;
            xdEntityType = (XdEntityType)XdProject.Companion;
            nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdProject.class)), (Comparable)((Comparable)((Object)id)));
            xdProject = object = (XdProject)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase));
        }
        if (xdProject == null) {
            $receiver$iv = (KProperty1)ProjectsResource$getElementById$project$2.INSTANCE;
            xdEntityType = (XdEntityType)XdProjectHistoricalName.Companion;
            nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdProject.class)), (Comparable)((Comparable)((Object)id)));
            XdProjectHistoricalName xdProjectHistoricalName = (XdProjectHistoricalName)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)nodeBase));
            object = project2 = xdProjectHistoricalName != null ? xdProjectHistoricalName.getProject() : null;
        }
        if (project2 != null) {
            XdEntity $this$kt$iv = (XdEntity)project2;
            boolean $i$f$kt = false;
            Entity $receiver$iv$iv = $this$kt$iv.getEntity();
            if (((Project)XodusDatabase.INSTANCE.wrap(Project.class, $receiver$iv$iv, new Object[0])).canAccess()) {
                return this.getElementResource(this.getTypeMapping().wrap(project2.getEntity()));
            }
        }
        throw (Throwable)this.elementNotFound(id);
    }

    @POST
    @Path(value="canCreate")
    @Nullable
    public final Project canCreate(@Nullable Project project2) {
        block3: {
            Entity foundProject;
            XdUser user2 = BeansKt.getXdLoggedInUser();
            if (!user2.hasPermission(Permission.CREATE_PROJECT)) {
                throw (Throwable)new LocalizedForbiddenException("Resources.you_dont_have_permissions_to_create_project", new Object[0]);
            }
            HelpersKt.assertReadOnly();
            Project project3 = project2;
            if (project3 == null) break block3;
            Project project4 = project3;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project4;
            boolean bl3 = false;
            if (project2.provides((KProperty1)ProjectsResource$canCreate$1$1.INSTANCE) && (foundProject = ProjectImpl.findProject((String)project2.getShortName())) != null && Intrinsics.areEqual((Object)((XdProject)XdExtensionsKt.toXd((Entity)foundProject)).getShortName(), (Object)project2.getShortName())) {
                throw (Throwable)new LocalizedFieldException("shortName", Project.class, "must-be-unique", "Resources.project_id_must_be_unique", new Object[0]);
            }
            if (project2.provides((KProperty1)ProjectsResource$canCreate$1$3.INSTANCE) && ProjectImpl.findByName((String)project2.getName()) != null) {
                throw (Throwable)new LocalizedFieldException("name", Project.class, "must-be-unique", "Resources.project_name_must_be_unique", new Object[0]);
            }
            this.validateStartingNumber(project2);
        }
        return project2;
    }

    @POST
    @Path(value="{id}/clone")
    @NotNull
    public final Project clone(@PathParam(value="id") @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        PrincipalsKt.assertAccess(PrincipalsKt.hasPermission((Entity)BeansKt.getLoggedInUser(), Permission.CREATE_PROJECT));
        Project project2 = (Project)((Object)RestEntityUtilsKt.findById(Reflection.getOrCreateKotlinClass(Project.class), id));
        Project project3 = project2;
        if (Intrinsics.areEqual(project3 != null && (project3 = project3.getEntity()) != null && (project3 = project3.getPersistentEntity()) != null ? project3.getType() : null, (Object)"Project") ^ true) {
            throw (Throwable)new NotFoundException("Project " + id + " can not be found");
        }
        PrincipalsKt.assertAccess(PrincipalsKt.hasPermissionInProject((Entity)BeansKt.getLoggedInUser(), Permission.READ_PROJECT, project2));
        XdEntity $this$kt$iv = (XdEntity)jetbrains.charisma.main.BeansKt.getProjectCloneHandlers().clone((XdProject)XdExtensionsKt.toXd((Entity)((Entity)project2.getEntity())));
        boolean $i$f$kt = false;
        Entity $receiver$iv$iv = $this$kt$iv.getEntity();
        return (Project)XodusDatabase.INSTANCE.wrap(Project.class, $receiver$iv$iv, new Object[0]);
    }

    public ProjectsResource() {
        super(jetbrains.charisma.main.BeansKt.getGapStoreProvider(), (TypeMapping)new SimpleTypeMapping((XdEntityType)XdProject.Companion, Project.class), (Function1<? super DatabaseEntity, Boolean>)SecurityFiltersKt.getDefaultSecurityFilter());
    }
}

