/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import jetbrains.charisma.main.CharismaLicenseChecker;
import jetbrains.exodus.query.LinkEqual;
import jetbrains.exodus.query.NodeBase;
import jetbrains.ring.license.LicenseFlag;
import jetbrains.youtrack.api.user.UserGroupMergeHandler;
import jetbrains.youtrack.core.persistent.XdVisibilityEntity;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.persistent.user.XdUserGroup;
import jetbrains.youtrack.core.security.BeansKt;
import jetbrains.youtrack.persistent.XdBaseIssueComment;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdUserGroupExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0010"}, d2={"Ljetbrains/charisma/service/GeneralUserGroupMergeHandler;", "Ljetbrains/youtrack/api/user/UserGroupMergeHandler;", "()V", "isPermittedGroupChangeAllowed", "", "()Z", "groupDeleted", "", "deleted", "Ljetbrains/youtrack/core/persistent/user/XdUserGroup;", "successor", "groupMerged", "from", "to", "hasUsages", "group", "youtrack-application"})
public class GeneralUserGroupMergeHandler
implements UserGroupMergeHandler {
    private final boolean isPermittedGroupChangeAllowed() {
        return !CharismaLicenseChecker.checkFlag((LicenseFlag)LicenseFlag.BAN_GUEST_FORBIDDEN);
    }

    public void groupMerged(@NotNull XdUserGroup from2, @NotNull XdUserGroup to) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)from2, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Iterable $this$forEach$iv = XdQueryKt.asIterable((XdQuery)((XdQuery)from2.getUsers()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdUser)element$iv;
            boolean bl = false;
            BeansKt.getSecurity().addUserToUserGroup(it.getEntity(), to.getEntity());
        }
        if (XdUserGroupExtKt.getIcon(to) == null) {
            XdUserGroupExtKt.setIcon(to, XdUserGroupExtKt.getIcon(from2));
        }
        $this$forEach$iv = XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdIssue.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", from2.getEntity()))));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdIssue)element$iv;
            boolean bl = false;
            if (this.isPermittedGroupChangeAllowed()) {
                it.getPermittedGroup().remove((XdEntity)from2);
                it.getPermittedGroup().add((XdEntity)to);
                continue;
            }
            it.getPermittedGroup().clear();
        }
        $this$forEach$iv = XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdBaseIssueComment.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", from2.getEntity()))));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdBaseIssueComment)((Object)element$iv);
            boolean bl = false;
            if (this.isPermittedGroupChangeAllowed()) {
                ((XdBaseIssueComment)((Object)it)).getPermittedGroup().remove((XdEntity)from2);
                ((XdBaseIssueComment)((Object)it)).getPermittedGroup().add((XdEntity)to);
                continue;
            }
            ((XdBaseIssueComment)((Object)it)).getPermittedGroup().clear();
        }
        $this$forEach$iv = XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdIssueAttachment.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", from2.getEntity()))));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdIssueAttachment)element$iv;
            boolean bl = false;
            if (this.isPermittedGroupChangeAllowed()) {
                ((XdIssueAttachment)it).getPermittedGroup().remove((XdEntity)from2);
                ((XdIssueAttachment)it).getPermittedGroup().add((XdEntity)to);
                continue;
            }
            ((XdIssueAttachment)it).getPermittedGroup().clear();
        }
    }

    public void groupDeleted(@NotNull XdUserGroup deleted, @NotNull XdUserGroup successor2) {
        XdVisibilityEntity it;
        Intrinsics.checkParameterIsNotNull((Object)deleted, (String)"deleted");
        Intrinsics.checkParameterIsNotNull((Object)successor2, (String)"successor");
        Sequence $this$forEach$iv = XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdBaseIssueComment.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", deleted.getEntity()))));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (XdBaseIssueComment)((Object)element$iv);
            boolean bl = false;
            if (this.isPermittedGroupChangeAllowed()) {
                it.getPermittedGroup().add((XdEntity)successor2);
                it.getPermittedGroup().remove((XdEntity)deleted);
                continue;
            }
            it.getPermittedGroup().clear();
        }
        if (this.isPermittedGroupChangeAllowed()) {
            $this$forEach$iv = XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdIssue.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", deleted.getEntity()))));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (XdIssue)element$iv;
                boolean bl = false;
                it.getPermittedGroup().add((XdEntity)successor2);
            }
            $this$forEach$iv = XdQueryKt.asSequence((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdIssueAttachment.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", deleted.getEntity()))));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (XdIssueAttachment)element$iv;
                boolean bl = false;
                it.getPermittedGroup().add((XdEntity)successor2);
            }
        }
    }

    public boolean hasUsages(@NotNull XdUserGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        return XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdIssue.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", group.getEntity())))) || XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdBaseIssueComment.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", group.getEntity())))) || XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.query((XdEntityType)((XdEntityType)XdIssueAttachment.Companion), (NodeBase)((NodeBase)new LinkEqual("permittedGroup", group.getEntity()))));
    }
}

