/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.core.dataStructures.ObjectCache;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdIssueKey;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.issue.XdProjectHistoricalNameKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@LocalScoped
@Service(value="issueIdCache")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Ljetbrains/charisma/service/IssueIdCache;", "Ljetbrains/charisma/plugins/IssueIdCache;", "()V", "cache", "Ljetbrains/exodus/core/dataStructures/ObjectCache;", "", "Ljetbrains/exodus/entitystore/EntityId;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "persistentEntityStore", "Ljetbrains/exodus/entitystore/PersistentEntityStore;", "getPersistentEntityStore", "()Ljetbrains/exodus/entitystore/PersistentEntityStore;", "setPersistentEntityStore", "(Ljetbrains/exodus/entitystore/PersistentEntityStore;)V", "transientEntityStore", "Ljetbrains/exodus/database/TransientEntityStore;", "getTransientEntityStore", "()Ljetbrains/exodus/database/TransientEntityStore;", "setTransientEntityStore", "(Ljetbrains/exodus/database/TransientEntityStore;)V", "clear", "", "fromId", "Ljetbrains/exodus/entitystore/Entity;", "id", "tryResolve", "", "fromProjectAndId", "numberInProject", "", "project", "fromProjectTrace", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "removeIssueFromCache", "Companion", "youtrack-application"})
public class IssueIdCache
implements jetbrains.charisma.plugins.IssueIdCache {
    @Autowired
    @NotNull
    public PersistentEntityStore persistentEntityStore;
    @Autowired
    @NotNull
    public TransientEntityStore transientEntityStore;
    private final ReentrantLock lock = new ReentrantLock();
    private ObjectCache<String, EntityId> cache;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PersistentEntityStore getPersistentEntityStore() {
        PersistentEntityStore persistentEntityStore = this.persistentEntityStore;
        if (persistentEntityStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"persistentEntityStore");
        }
        return persistentEntityStore;
    }

    public final void setPersistentEntityStore(@NotNull PersistentEntityStore persistentEntityStore) {
        Intrinsics.checkParameterIsNotNull((Object)persistentEntityStore, (String)"<set-?>");
        this.persistentEntityStore = persistentEntityStore;
    }

    @NotNull
    public final TransientEntityStore getTransientEntityStore() {
        TransientEntityStore transientEntityStore = this.transientEntityStore;
        if (transientEntityStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transientEntityStore");
        }
        return transientEntityStore;
    }

    public final void setTransientEntityStore(@NotNull TransientEntityStore transientEntityStore) {
        Intrinsics.checkParameterIsNotNull((Object)transientEntityStore, (String)"<set-?>");
        this.transientEntityStore = transientEntityStore;
    }

    @Nullable
    public Entity fromId(@Nullable String id) {
        return this.fromId(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public Entity fromId(@Nullable String id, boolean tryResolve) {
        Object entity2;
        EntityId $i$a$-withLock-IssueIdCache$fromId$resultId$22;
        if (id == null) {
            return null;
        }
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean $i$a$-withLock-IssueIdCache$fromId$resultId$22 = false;
            $i$a$-withLock-IssueIdCache$fromId$resultId$22 = (EntityId)this.cache.tryKey((Object)id);
        }
        finally {
            lock.unlock();
        }
        EntityId resultId = $i$a$-withLock-IssueIdCache$fromId$resultId$22;
        if (resultId != null) {
            PersistentEntityStore persistentEntityStore = this.persistentEntityStore;
            if (persistentEntityStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"persistentEntityStore");
            }
            if (!EntityOperations.isRemoved((Entity)(entity2 = persistentEntityStore.getEntity(resultId))) && Intrinsics.areEqual((Object)entity2.getProperty("deleted"), (Object)true) ^ true) {
                Entity entity3 = entity2.getLink("project");
                if (entity3 != null) {
                    Entity entity4 = entity3;
                    boolean $i$a$-withLock-IssueIdCache$fromId$resultId$22 = false;
                    boolean bl2 = false;
                    Entity project2 = entity4;
                    boolean bl3 = false;
                    if (!EntityOperations.isRemoved((Entity)project2)) {
                        TransientEntityStore transientEntityStore = this.transientEntityStore;
                        if (transientEntityStore == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"transientEntityStore");
                        }
                        if (!EntityOperations.isRemoved((Entity)(entity2 = XdExtensionsKt.getSession((TransientEntityStore)transientEntityStore).getEntity(resultId)))) {
                            Companion.getLogger().trace("Issue is cache hit. Id " + entity2.toIdString() + " retuned for key " + id);
                            return entity2;
                        }
                    }
                }
            }
            Companion.getLogger().debug("Evicting value " + entity2.toIdString() + " with the key " + id);
            this.removeIssueFromCache(id);
        }
        if (tryResolve) {
            long l;
            void projectShortName;
            Companion.getLogger().debug("Issue id cache miss. Looking up " + id + "...");
            List list = StringsKt.split$default((CharSequence)id, (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
            boolean bl4 = false;
            boolean bl5 = false;
            List $this$with = list;
            boolean bl6 = false;
            if ($this$with.size() != 2) {
                return null;
            }
            Pair $i$a$-withLock-IssueIdCache$fromId$resultId$22 = TuplesKt.to($this$with.get(0), $this$with.get(1));
            entity2 = (String)$i$a$-withLock-IssueIdCache$fromId$resultId$22.component1();
            String issueNumber = (String)$i$a$-withLock-IssueIdCache$fromId$resultId$22.component2();
            XdProject xdProject = XdProjectHistoricalNameKt.findNotArchivedByKey((XdProject.Companion)XdProject.Companion, (String)projectShortName);
            if (xdProject == null) {
                return null;
            }
            XdProject project3 = xdProject;
            try {
                l = Long.parseLong(issueNumber);
            }
            catch (Throwable e) {
                return null;
            }
            long numberInProject = l;
            return this.fromProjectAndId(numberInProject, project3.getEntity(), id);
        }
        Companion.getLogger().debug("Issue id cache miss. No lookup for " + id + " requested, returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity fromProjectAndId(long numberInProject, @NotNull Entity project2, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        XdProject xdProject = (XdProject)XdExtensionsKt.toXd((Entity)project2);
        XdIssue xdIssue = (XdIssue)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdIssue.Companion), (Function2)((Function2)new Function2<FilteringContext, XdIssue, XdSearchingNode>(xdProject, numberInProject){
            final /* synthetic */ XdProject $xdProject;
            final /* synthetic */ long $numberInProject;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssue it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((XdEntity)it.getProject(), (XdEntity)this.$xdProject).and($this$filter.eq((Comparable)Long.valueOf(it.getNumberInProject()), (Comparable)Long.valueOf(this.$numberInProject))).and($this$filter.ne((Comparable)Boolean.valueOf(it.getDeleted()), (Comparable)Boolean.valueOf(true))).and($this$filter.eq((XdEntity)it.getDraftOwner(), null));
            }
            {
                this.$xdProject = xdProject;
                this.$numberInProject = l;
                super(2);
            }
        })));
        if (xdIssue == null) {
            xdIssue = this.fromProjectTrace(numberInProject, xdProject);
        }
        if (xdIssue != null) {
            XdIssue xdIssue2 = xdIssue;
            boolean bl = false;
            boolean bl2 = false;
            XdIssue result2 = xdIssue2;
            boolean bl3 = false;
            Lock lock = this.lock;
            boolean bl4 = false;
            lock.lock();
            try {
                boolean bl5 = false;
                this.cache.remove((Object)id);
                this.cache.cacheObject((Object)id, (Object)result2.getEntity().getId());
                Companion.getLogger().debug("Stored " + result2.getEntity().getId() + " for the key " + id + "...");
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            return result2.getEntity();
        }
        Companion.getLogger().debug("Nothing found for the key " + id + ". It may be deleted, be a draft or not existing in the first place.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            this.cache.clear();
            Companion.getLogger().debug("Cache has been cleared");
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final XdIssue fromProjectTrace(long numberInProject, XdProject project2) {
        XdIssue xdIssue;
        XdIssueKey key2;
        XdIssueKey xdIssueKey = key2 = (XdIssueKey)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdIssueKey.Companion), (Function2)((Function2)new Function2<FilteringContext, XdIssueKey, XdSearchingNode>(project2, numberInProject){
            final /* synthetic */ XdProject $project;
            final /* synthetic */ long $numberInProject;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssueKey it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((XdEntity)it.getProject(), (XdEntity)this.$project).and($this$filter.eq((Comparable)Long.valueOf(it.getNumberInProject()), (Comparable)Long.valueOf(this.$numberInProject)));
            }
            {
                this.$project = xdProject;
                this.$numberInProject = l;
                super(2);
            }
        })));
        if (xdIssueKey != null) {
            XdIssueKey xdIssueKey2 = xdIssueKey;
            boolean bl = false;
            boolean bl2 = false;
            XdIssueKey it = xdIssueKey2;
            boolean bl3 = false;
            xdIssue = (XdIssue)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdIssue.Companion), (Function2)((Function2)new Function2<FilteringContext, XdIssue, XdSearchingNode>(key2){
                final /* synthetic */ XdIssueKey $key$inlined;
                {
                    this.$key$inlined = xdIssueKey;
                    super(2);
                }

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdIssue it) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return $this$filter.contains((XdQuery)it.getProjectTrace(), (XdEntity)this.$key$inlined).and($this$filter.ne((Comparable)Boolean.valueOf(it.getDeleted()), (Comparable)Boolean.valueOf(true)));
                }
            })));
        } else {
            xdIssue = null;
        }
        return xdIssue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeIssueFromCache(String id) {
        Lock lock = this.lock;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            EntityId entityId = (EntityId)this.cache.remove((Object)id);
        }
        finally {
            lock.unlock();
        }
    }

    public IssueIdCache() {
        Integer n = Integer.getInteger("jetbrains.youtrack.issue_id_cache.size", 10000);
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Integer.getInteger(\"jetb\u2026ue_id_cache.size\", 10000)");
        this.cache = new ObjectCache(n.intValue());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/charisma/service/IssueIdCache$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

