/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import java.net.URLEncoder;
import jetbrains.charisma.persistent.IssueFolder;
import jetbrains.charisma.persistent.issueFolders.IssueFoldersMappingKt;
import jetbrains.charisma.service.IssueListUrlProvider;
import jetbrains.charisma.service.YoutrackLocationService;
import jetbrains.exodus.entitystore.Entity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="issueListUrlProvider")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Ljetbrains/charisma/service/IssueListUrlProviderImpl;", "Ljetbrains/charisma/service/IssueListUrlProvider;", "()V", "localeService", "Ljetbrains/charisma/service/YoutrackLocationService;", "getLocaleService", "()Ljetbrains/charisma/service/YoutrackLocationService;", "setLocaleService", "(Ljetbrains/charisma/service/YoutrackLocationService;)V", "getUrl", "", "query", "folder", "Ljetbrains/exodus/entitystore/Entity;", "youtrack-application"})
public class IssueListUrlProviderImpl
implements IssueListUrlProvider {
    @Autowired
    @NotNull
    public YoutrackLocationService localeService;

    @NotNull
    public final YoutrackLocationService getLocaleService() {
        YoutrackLocationService youtrackLocationService = this.localeService;
        if (youtrackLocationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localeService");
        }
        return youtrackLocationService;
    }

    public final void setLocaleService(@NotNull YoutrackLocationService youtrackLocationService) {
        Intrinsics.checkParameterIsNotNull((Object)youtrackLocationService, (String)"<set-?>");
        this.localeService = youtrackLocationService;
    }

    @NotNull
    public String getUrl(@Nullable String query2) {
        StringBuilder stringBuilder = new StringBuilder();
        YoutrackLocationService youtrackLocationService = this.localeService;
        if (youtrackLocationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localeService");
        }
        String issuesPath = stringBuilder.append(youtrackLocationService.getContextPath()).append("/issues").toString();
        CharSequence charSequence = query2;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return issuesPath;
        }
        return issuesPath + "?q=" + URLEncoder.encode(query2, "UTF-8");
    }

    @NotNull
    public String getUrl(@Nullable String query2, @Nullable Entity folder2) {
        if (folder2 == null) {
            return this.getUrl(query2);
        }
        IssueFolder f = IssueFoldersMappingKt.getIssueFoldersMapping().wrap(folder2);
        if (query2 == null) {
            return f.getIssuesUrl();
        }
        return f.getIssuesUrl() + "?q=" + URLEncoder.encode(query2, "UTF-8");
    }
}

