/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.plugin.DisplayUserProfile;
import jetbrains.charisma.plugin.IssuesListUserProfile;
import jetbrains.charisma.plugin.XdUserProfileService;
import jetbrains.charisma.plugins.GeneralUserProfile;
import jetbrains.charisma.service.PersistentSearchRequest;
import jetbrains.charisma.service.UserProfileServiceImpl;
import jetbrains.charisma.service.YoutrackLocationService;
import jetbrains.charisma.smartui.persistent.UserSearchRequest;
import jetbrains.charisma.user.ImmutableNotificationsUserProfile;
import jetbrains.charisma.user.InMemoryDisplayUserProfile;
import jetbrains.charisma.user.InMemoryGeneralUserProfile;
import jetbrains.charisma.user.InMemoryIssuesListUserProfile;
import jetbrains.charisma.user.InMemoryUserSearchRequest;
import jetbrains.charisma.user.NotificationsUserProfile;
import jetbrains.charisma.user.PersistentDisplayUserProfile;
import jetbrains.charisma.user.PersistentGeneralUserProfile;
import jetbrains.charisma.user.PersistentIssuesListUserProfile;
import jetbrains.charisma.user.PersistentNotificationsUserProfile;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.persistent.XdSearchRequest;
import jetbrains.youtrack.persistent.XdUserExtKt;
import jetbrains.youtrack.persistent.XdUserProfile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webr.framework.controller.BaseApplication;

@LocalScoped
@Service(value="userProfileService")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 (2\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\f\u0010\u0018\u001a\u00060\u0004R\u00020\u0000H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0013H\u0016R\u0012\u0010\u0003\u001a\u00060\u0004R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\u0004R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Ljetbrains/charisma/service/UserProfileServiceImpl;", "Ljetbrains/charisma/plugin/XdUserProfileService;", "()V", "NO_SESSION_DATA", "Ljetbrains/charisma/service/UserProfileServiceImpl$GuestData;", "guestProfiles", "Ljava/util/concurrent/ConcurrentHashMap;", "", "locationService", "Ljetbrains/charisma/service/YoutrackLocationService;", "nextCleanUp", "Ljava/util/concurrent/atomic/AtomicLong;", "quartzThreadExecutor", "Ljava/util/concurrent/Executor;", "getQuartzThreadExecutor", "()Ljava/util/concurrent/Executor;", "getAbsoluteProfileUrl", "user", "Ljetbrains/exodus/entitystore/Entity;", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "getDisplayUserProfile", "Ljetbrains/charisma/plugin/DisplayUserProfile;", "getGeneralUserProfile", "Ljetbrains/charisma/plugins/GeneralUserProfile;", "getGuestData", "getIssuesListUserProfile", "Ljetbrains/charisma/plugin/IssuesListUserProfile;", "getNotificationProfileUrl", "getNotificationsProfile", "Ljetbrains/charisma/user/NotificationsUserProfile;", "getProfileUrl", "getRelativeProfileUrl", "getSearchRequest", "Ljetbrains/charisma/smartui/persistent/UserSearchRequest;", "getUrlOfProfile", "hasPersistentProfile", "", "isProfileAccessible", "operation", "Ljetbrains/youtrack/core/security/Operation;", "Companion", "GuestData", "youtrack-application"})
public class UserProfileServiceImpl
implements XdUserProfileService {
    private final ConcurrentHashMap<String, GuestData> guestProfiles = new ConcurrentHashMap();
    private final AtomicLong nextCleanUp = new AtomicLong(System.currentTimeMillis() + 60000L);
    private final GuestData NO_SESSION_DATA = new GuestData(this, null, 1, null);
    @Autowired
    private YoutrackLocationService locationService;
    private static final ImmutableNotificationsUserProfile IMMUTABLE_NOTIFICATIONS_PROFILE;
    private static final long DEFAULT_CLEANUP_INTERVAL = 60000L;
    public static final Companion Companion;

    private final Executor getQuartzThreadExecutor() {
        String name$iv = "quartzThreadExecutor";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.Executor");
        }
        return (Executor)object;
    }

    @Override
    public boolean isProfileAccessible(@NotNull Operation operation, @NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        Entity entity2 = BeansKt.getCurrentUser().get();
        XdUser loggedInUser = entity2 != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity2) : null;
        String targetType = Intrinsics.areEqual((Object)loggedInUser, (Object)user2) ? XdUserProfile.Companion.getEntityType() : XdUser.Companion.getEntityType();
        return loggedInUser != null && loggedInUser.hasPermission(targetType, operation);
    }

    @NotNull
    public String getProfileUrl(@NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.getProfileUrl((XdUser)XdExtensionsKt.toXd((Entity)user2));
    }

    @Override
    @NotNull
    public String getProfileUrl(@NotNull XdUser user2) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        if (BaseApplication.isInsideRequestProcessing()) {
            HttpServletRequest httpServletRequest = BaseApplication.getRequest();
            Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
            string = httpServletRequest.getContextPath();
        } else {
            string = BeansKt.getXdNotificationsConfig().getBaseUrl();
        }
        String prefix = string;
        return Intrinsics.stringPlus((String)prefix, (Object)this.getUrlOfProfile(user2));
    }

    @NotNull
    public String getRelativeProfileUrl(@NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.getRelativeProfileUrl((XdUser)XdExtensionsKt.toXd((Entity)user2));
    }

    @Override
    @NotNull
    public String getRelativeProfileUrl(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        StringBuilder stringBuilder = new StringBuilder();
        YoutrackLocationService youtrackLocationService = this.locationService;
        if (youtrackLocationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"locationService");
        }
        return stringBuilder.append(youtrackLocationService.getContextPath()).append(this.getUrlOfProfile(user2)).toString();
    }

    @NotNull
    public String getAbsoluteProfileUrl(@NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.getAbsoluteProfileUrl((XdUser)XdExtensionsKt.toXd((Entity)user2));
    }

    @Override
    @NotNull
    public String getAbsoluteProfileUrl(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        StringBuilder stringBuilder = new StringBuilder();
        YoutrackLocationService youtrackLocationService = this.locationService;
        if (youtrackLocationService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"locationService");
        }
        return stringBuilder.append(youtrackLocationService.getAbsolutePath()).append(this.getUrlOfProfile(user2)).toString();
    }

    private final String getUrlOfProfile(XdUser user2) {
        return "/users/" + user2.getLogin();
    }

    @Override
    @NotNull
    public String getNotificationProfileUrl(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.getProfileUrl(user2) + "?tab=notifications";
    }

    @NotNull
    public GeneralUserProfile getGeneralUserProfile(@Nullable Entity user2) {
        if (user2 == null) {
            Companion.getLogger().error("Null argument in getGeneralUserProfile ", (Throwable)new IllegalStateException());
            return this.getGuestData().getGeneralProfile();
        }
        return this.getGeneralUserProfile((XdUser)XdExtensionsKt.toXd((Entity)user2));
    }

    @Override
    @NotNull
    public GeneralUserProfile getGeneralUserProfile(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.hasPersistentProfile(user2) ? (GeneralUserProfile)new PersistentGeneralUserProfile(user2) : this.getGuestData().getGeneralProfile();
    }

    @Override
    @NotNull
    public DisplayUserProfile getDisplayUserProfile(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.hasPersistentProfile(user2) ? (DisplayUserProfile)new PersistentDisplayUserProfile(user2) : this.getGuestData().getDisplayProfile();
    }

    @Override
    @NotNull
    public IssuesListUserProfile getIssuesListUserProfile(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.hasPersistentProfile(user2) ? (IssuesListUserProfile)new PersistentIssuesListUserProfile(user2) : this.getGuestData().getIssuesListProfile();
    }

    @Override
    @NotNull
    public NotificationsUserProfile getNotificationsProfile(@NotNull XdUser user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.hasPersistentProfile(user2) ? (NotificationsUserProfile)new PersistentNotificationsUserProfile(user2) : (NotificationsUserProfile)IMMUTABLE_NOTIFICATIONS_PROFILE;
    }

    @NotNull
    public UserSearchRequest getSearchRequest(@NotNull Entity user2) {
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        return this.getSearchRequest((XdUser)XdExtensionsKt.toXd((Entity)user2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public UserSearchRequest getSearchRequest(@NotNull XdUser user2) {
        UserSearchRequest userSearchRequest;
        Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
        if (this.hasPersistentProfile(user2)) {
            XdSearchRequest xdSearchRequest = XdUserExtKt.getSearchRequest(user2);
            if (xdSearchRequest == null) throw (Throwable)new IllegalArgumentException("User " + user2.getLogin() + " has no persistent search request, while it declared as it has one");
            XdSearchRequest xdSearchRequest2 = xdSearchRequest;
            boolean bl = false;
            boolean bl2 = false;
            XdSearchRequest it = xdSearchRequest2;
            boolean bl3 = false;
            userSearchRequest = new PersistentSearchRequest(user2, it);
            return userSearchRequest;
        } else {
            userSearchRequest = this.getGuestData().getSearchRequest();
        }
        return userSearchRequest;
    }

    private final GuestData getGuestData() {
        long value;
        HttpSession session;
        HttpServletRequest request;
        HttpServletRequest httpServletRequest = request = BaseApplication.getRequest();
        Object object = session = httpServletRequest != null ? httpServletRequest.getSession() : null;
        if (session == null || session.getId() == null) {
            return this.NO_SESSION_DATA;
        }
        String id = session.getId();
        long now = System.currentTimeMillis();
        GuestData result2 = this.guestProfiles.get(id);
        if (result2 == null) {
            result2 = new GuestData(this, session);
            this.guestProfiles.put(id, result2);
        }
        if ((value = this.nextCleanUp.get()) < now && this.nextCleanUp.compareAndSet(value, Long.MAX_VALUE)) {
            this.getQuartzThreadExecutor().execute(new Runnable(this){
                final /* synthetic */ UserProfileServiceImpl this$0;

                public final void run() {
                    LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                        final /* synthetic */ getGuestData.1 this$0;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke(@NotNull TransientStoreSession it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            long time = System.currentTimeMillis();
                            ArrayList<GuestData> victims = new ArrayList<GuestData>(10);
                            ConcurrentHashMap concurrentHashMap = UserProfileServiceImpl.access$getGuestProfiles$p(this.this$0.this$0);
                            boolean bl = false;
                            boolean bl2 = false;
                            synchronized (concurrentHashMap) {
                                boolean bl3 = false;
                                Iterator<V> itr = UserProfileServiceImpl.access$getGuestProfiles$p(this.this$0.this$0).values().iterator();
                                while (itr.hasNext()) {
                                    V v = itr.next();
                                    Intrinsics.checkExpressionValueIsNotNull(v, (String)"itr.next()");
                                    GuestData victim = (GuestData)v;
                                    if (!victim.isReadyToDie(time)) continue;
                                    victims.add(victim);
                                    itr.remove();
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            Iterable $this$forEach$iv = victims;
                            boolean $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                GuestData p1 = (GuestData)element$iv;
                                boolean bl4 = false;
                                p1.kill();
                            }
                            LegacySupportKt.flush();
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                    UserProfileServiceImpl.access$getNextCleanUp$p(this.this$0).set(System.currentTimeMillis() + 60000L);
                }
                {
                    this.this$0 = userProfileServiceImpl;
                }
            });
        }
        return result2;
    }

    private final boolean hasPersistentProfile(XdUser user2) {
        return user2.hasSearchRequest();
    }

    static {
        Companion = new Companion(null);
        IMMUTABLE_NOTIFICATIONS_PROFILE = new ImmutableNotificationsUserProfile();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getGuestProfiles$p(UserProfileServiceImpl $this) {
        return $this.guestProfiles;
    }

    public static final /* synthetic */ AtomicLong access$getNextCleanUp$p(UserProfileServiceImpl $this) {
        return $this.nextCleanUp;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Ljetbrains/charisma/service/UserProfileServiceImpl$GuestData;", "", "session", "Ljavax/servlet/http/HttpSession;", "(Ljetbrains/charisma/service/UserProfileServiceImpl;Ljavax/servlet/http/HttpSession;)V", "displayProfile", "Ljetbrains/charisma/plugin/DisplayUserProfile;", "getDisplayProfile", "()Ljetbrains/charisma/plugin/DisplayUserProfile;", "generalProfile", "Ljetbrains/charisma/plugins/GeneralUserProfile;", "getGeneralProfile", "()Ljetbrains/charisma/plugins/GeneralUserProfile;", "issuesListProfile", "Ljetbrains/charisma/plugin/IssuesListUserProfile;", "getIssuesListProfile", "()Ljetbrains/charisma/plugin/IssuesListUserProfile;", "searchRequest", "Ljetbrains/charisma/smartui/persistent/UserSearchRequest;", "getSearchRequest", "()Ljetbrains/charisma/smartui/persistent/UserSearchRequest;", "getSession", "()Ljavax/servlet/http/HttpSession;", "isReadyToDie", "", "now", "", "kill", "", "youtrack-application"})
    private final class GuestData {
        @NotNull
        private final GeneralUserProfile generalProfile;
        @NotNull
        private final DisplayUserProfile displayProfile;
        @NotNull
        private final IssuesListUserProfile issuesListProfile;
        @NotNull
        private final UserSearchRequest searchRequest;
        @Nullable
        private final HttpSession session;
        final /* synthetic */ UserProfileServiceImpl this$0;

        @NotNull
        public final GeneralUserProfile getGeneralProfile() {
            return this.generalProfile;
        }

        @NotNull
        public final DisplayUserProfile getDisplayProfile() {
            return this.displayProfile;
        }

        @NotNull
        public final IssuesListUserProfile getIssuesListProfile() {
            return this.issuesListProfile;
        }

        @NotNull
        public final UserSearchRequest getSearchRequest() {
            return this.searchRequest;
        }

        public final boolean isReadyToDie(long now) {
            boolean bl;
            HttpSession httpSession = this.session;
            if (httpSession != null) {
                boolean bl2;
                HttpSession httpSession2 = httpSession;
                boolean bl3 = false;
                boolean bl4 = false;
                HttpSession it = httpSession2;
                boolean bl5 = false;
                try {
                    bl2 = this.session.getLastAccessedTime() + (long)this.session.getMaxInactiveInterval() * 1000L < now;
                }
                catch (Exception e) {
                    bl2 = true;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }

        public final void kill() {
            block2: {
                HttpSession httpSession = this.session;
                if (httpSession == null) break block2;
                HttpSession httpSession2 = httpSession;
                boolean bl = false;
                boolean bl2 = false;
                HttpSession it = httpSession2;
                boolean bl3 = false;
                try {
                    it.invalidate();
                }
                catch (Throwable throwable) {
                }
            }
        }

        @Nullable
        public final HttpSession getSession() {
            return this.session;
        }

        public GuestData(@Nullable UserProfileServiceImpl $outer, HttpSession session) {
            this.this$0 = $outer;
            this.session = session;
            this.generalProfile = new InMemoryGeneralUserProfile();
            this.displayProfile = new InMemoryDisplayUserProfile();
            this.issuesListProfile = new InMemoryIssuesListUserProfile();
            this.searchRequest = new InMemoryUserSearchRequest();
        }

        public /* synthetic */ GuestData(UserProfileServiceImpl userProfileServiceImpl, HttpSession httpSession, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                httpSession = null;
            }
            this(userProfileServiceImpl, httpSession);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/charisma/service/UserProfileServiceImpl$Companion;", "Lmu/KLogging;", "()V", "DEFAULT_CLEANUP_INTERVAL", "", "IMMUTABLE_NOTIFICATIONS_PROFILE", "Ljetbrains/charisma/user/ImmutableNotificationsUserProfile;", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

