/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.eventSource;

import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.Resource;
import jetbrains.gap.resource.WebUtilsKt;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.eventSource.EventOutputContainer;
import jetbrains.youtrack.eventSource.EventOutputContainerImpl;
import jetbrains.youtrack.eventSource.EventSourceKt;
import jetbrains.youtrack.eventSource.TrackedEventOutput;
import jetbrains.youtrack.gaprest.exception.LocalizedNotAuthorizedException;
import jetbrains.youtrack.gaprest.filters.AuthIgnored;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.glassfish.jersey.media.sse.EventOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="eventSourceBus")
@AuthIgnored
@Produces(value={"text/event-stream"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0010\u001a\u00020\f2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aR\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tRN\u0010\n\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/eventSource/EventSourceBusResource;", "Ljetbrains/gap/resource/Resource;", "Ljetbrains/gap/resource/Entity;", "()V", "args", "Ljavax/ws/rs/core/UriInfo;", "connections", "Ljava/util/concurrent/atomic/AtomicLong;", "getConnections", "()Ljava/util/concurrent/atomic/AtomicLong;", "oneTimeTickets", "", "", "kotlin.jvm.PlatformType", "Ljetbrains/youtrack/eventSource/EventSourceBusResource$EventSourceTicket;", "", "createTicket", "initializer", "Lkotlin/Function2;", "Ljetbrains/youtrack/eventSource/EventOutputContainer;", "", "events", "Lorg/glassfish/jersey/media/sse/EventOutput;", "getConnectionsCount", "", "hasConnections", "", "Companion", "EventSourceTicket", "youtrack-application"})
public final class EventSourceBusResource
implements Resource<jetbrains.gap.resource.Entity> {
    @Context
    private UriInfo args;
    private final Map<String, EventSourceTicket> oneTimeTickets = Collections.synchronizedMap(new LinkedHashMap<String, EventSourceTicket>(){

        protected boolean removeEldestEntry(@Nullable Map.Entry<String, EventSourceTicket> eldest) {
            if (this.size() > 1000) {
                EventSourceBusResource.Companion.getLogger().debug("Will remove old ticket.");
                return true;
            }
            return false;
        }
    });
    public static final Companion Companion = new Companion(null);

    private final AtomicLong getConnections() {
        String name$iv = "liveUpdateConnectionsCounter";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.concurrent.atomic.AtomicLong");
        }
        return (AtomicLong)object;
    }

    @GET
    @NotNull
    public final EventOutput events() {
        String id;
        EventSourceTicket ticket;
        UriInfo uriInfo = this.args;
        if (uriInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        if ((ticket = this.oneTimeTickets.remove(id = WebUtilsKt.get((UriInfo)uriInfo, (String)"ticket"))) != null) {
            if (ticket.expired(System.currentTimeMillis())) {
                throw (Throwable)new LocalizedNotAuthorizedException("EventSource.expired_ticket_provided", new Object[]{id});
            }
            UriInfo uriInfo2 = this.args;
            if (uriInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"args");
            }
            return ticket.createOutput(uriInfo2, this.getConnections());
        }
        throw (Throwable)new LocalizedNotAuthorizedException("EventSource.invalid_ticket_provided", new Object[]{id});
    }

    @NotNull
    public final String createTicket(@NotNull Function2<? super EventOutputContainer, ? super UriInfo, Unit> initializer) {
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        EventSourceTicket ticket = new EventSourceTicket(initializer, null, 0L, BeansKt.getLoggedInUser(), 6, null);
        Map<String, EventSourceTicket> map2 = this.oneTimeTickets;
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"oneTimeTickets");
        map2.put(ticket.getId(), ticket);
        return ticket.getId();
    }

    public final boolean hasConnections() {
        return this.getConnections().get() > 0L;
    }

    public final long getConnectionsCount() {
        return this.getConnections().get();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/eventSource/EventSourceBusResource$EventSourceTicket;", "", "initializer", "Lkotlin/Function2;", "Ljetbrains/youtrack/eventSource/EventOutputContainer;", "Ljavax/ws/rs/core/UriInfo;", "", "id", "", "expires", "", "user", "Ljetbrains/exodus/database/TransientEntity;", "(Lkotlin/jvm/functions/Function2;Ljava/lang/String;JLjetbrains/exodus/database/TransientEntity;)V", "getId", "()Ljava/lang/String;", "getInitializer", "()Lkotlin/jvm/functions/Function2;", "getUser", "()Ljetbrains/exodus/database/TransientEntity;", "createOutput", "Lorg/glassfish/jersey/media/sse/EventOutput;", "uriInfo", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "expired", "", "now", "youtrack-application"})
    public static final class EventSourceTicket {
        @NotNull
        private final Function2<EventOutputContainer, UriInfo, Unit> initializer;
        @NotNull
        private final String id;
        private final long expires;
        @NotNull
        private final TransientEntity user;

        public final boolean expired(long now) {
            return this.expires < now;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final EventOutput createOutput(@NotNull UriInfo uriInfo, @NotNull AtomicLong counter) {
            Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
            Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
            TrackedEventOutput trackedEventOutput = new TrackedEventOutput(counter);
            boolean bl = false;
            boolean bl2 = false;
            TrackedEventOutput $this$apply = trackedEventOutput;
            boolean bl3 = false;
            Entity user$iv = (Entity)this.user;
            boolean $i$f$runAs = false;
            PrincipalManager _principalManager$iv = jetbrains.youtrack.core.security.BeansKt.getPrincipalManager();
            try {
                _principalManager$iv.setTemporaryServerPrincipal((Object)user$iv);
                boolean bl4 = false;
                this.initializer.invoke((Object)new EventOutputContainerImpl($this$apply, EventSourceKt.getOmitEventNames(uriInfo), this.id, this.user), (Object)uriInfo);
                $this$apply.afterInit();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                _principalManager$iv.unsetTemporaryServerPrincipal();
            }
            return trackedEventOutput;
        }

        @NotNull
        public final Function2<EventOutputContainer, UriInfo, Unit> getInitializer() {
            return this.initializer;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final TransientEntity getUser() {
            return this.user;
        }

        public EventSourceTicket(@NotNull Function2<? super EventOutputContainer, ? super UriInfo, Unit> initializer, @NotNull String id, long expires, @NotNull TransientEntity user2) {
            Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull((Object)user2, (String)"user");
            this.initializer = initializer;
            this.id = id;
            this.expires = expires;
            this.user = user2;
        }

        public /* synthetic */ EventSourceTicket(Function2 function2, String string, long l, TransientEntity transientEntity, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                String string2 = new BigInteger(150, EventSourceKt.getRng()).toString(32);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"BigInteger(150, rng).toString(32)");
                string = string2;
            }
            if ((n & 4) != 0) {
                l = System.currentTimeMillis() + (long)30000;
            }
            this((Function2<? super EventOutputContainer, ? super UriInfo, Unit>)function2, string, l, transientEntity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/eventSource/EventSourceBusResource$Companion;", "Lmu/KLogging;", "()V", "youtrack-application"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

