/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.logging;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.jetpass.api.settings.InternalSettings;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.Filter;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.client.accounts.SettingClient;
import jetbrains.jetpass.rest.dto.InternalSettingsJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import jetbrains.youtrack.api.misc.LogFile;
import jetbrains.youtrack.api.misc.LogFileService;
import jetbrains.youtrack.api.webr.LocalScoped;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.logging.Log4j2Factory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="logFileService")
@LocalScoped
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\"\u0010\u0018\u001a\u00020\u0016*\u00020\u00192\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002R0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/youtrack/logging/Log4j2FileService;", "Ljetbrains/youtrack/api/misc/LogFileService;", "()V", "value", "", "", "debugCategories", "getDebugCategories", "()Ljava/lang/Iterable;", "setDebugCategories", "(Ljava/lang/Iterable;)V", "myDebugCategories", "", "myTraceCategories", "sourceCategories", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/apache/logging/log4j/Level;", "getLogFiles", "Ljava/io/File;", "logFile", "Ljetbrains/youtrack/api/misc/LogFile;", "updateHubLogCategories", "", "categories", "setLevel", "Lorg/apache/logging/log4j/core/config/Configuration;", "level", "youtrack-application"})
public final class Log4j2FileService
implements LogFileService {
    private final ConcurrentHashMap<String, Level> sourceCategories = new ConcurrentHashMap();
    private volatile List<String> myDebugCategories;
    private volatile List<String> myTraceCategories;

    @NotNull
    public Iterable<File> getLogFiles(@NotNull LogFile logFile) {
        Intrinsics.checkParameterIsNotNull((Object)logFile, (String)"logFile");
        File logFolder = new File(Log4j2Factory.getLogFolder$default(Log4j2Factory.INSTANCE, null, 1, null));
        Object object = logFolder.listFiles(new FilenameFilter(logFile){
            final /* synthetic */ LogFile $logFile;

            public final boolean accept(File $noName_0, String name2) {
                String string = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                return StringsKt.startsWith$default((String)string, (String)this.$logFile.getNamePrefix(), (boolean)false, (int)2, null);
            }
            {
                this.$logFile = logFile;
            }
        });
        return object != null && (object = ArraysKt.toList((Object[])object)) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<String> getDebugCategories() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.myTraceCategories;
        Collection collection2 = this.myDebugCategories;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = (String)it + ":trace";
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection2, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    public void setDebugCategories(@NotNull Iterable<String> value) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        this.updateHubLogCategories(value);
        Iterable iterable = value;
        Log4j2FileService log4j2FileService = this;
        boolean $i$f$filter = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.endsWith$default((String)it, (String)":trace", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<String> collection = (List)destination$iv$iv;
        log4j2FileService.myDebugCategories = CollectionsKt.toList((Iterable)collection);
        $this$filter$iv = value;
        log4j2FileService = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, (String)":trace", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = StringsKt.replace$default((String)it, (String)":trace", (String)"", (boolean)false, (int)4, null);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        log4j2FileService.myTraceCategories = CollectionsKt.toList((Iterable)collection);
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        if (loggerContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
        }
        LoggerContext ctx = (LoggerContext)loggerContext;
        Configuration config = ctx.getConfiguration();
        Map $this$forEach$iv = this.sourceCategories;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void category;
            Map.Entry element$iv;
            Map.Entry $dstr$category$level = element$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$category$level;
            boolean bl3 = false;
            String string = (String)entry.getKey();
            entry = $dstr$category$level;
            bl3 = false;
            Level level = (Level)entry.getValue();
            LoggerConfig loggerConfig = config.getLoggerConfig((String)category);
            Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig, (String)"config.getLoggerConfig(category)");
            loggerConfig.setLevel(level);
        }
        Configuration configuration = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        this.setLevel(configuration, this.myDebugCategories, level);
        Level level2 = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
        this.setLevel(config, this.myTraceCategories, level2);
        ctx.updateLoggers();
    }

    private final void updateHubLogCategories(Iterable<String> categories) {
        if (BeansKt.getRingConfig().hasEmbeddedHub()) {
            SettingClient.Page settings2 = jetbrains.charisma.persistent.security.BeansKt.getRingApi().getRingClient().getSettingsClient().getSettingPage(new Filter(null, 1, null).query("type: internal"), (FieldPartial)Partial.settings((Partial.Settings[])new Partial.Settings[]{(Partial.Settings)Partial.InternalSettings.ID, (Partial.Settings)Partial.InternalSettings.DEBUG_CATEGORIES}));
            Object object = CollectionsKt.first((List)settings2.getSettings());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.api.settings.InternalSettings");
            }
            InternalSettings internalSettings = (InternalSettings)object;
            List addedCategories = CollectionsKt.minus((Iterable)CollectionsKt.toMutableList(categories), this.getDebugCategories());
            List removedCategories = CollectionsKt.minus((Iterable)CollectionsKt.toMutableList(this.getDebugCategories()), categories);
            Iterable iterable = internalSettings.getDebugCategories();
            if (iterable == null || (iterable = CollectionsKt.toMutableList((Iterable)iterable)) == null) {
                boolean bl = false;
                iterable = new ArrayList();
            }
            List hubCategories = CollectionsKt.minus((Iterable)CollectionsKt.plus((Collection)((Collection)iterable), (Iterable)addedCategories), (Iterable)removedCategories);
            SettingClient settingClient = jetbrains.charisma.persistent.security.BeansKt.getRingApi().getRingClient().getSettingsClient();
            String string = internalSettings.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"internalSettings.id");
            InternalSettingsJSON internalSettingsJSON = new InternalSettingsJSON();
            String string2 = string;
            SettingClient settingClient2 = settingClient;
            boolean bl = false;
            boolean bl2 = false;
            InternalSettingsJSON it = internalSettingsJSON;
            boolean bl3 = false;
            it.setDebugCategories((Iterable)hubCategories);
            InternalSettingsJSON internalSettingsJSON2 = internalSettingsJSON;
            settingClient2.updateSetting(string2, (SettingsJSON)internalSettingsJSON2);
        }
    }

    private final void setLevel(@NotNull Configuration $this$setLevel, List<String> categories, Level level) {
        Iterable $this$forEach$iv = categories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LoggerConfig loggerConfig;
            String category = (String)element$iv;
            boolean bl = false;
            LoggerConfig currentConfig = $this$setLevel.getLoggerConfig(category);
            if ($this$setLevel.getLoggers().containsKey(category)) {
                loggerConfig = currentConfig;
            } else {
                LoggerConfig config;
                Property[] propertyArray;
                AppenderRef[] appenderRefArray;
                Collection $this$toTypedArray$iv;
                org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
                if (loggerContext == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
                }
                LoggerContext ctx = (LoggerContext)loggerContext;
                LoggerConfig loggerConfig2 = currentConfig;
                Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig2, (String)"currentConfig");
                Level level2 = loggerConfig2.getLevel();
                String string = String.valueOf(currentConfig.isIncludeLocation());
                List list = currentConfig.getAppenderRefs();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"currentConfig.appenderRefs");
                Collection collection = list;
                String string2 = string;
                String string3 = category;
                Level level3 = level2;
                boolean bl2 = true;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new AppenderRef[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                boolean bl3 = bl2;
                Level level4 = level3;
                String string4 = string3;
                String string5 = string2;
                AppenderRef[] appenderRefArray2 = appenderRefArray;
                List list2 = currentConfig.getPropertyList();
                if (list2 != null) {
                    Property[] propertyArray2;
                    $this$toTypedArray$iv = list2;
                    appenderRefArray = appenderRefArray2;
                    string2 = string5;
                    string3 = string4;
                    level3 = level4;
                    bl2 = bl3;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new Property[0]) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    bl3 = bl2;
                    level4 = level3;
                    string4 = string3;
                    string5 = string2;
                    appenderRefArray2 = appenderRefArray;
                    propertyArray = propertyArray2;
                } else {
                    propertyArray = null;
                }
                LoggerConfig loggerConfig3 = config = LoggerConfig.createLogger((boolean)bl3, (Level)level4, (String)string4, (String)string5, (AppenderRef[])appenderRefArray2, propertyArray, (Configuration)ctx.getConfiguration(), (org.apache.logging.log4j.core.Filter)currentConfig.getFilter());
                Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig3, (String)"config");
                loggerConfig3.setParent(currentConfig);
                $this$setLevel.addLogger(category, config);
                loggerConfig = config;
            }
            LoggerConfig config = loggerConfig;
            LoggerConfig loggerConfig4 = currentConfig;
            Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig4, (String)"currentConfig");
            this.sourceCategories.putIfAbsent(category, loggerConfig4.getLevel());
            LoggerConfig loggerConfig5 = config;
            Intrinsics.checkExpressionValueIsNotNull((Object)loggerConfig5, (String)"config");
            loggerConfig5.setLevel(level);
        }
    }

    public Log4j2FileService() {
        List list;
        Log4j2FileService log4j2FileService = this;
        boolean bl = false;
        log4j2FileService.myDebugCategories = list = CollectionsKt.emptyList();
        log4j2FileService = this;
        bl = false;
        log4j2FileService.myTraceCategories = list = CollectionsKt.emptyList();
    }
}

